<?php $__env->startSection('content'); ?>
    <dov class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3><?php echo e(isset($allClients) ? 'Clients List' : (isset($clientDetails) ? 'Client Meal Menu' : '')); ?></h3>
                </div>
                <div class="card-body">
                    <?php if(isset($allClients)): ?>
                        <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-hover">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-left" scope="col">S.No.</th>
                                        <th class="text-left" scope="col">Client (Name - Code)</th>
                                        <th class="text-left" scope="col">Contact Person</th>
                                        <th class="text-left" scope="col">Phone No.</th>
                                        <th scope="col" class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $allClients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <th class="text-left" scope="row"><?php echo e($loop->iteration); ?></th>
                                            <td class="text-left"><?php echo e($client->name . ' - ' . $client->username); ?></td>
                                            <td class="text-left"><?php echo e($client->contactName); ?></td>
                                            <td class="text-left"><?php echo e($client->contactNumber); ?></td>
                                            <td class="d-flex justify-content-center">
                                                <a href="<?php echo e(url('vendor/client_detail/'.$client->clientId)); ?>" title="Menu" class="btn btn-info mx-2 font-weight-bold">View Client</a>
                                                <a href="<?php echo e(url('vendor/view/clients/'.$client->clientId)); ?>" title="Menu" class="btn btn-info mx-2 font-weight-bold">View Menu</i></a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="7" align="center">Not Found any</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php elseif(isset($clientDetails)): ?>
                        <form action="<?php echo e(isset($menu) ? url('vendor/update/menu') : url('vendor/meal/menu')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php if(isset($menu)): ?>
                                <input type="hidden" name="requestId" value="<?php echo e($menu->id); ?>" />
                            <?php endif; ?>
                            <!-- Client Info -->
                            <div class="row">
                                <?php
                                    $dt_min = new DateTime('-10 minutes');
                                    $dt_min = $dt_min->format('Y-m-d\TH:i');
                                    if(isset($menu)){
                                        $datetime_from = new DateTime($menu->from_time);
                                        $datetime_from = $datetime_from->format('Y-m-d\TH:i');
                                        $datetime_to = new DateTime($menu->to_time);
                                        $datetime_to = $datetime_to->format('Y-m-d\TH:i');
                                    }
                                ?>
                                <div class="form-group col">
                                    <label for="clientId">Client (Name - Code)</label>
                                    <input class="form-control" type="text" value="<?php echo e($clientDetails->name.' - '.$clientDetails->username); ?>" id="clientId" readonly />
                                    <input type="hidden" name="clientId" value="<?php echo e($clientDetails->id); ?>" />
                                    <input type="hidden" name="vendorId" value="<?php echo e(Auth::user()->id); ?>" />
                                </div>
                                <div class="form-group col">
                                    <label for="fromtime">Client Menu From</label>
                                    <input class="form-control" name="from_time" min="<?php echo e($dt_min); ?>" value="<?php echo e(isset($menu) ? $datetime_from : ''); ?>" type="datetime-local" placeholder="Meal from.." id="fromtime" required />
                                </div>
                                <div class="form-group col">
                                    <label for="totime">Client Menu To</label>
                                    <input class="form-control" name="to_time" min="<?php echo e($dt_min); ?>" value="<?php echo e(isset($menu) ? $datetime_to : ''); ?>" type="datetime-local" placeholder="Meal to.." id="totime" required />
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col">
                                    <p style="margin-bottom: .55rem;">Upload Menu</p>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="menu" lang="es" name="menu" onchange="putName(this);" accept=".doc, .pdf" required />
                                        <label class="custom-file-label" for="menu">Menu</label>
                                    </div>
                                </div>
                                <div class="form-group col">
                                    <label for="suggestion">Suggestion Box</label>
                                    <textarea name="suggestion" class="form-control" id="suggestion" readonly><?php echo isset($menu) ? $menu->client_meal_comment : ''; ?></textarea>
                                </div>
                            </div>
                            <?php if(isset($menu) && isset($menu->morning_meal)): ?>
                                <div class="row">
                                    <div class="form-group col-3">
                                        <label for="uploaded_menu">Uploaded Menu: </label>
                                        <a href="<?php echo e(url('public/storage/menu/vendors').'/'.$menu->vendorId.'/'.$menu->morning_meal); ?>" target="_blank" class="btn btn-primary font-weight-bold">Menu</a>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <!-- Submit -->
                            <div class="row">
                                <div class="update ml-auto mr-auto">
                                    <?php if(!isset($menu)): ?>
                                        <button type="submit" class="turquoise">Submit</button>
                                    <?php elseif(isset($menu)): ?>
                                        <button type="submit" class="sunflower">Edit</button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.masterDashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp7.4\htdocs\foodycraft\app/Modules/Vendor/Views/clientMenu.blade.php ENDPATH**/ ?>