<?php
    // dd("Concern View", $concerns);
?>

<?php $__env->startSection('content'); ?>
    <style>
        .mx-75{
            max-width: 75%;
        }
        div#allMsg::-webkit-scrollbar-thumb {
            border-radius: unset;
            border-top-left-radius: 10px;
            border-bottom-left-radius: 10px;
        }
        .common{
            border-radius: 5px;
            display: inline-block;
            padding: 10px;
            color: #fff;
            font-weight: lighter;
            font-size: small;
            box-shadow: 1px 1px 2px rgba(0,0,0,.3);
            margin: 5px;
            position: relative;
        }
        .common.sender{
            background: #72b8ff;
            float: left;
            clear: both;
            border-top-left-radius: 0px;
        }
        .common.receiver{
            background: #00D025;
            float: right;
            clear: both;
            border-top-right-radius: 0px;
        }
        .common.sender:before, .common.receiver:before{
            content: "";
            width: 0px;
            height: 0px;
            display: block;
            position: absolute;
            top: 0px;
        }
        .common.sender:before{
            border-left: 5px solid transparent;
            border-right: 5px solid #72b8ff;
            border-top: 5px solid #72b8ff;
            border-bottom: 5px solid transparent;
            left: -10px;
        }
        .common.receiver:before{
            border-left: 5px solid #00D025;
            border-right: 5px solid transparent;
            border-top: 5px solid #00D025;
            border-bottom: 5px solid transparent;
            right: -10px;
        }
    </style>
    <div class="row">
        <div class="col-md-12">
            <div class="main-card mb-3 card">
                <div class="card-header pt-4 d-flex justify-content-center border-0">
                    <h3>All Concerns</h3>
                </div>
                <div class="card-body">
                    <?php if(isset($concerns)): ?>
                        <div class="table-responsive p-2" style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-hover">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-center" scope="col">S.No.</th>
                                        <th class="text-center" scope="col">Description of Concern</th>
                                        <th class="text-center" scope="col">Client Name</th>
                                        <th class="text-center" scope="col">Client Code</th>
                                        <th class="text-center" scope="col">Status</th>
                                        <th scope="col" class="d-flex justify-content-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $concerns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $concern): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php
                                            // dd($concern);
                                        ?>
                                        <tr>
                                            <td class="text-center" scope="row"><?php echo e(++$key); ?></td>
                                            <td class="text-center"><?php echo e($concern->description); ?></td>
                                            <td class="text-center"><?php echo e($concern->name); ?></td>
                                            <td class="text-center"><?php echo e($concern->username); ?></td>
                                            <td class="text-center">
                                                <div class="badge badge-info"><?php echo e($concern->status); ?></div>
                                            </td>
                                            <td class="d-flex justify-content-center">
                                                <div class="peterriver" style="padding: .3rem .2rem;" onclick="redirection('<?php echo e(url('vendor/concerns').'/'.$concern->id); ?>');">View</div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="7" align="center">No Concerns Raised Yet!</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php elseif(isset($concern)): ?>
                        <?php
                            $imageList = isset($concern->images) ? explode(", ", $concern->images) : [];
                            $imagePath = asset('public/storage/concerns/client').'/'.$concern->clientId.'/';
                        ?>
                        <div class="container-fluid mb-1">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-12 col-sm-12">
                                            <div class="form-group">
                                                <label for="description">Description of Concern</label>
                                                <input type="text" name="description" value="<?php echo e($concern->description); ?>" class="form-control" id="description" disabled />
                                            </div>
                                        </div>
                                        <div class="col-md-12 col-sm-12">
                                            <div class="form-group">
                                                <label for="client_name">Client Name</label>
                                                <input type="text" name="client_name" value="<?php echo e($concern->client_name); ?>" class="form-control" id="client_name" disabled />
                                            </div>
                                        </div>
                                        <div class="col-md-12 col-sm-12">
                                            <div class="form-group">
                                                <label for="client_code">Client Code</label>
                                                <input type="text" name="client_code" value="<?php echo e($concern->client_code); ?>" class="form-control" id="client_code" disabled />
                                            </div>
                                        </div>
                                        <div class="col-md-12 col-sm-12">
                                            <div class="form-group">
                                                <label for="contact_person">Contact Person</label>
                                                <input type="text" name="contact_person" value="<?php echo e($concern->client_contact_person); ?>" class="form-control" id="contact_person" disabled />
                                            </div>
                                        </div>
                                        <div class="col-md-12 col-sm-12">
                                            <div class="form-group">
                                                <label for="contact_number">Contact Number</label>
                                                <input type="text" name="contact_number" value="<?php echo e($concern->client_number); ?>" class="form-control" id="contact_number" disabled />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 col-sm-12">
                                            <div class="form-group">
                                                <label for="comment">Comment</label>
                                                <textarea class="form-control" id="comment" name="comment" style="resize: none;" rows="2" readonly><?php echo e($concern->comment); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="d-flex flex-wrap justify-content-center" id="preview">
                                                <?php $__empty_1 = true; $__currentLoopData = $imageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imageName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <img class="rounded m-2" style="box-shadow: 0 0.2rem 0.6rem rgba(0, 0, 0, 0.25) !important;" src="<?php echo e($imagePath.$imageName); ?>" alt="Concerned Images.." width="150" height="100" />
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <div class="badge badge-info mb-4" style="font-size: 1rem;">No Images</div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="main-card card my-2 shadow-sm" style="height: 70%;max-height: 400px;border: 2px solid #fff; border-radius: 9px;">
                                        <div class="card-header p-2 border-bottom-0" style="background-color: #efefef !important;border-top-right-radius: 5px;border-top-left-radius: 5px;">
                                            <h5 class="text-center w-100 m-0" style="color: #000;">Discussion Board</h5>
                                        </div>
                                        <div class="card-body p-1" style="height: inherit;">
                                            <div class="flex flex-column px-2" id="allMsg" style="overflow-y: scroll;height: 100%;">
                                                <?php $__empty_1 = true; $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <div class="d-flex flex-row px-2 py-1 justify-content-<?php echo e(Auth::user()->username !== $message->sender ? 'start' : 'end'); ?>">
                                                        <div class="common mx-75 <?php echo e(Auth::user()->username !== $message->sender ? 'sender' : 'receiver'); ?>">
                                                            <?php if(Auth::user()->username !== $message->sender): ?>
                                                                <div class="d-flex flex-row justify-content-start">
                                                                    <span class="text-secondary"><?php echo e($message->sender); ?></span>
                                                                </div>
                                                            <?php endif; ?>
                                                            <span class="text-white <?php echo e(Auth::user()->username !== $message->sender ? 'ml-1' : 'mr-3'); ?>">
                                                                <?php echo e($message->messages); ?>

                                                            </span>
                                                            <div class="d-flex flex-row justify-content-end ml-2">
                                                                <small class="text-muted"><?php echo e(date('dM H:i', strtotime($message->created_at))); ?></small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <div class="d-flex flex-row px-2 py-1 justify-content-center">
                                                        <p class="badge" style="background: #efe7e7;color: cadetblue;">No Chats Yet!</p>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="card-footer p-2" style="background-color: #e8e8e887 !important;border-bottom-right-radius: 5px;border-bottom-left-radius: 5px;">
                                            <div class="input-group" title="Not Working Right Now.">
                                                <div class="input-group-prepend mx-1">
                                                    <span class="input-group-text rounded" id="smile">
                                                        <i class="fa fa-smile-o" aria-hidden="true"></i>
                                                    </span>
                                                </div>
                                                <div class="form-control" id="concern_msg" dir="ltr" spellcheck="false" data-text="Enter your message..." contenteditable="true" style="border-radius: 4px; overflow-y: hidden; cursor: text; color: dimgray;"></div>
                                                <?php $newurl = url('vendor/concern/message'); ?>
                                                <div class="input-group-append mx-1" onclick="sendToConcernForm('<?php echo e($concern->id); ?>', '<?php echo e($concern->status); ?>', '<?php echo e($newurl); ?>')">
                                                    <span class="input-group-text rounded" id="send">
                                                        <i class="fa fa-send" aria-hidden="true"></i>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row d-flex justify-content-center">
                            <div class="update">
                                <div class="wetasphalt" style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;" onclick="redirection('<?php echo e(url()->previous()); ?>');">Back</div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.masterDashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexaipaybr/public_html/foodycraft/app/Modules/Vendor/Views/concern.blade.php ENDPATH**/ ?>