
<?php $__env->startSection('content'); ?>
    <style>
        .multisteps-form__progress {
          display: grid;
          grid-template-columns: repeat(auto-fit, minmax(0, 1fr));
        }

        .multisteps-form__progress-btn {
          transition-property: all;
          transition-duration: 0.15s;
          transition-timing-function: linear;
          transition-delay: 0s;
          position: relative;
          padding-top: 20px;
          color: rgba(108, 117, 125, 0.7);
          text-indent: -9999px;
          border: none;
          background-color: transparent;
          outline: none !important;
          cursor: pointer;
        }

        @media (min-width: 500px) {
          .multisteps-form__progress-btn {
            text-indent: 0;
          }
        }

        .multisteps-form__panel[data-animation=slideHorz].js-active {
          transition-property: all;
          transition-duration: .25s;
          transition-timing-function: cubic-bezier(.2,1.13,.38,1.43);
          transition-delay: 0s;
          left: 0;
        }
        .multisteps-form__panel[data-animation=slideHorz] {
          left: 50px;
        }

        .multisteps-form__progress-btn:before {
          position: absolute;
          top: 0;
          left: 50%;
          display: block;
          width: 13px;
          height: 13px;
          content: '';
          -webkit-transform: translateX(-50%);
          transform: translateX(-50%);
          transition: all 0.15s linear 0s, -webkit-transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s;
          transition: all 0.15s linear 0s, transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s;
          transition: all 0.15s linear 0s, transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s, -webkit-transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s;
          border: 2px solid currentColor;
          border-radius: 50%;
          background-color: #fff;
          box-sizing: border-box;
          z-index: 3;
        }

        .multisteps-form__progress-btn:after {
          position: absolute;
          top: 5px;
          left: calc(-50% - 13px / 2);
          transition-property: all;
          transition-duration: 0.15s;
          transition-timing-function: linear;
          transition-delay: 0s;
          display: block;
          width: 100%;
          height: 2px;
          content: '';
          background-color: currentColor;
          z-index: 1;
        }

        .multisteps-form__progress-btn:first-child:after {
          display: none;
        }

        .multisteps-form__progress-btn.js-active {
          color: #007bff;
        }

        .multisteps-form__progress-btn.js-active:before {
          -webkit-transform: translateX(-50%) scale(1.2);
          transform: translateX(-50%) scale(1.2);
          background-color: currentColor;
        }

        .multisteps-form__form {
          position: relative;
        }

        .multisteps-form__panel {
          position: absolute;
          top: 0;
          left: 0;
          width: 100%;
          height: 0;
          opacity: 0;
          visibility: hidden;
        }

        .multisteps-form__panel.js-active {
          height: auto;
          opacity: 1;
          visibility: visible;
        }
    </style>
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm mb-3">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Map Roles</h3>
                </div>
                <div class="card-body multisteps-form">
                    <!--progress bar-->
                    <div class="row">
                        <div class="col-12 col-lg-8 ml-auto mr-auto mt-1">
                            <div class="multisteps-form__progress">
                                <button onclick="call_client();return false;" class="multisteps-form__progress-btn js-active" type="button" data-toggle="tooltip" title="Click to see Clients List">Client</button>
                                <button onclick="call_vendor();return false;" class="multisteps-form__progress-btn" type="button" data-toggle="tooltip" title="Click to see Vendors List">Vendor</button>
                                <button onclick="call_sitemarshal();return false;" class="multisteps-form__progress-btn" type="button" data-toggle="tooltip" title="Click to see Marshals List">Marshals</button>
                                <button class="multisteps-form__progress-btn" type="button" data-toggle="tooltip" title="Related Information">Related Information</button>
                                <button class="multisteps-form__progress-btn" type="button" data-toggle="tooltip" title="Confirm Your Actions">Confirm</button>
                            </div>
                        </div>
                    </div>
                    <form method="POST" action="<?php echo e(url('mapTableForm')); ?>" class="multisteps-form__form">
                        <?php echo csrf_field(); ?>
                        <?php
                            $noClient = $noVendor = $noMarshal = 0;
                        ?>
                        <!-- Client -->
                        <div class="multisteps-form__panel p-4 bg-white js-active" data-animation="slideHorz">
                            <div class="multisteps-form__content">
                                <div class="row">
                                    <div class="col-12 mt-2">
                                        <div class="card shadow-none">
                                            <div class="border-bottom-0 px-4">
                                                <div class="container">
                                                    <div class="row px-4 d-flex justify-content-end">
                                                        <div>
                                                            <input type="text" onblur="empty_karo(this);" onkeyup="search(event, 'client');" placeholder="Search by name.." class="form-control p-2 h-75" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-1">
                                                <table class="table table-hover">
                                                    <thead class="text-dark">
                                                        <tr>
                                                            <th class="text-center" scope="col">S.No.</th> 
                                                            <th class="text-center" scope="col">Client Name</th>
                                                            <th class="text-center" scope="col">Client Code</th>
                                                            <th class="text-center" scope="col">Contact Person</th>
                                                            <th class="text-center" scope="col">Contact No.</th>
                                                            <th class="text-center" scope="col">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="tab" id="stepclient">
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="card-footer p-0 my-2 border-bottom-0 border-top-0 text-center d-flex justify-content-center" style="align-self: center;color: #d45353;">
                                                <div class="d-flex justify-content-around">
                                                    <button class="btn btn-light mx-2 py-1 px-2 w-auto" onclick="previous_request('client');return false;" id="previous">
                                                        <i class="fa fa-angle-left"></i>
                                                    </button>
                                                    <button class="btn btn-light mx-2 py-1 px-2 w-auto" onclick="next_request('client');return false;" id="next">
                                                        <i class="fa fa-angle-right"></i>
                                                    </button>
                                                    <button class="btn btn-light mx-2 p-1 px-2 font-weight-bold" onclick="last_request('client');return false;" id="last">Last</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="button-row d-flex mt-4 col-12">
                                        <button class="wetasphalt ml-auto js-btn-next" onclick="call_vendor();return false;" type="button">Next</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Vendor -->
                        <div class="multisteps-form__panel p-4 bg-white" data-animation="slideHorz">
                            <div class="multisteps-form__content">
                                <div class="row">
                                    <div class="col-12 mt-2">
                                        <div class="card shadow-none">
                                            <div class="border-bottom-0 px-4">
                                                <div class="container">
                                                    <div class="row px-4 d-flex justify-content-end">
                                                        <div>
                                                            <input type="text" onblur="empty_karo(this);" onkeyup="search(event, 'vendor');" placeholder="Search by name.." class="form-control p-2 h-75" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-1">
                                                <table class="table table-hover">
                                                    <thead class="text-dark">
                                                        <tr>
                                                            <th class="text-center" scope="col">S.No.</th> 
                                                            <th class="text-center" scope="col">Vendor Name</th>
                                                            <th class="text-center" scope="col">Vendor Code</th>
                                                            <th class="text-center" scope="col">Contact Person</th>
                                                            <th class="text-center" scope="col">Contact No.</th>
                                                            <th class="text-center" scope="col">Vendor Type</th>
                                                            <th class="text-center" scope="col">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="tab" id="stepvendor">
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="card-footer p-0 my-2 border-bottom-0 border-top-0 text-center d-flex justify-content-center" style="align-self: center;color: #d45353;">
                                                <div class="d-flex justify-content-around">
                                                    <button class="btn btn-light mx-2 py-1 px-2 w-auto" onclick="previous_request('vendor');return false;" id="previous">
                                                        <i class="fa fa-angle-left"></i>
                                                    </button>
                                                    <button class="btn btn-light mx-2 py-1 px-2 w-auto" onclick="next_request('vendor');return false;" id="next">
                                                        <i class="fa fa-angle-right"></i>
                                                    </button>
                                                    <button class="btn btn-light mx-2 p-1 px-2 font-weight-bold" onclick="last_request('vendor');return false;" id="last">Last</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="button-row d-flex mt-4 col-12">
                                        <button class="wetasphalt js-btn-prev" onclick="call_click();return false;" type="button">Prev</button>
                                        <button class="wetasphalt ml-auto js-btn-next" onclick="call_sitemarshal();return false;" type="button">Next</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Site Marshal -->
                        <div class="multisteps-form__panel p-4 bg-white" data-animation="slideHorz">
                            <div class="multisteps-form__content">
                                <div class="row">
                                    <div class="col-12 mt-2">
                                        <div class="card shadow-none">
                                            <div class="border-bottom-0 px-4">
                                                <div class="container">
                                                    <div class="row px-4 d-flex justify-content-end">
                                                        <div>
                                                            <input type="text" onblur="empty_karo(this);" onkeyup="search(event, 'sitemarshal');" placeholder="Search by name.." class="form-control p-2 h-75" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-1">
                                                <table class="table table-hover">
                                                    <thead class="text-dark">
                                                        <tr>
                                                            <th class="text-center" scope="col">S.No.</th> 
                                                            <th class="text-center" scope="col">FK Team Name</th>
                                                            <th class="text-center" scope="col">Employee ID</th>
                                                            <th class="text-center" scope="col">Contact No.</th>
                                                            <th class="text-center" scope="col">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="tab" id="stepmarshal">
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="card-footer p-0 my-2 border-bottom-0 border-top-0 text-center d-flex justify-content-center" style="align-self: center;color: #d45353;">
                                                <div class="d-flex justify-content-around">
                                                    <button class="btn btn-light mx-2 py-1 px-2 w-auto" onclick="previous_request('sitemarshal');return false;" id="previous">
                                                        <i class="fa fa-angle-left"></i>
                                                    </button>
                                                    <button class="btn btn-light mx-2 py-1 px-2 w-auto" onclick="next_request('sitemarshal');return false;" id="next">
                                                        <i class="fa fa-angle-right"></i>
                                                    </button>
                                                    <button class="btn btn-light mx-2 p-1 px-2 font-weight-bold" onclick="last_request('sitemarshal');return false;" id="last">Last</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="button-row d-flex mt-4 col-12">
                                        <button class="wetasphalt js-btn-prev" onclick="call_vendor();return false;" type="button">Prev</button>
                                        <button class="wetasphalt ml-auto js-btn-next" type="button">Next</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Vendor & Marshal Values -->
                        <div class="multisteps-form__panel pt-2 px-2 bg-white" data-animation="slideHorz">
                            <div class="multisteps-form__content">
                                <div class="accordion" id="accordionExample">
                                    <div class="card">
                                        <div class="card-header" id="headingOne">
                                            <h2 class="mb-0 w-100">
                                                <button class="btn btn-link btn-block text-left text-decoration-none" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                                    <div class="d-flex justify-content-center my-2">
                                                        <div class="badge badge-info w-50" style="font-size: 1.2rem;">Vendors</div>
                                                    </div>
                                                </button>
                                            </h2>
                                        </div>
                                        <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                                            <div class="card-body px-3 py-1">
                                                <table class="table">
                                                    <thead class="text-dark">
                                                        <tr>
                                                            <th class="text-center">S.No.</th>
                                                            <th class="text-center">Name</th>
                                                            <th class="text-center">Username</th>
                                                            <th class="text-center">Contact Name</th>
                                                            <th class="text-center">Contact Number</th>
                                                            <th class="text-center">Aggregation Fees</th>
                                                            <th class="text-center">Timing for Meals</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="tab" id="vendorTimingFees"></tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="headingTwo">
                                            <h2 class="mb-0 w-100">
                                                <button class="btn btn-link btn-block text-left collapsed text-decoration-none" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                                    <div class="d-flex justify-content-center my-2">
                                                        <div class="badge badge-info w-50" style="font-size: 1.2rem;">Site Marshals</div>
                                                    </div>
                                                </button>
                                            </h2>
                                        </div>
                                        <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                            <div class="card-body px-3 py-1">
                                                <table class="table">
                                                    <thead class="text-dark">
                                                        <tr>
                                                            <th class="text-center">S.No.</th>
                                                            <th class="text-center">Name</th>
                                                            <th class="text-center" scope="col">Employee ID</th>
                                                            <th class="text-center" scope="col">Contact Person</th>
                                                            <th class="text-center" scope="col">Contact No.</th>
                                                            <th class="text-center">Timings</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="tab" id="marshalTiming"></tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="headingThree">
                                            <h2 class="mb-0 w-100">
                                                <button class="btn btn-link btn-block text-left collapsed text-decoration-none" type="button" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                                    <div class="d-flex justify-content-center my-2">
                                                        <div class="badge badge-info w-50" style="font-size: 1.2rem;">Promised Commitments</div>
                                                    </div>
                                                </button>
                                            </h2>
                                        </div>
                                        <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
                                            <div class="card-body px-3 py-2">
                                                <textarea name="commitment" class="form-control" id="commitment" placeholder="Commitment"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="button-row d-flex mt-4 col-12">
                                        <button class="wetasphalt js-btn-prev" type="button">Prev</button>
                                        <button class="wetasphalt ml-auto js-btn-next" type="button">Next</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--single form panel { SUBMIT }-->
                        <div class="multisteps-form__panel p-4 bg-white" data-animation="slideHorz">
                            <div class="multisteps-form__content">
                                <div class="row">
                                    <div class="col-12 mt-2">
                                        <div class="card shaow none">
                                            <div class="card-body p-1">
                                                <div class="d-flex justify-content-center my-2">
                                                    <div class="badge badge-info w-50" style="font-size: 1.2rem;">Client</div>
                                                </div>
                                                <table class="table">
                                                    <thead class="text-dark">
                                                        <tr>
                                                            <th class="text-center" scope="col">S.No.</th> 
                                                            <th class="text-center" scope="col">Name</th>
                                                            <th class="text-center" scope="col">Client Code</th>
                                                            <th class="text-center" scope="col">Contact Person</th>
                                                            <th class="text-center" scope="col">Contact No.</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="tab" id="client"></tbody>
                                                </table>
                                                <div class="d-flex justify-content-center my-2">
                                                    <div class="badge badge-info w-50" style="font-size: 1.2rem;">Vendor</div>
                                                </div>
                                                <table class="table">
                                                    <thead class="text-dark">
                                                        <tr>
                                                            <th class="text-center" scope="col">S.No.</th> 
                                                            <th class="text-center" scope="col">Name</th>
                                                            <th class="text-center" scope="col">Vendor Code</th>
                                                            <th class="text-center" scope="col">Contact Person</th>
                                                            <th class="text-center" scope="col">Contact No.</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="tab" id="vendor"></tbody>
                                                </table>
                                                <div class="d-flex justify-content-center my-2">
                                                    <div class="badge badge-info w-50" style="font-size: 1.2rem;">Marshal</div>
                                                </div>
                                                <table class="table">
                                                    <thead class="text-dark">
                                                        <tr>
                                                            <th class="text-center" scope="col">S.No.</th> 
                                                            <th class="text-center" scope="col">Name</th>
                                                            <th class="text-center" scope="col">Employee ID</th>
                                                            <th class="text-center" scope="col">Contact Person</th>
                                                            <th class="text-center" scope="col">Contact No.</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="tab" id="marshal"></tbody>
                                                </table>
                                                
                                                
                                            </div>
                                            
                                            
                                            
                                            <div class="card-footer d-flex flex-column">
                                                <h4 class="text-center">
                                                    <code>Confirm Your Action</code>
                                                </h4>
                                                <div class="button-row d-flex my-2 col-12 justify-content-center">
                                                    <button class="wetasphalt mr-4 js-btn-prev" type="button">Prev</button>
                                                    <?php if($noClient !== 1 && $noVendor !== 1 && $noMarshal !== 1): ?>
                                                        <button class="turquoise ml-4 js-btn-next" type="submit">Map</button>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->startSection('customscript'); ?>
        <script src="<?php echo e(asset('public/js/progressTableForm.js')); ?>"></script>
        <script>
            marshals = [];
            vendors = [];
            clients = [];
            var next = "";
            var previous = "";
            var last = "";

            $(function () {
                call_client();
            });

            function call_client(){
                var link = "<?php echo e(url('mapTableForm').'/'.'client'); ?>";
                request_role_data(link, 'client');
            }

            function call_vendor(){
                var link = "<?php echo e(url('mapTableForm').'/'.'vendor'); ?>";
                request_role_data(link, 'vendor');
            }

            function call_sitemarshal(){
                var link = "<?php echo e(url('mapTableForm').'/'.'sitemarshal'); ?>";
                request_role_data(link, 'sitemarshal');
            }

            function search(e, role){
                // console.log(e.target.value);
                var search = e.target.value.trim();
                if(search !== null || search !== ""){
                    var link = "<?php echo e(url('mapTableForm')); ?>" + "/" + role + "/" + search;
                    request_role_data(link, role);
                }
            }

            function request_role_data(link, role_type){
                $roles = $.ajax({
                    type        : 'GET',
                    url         : link,
                    beforeSend: function(){
                        $("td#load_data").css({'display': 'table-cell'});
                    },
                    success     : function(res){
                        console.log(res);
                        generate_pagination_links(res);
                        if(role_type == 'client'){
                            $("tbody#stepclient").html(res.client);
                        }else if(role_type == 'vendor'){
                            $("tbody#stepvendor").html(res.vendor);
                        }else if(role_type == 'sitemarshal'){
                            $("tbody#stepmarshal").html(res.sitemarshal);
                        }
                    },
                    complete:function(data){
                        $("td#load_data").css({'display': 'none'});
                    },
                    error       : function(xhr, textStatus, errorThrown){
                        console.log(errorThrown, textStatus);
                    }
                });
            }

            function generate_pagination_links(res){
                if(res.current_page == 1){
                    $('button#previous').prop('disabled', true);
                }else{
                    $('button#previous').prop('disabled', false);
                }
                if(res.current_page == res.last_page){
                    $('button#next').prop('disabled', true);
                    $('button#last').prop('disabled', true);
                }else{
                    $('button#next').prop('disabled', false);
                    $('button#last').prop('disabled', false);
                }
                next = res.next_page_url;
                previous = res.prev_page_url;
                last = res.last_page_url;
                // console.log("Next: " + next);
                // console.log("Previous: " + previous);
                // console.log("Last: " + last);
            }

            function next_request(role){
                request_role_data(next, role);
            }

            function previous_request(role){
                request_role_data(previous, role);
            }

            function last_request(role){
                request_role_data(last, role);
            }

            function empty_karo(element){
                console.log(element.value);
                element.value = "";
                var link = "<?php echo e(url('mapTableForm')); ?>";
                request_role_data(link);
            }

            function functiontofindIndexByKeyValue(arraytosearch, key, valuetosearch){
                for (var i = 0; i < arraytosearch.length; i++) {
                    if (arraytosearch[i][key] == valuetosearch) {
                        return i;
                    }
                }
                return null;
            }
        
            function checkClients(val){
                clients = [];
                clients.push(val);
                console.log(clients);
                createClientsTable(clients);
            }
        
            function createClientsTable(value){
                var clientBody = document.getElementById('client');
                clientBody.innerHTML = '';
                var td = "";
                var tr = "";
                var s_no = "";
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    clientBody.appendChild(tr);
                });
            }
        
            function checkVendors(val){
                if (!val.currentElement.control.checked){
                    vendors.push(val);
                } else if (val.currentElement.control.checked){
                    indexToPop = functiontofindIndexByKeyValue(vendors, "email", val['email']);
                    vendors.splice(indexToPop, 1);
                }
                createVendorsTable(vendors);
                createVendorInputs(vendors);
            }
        
            function createVendorsTable(value){
                var venBody = document.getElementById('vendor');
                venBody.innerHTML = '';
                var td = "";
                var tr = "";
                var s_no = "";
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    venBody.appendChild(tr);
                });
            }
        
            function createVendorInputs(value){
                var venBody = document.getElementById('vendorTimingFees');
                venBody.innerHTML = '';
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'address' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    td = document.createElement('td');
                    td.classList.add("text-center");
                    var input = document.createElement('input');
                    input.classList.add("form-control");
                    input.setAttribute('type', 'text');
                    var aggr = "aggregation[" + el['id'] + "]";
                    input.setAttribute('name', aggr);
                    td.appendChild(input);
                    tr.appendChild(td);
                    td = document.createElement('td');
                    td.classList.add("text-center");
                    var textarea = document.createElement('textarea');
                    textarea.classList.add("form-control");
                    var mealTime = "mealTime[" + el['id'] + "]";
                    textarea.setAttribute('name', mealTime);
                    textarea.setAttribute('placeholder', 'Meal Timings');
                    td.appendChild(textarea);
                    tr.appendChild(td);
                    venBody.appendChild(tr);
                });
            }
        
            function checkMarshals(val){
                if (!val.currentElement.control.checked){
                    marshals.push(val);
                } else if (val.currentElement.control.checked){
                    indexToPop = functiontofindIndexByKeyValue(marshals, "email", val['email']);
                    marshals.splice(indexToPop, 1);
                }
                createMarshalsTable(marshals);
                createMarshalInputs(marshals);
            }
        
            function createMarshalsTable(value){
                var marBody = document.getElementById('marshal');
                marBody.innerHTML = '';
                var td = "";
                var tr = "";
                var s_no = "";
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    marBody.appendChild(tr);
                });
            }
        
            function createMarshalInputs(value){
                var marBody = document.getElementById('marshalTiming');
                marBody.innerHTML = '';
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'address' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    td = document.createElement('td');
                    td.classList.add("text-center");
                    var input = document.createElement('input');
                    input.classList.add("form-control");
                    input.setAttribute('type', 'text');
                    var marTime = "marTime[" + el['id'] + "]";
                    input.setAttribute('name', marTime);
                    td.appendChild(input);
                    tr.appendChild(td);
                    marBody.appendChild(tr);
                });
            }
        </script>
    <?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.masterDashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexaipaybr/public_html/foodycraft/app/Modules/Admin/Views/map/create_map.blade.php ENDPATH**/ ?>