<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>FoodsKraft Login</title>
     
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('public/css/assets/images/favicon.ico')); ?>">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:400,600,700&display=swap" rel="stylesheet">
    <link href="<?php echo e(asset('public/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('public/css/animate.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('public/fontAwesome/css/font-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/fontStyles/font.css')); ?>">
    <link href="<?php echo e(asset('public/css/flatUiButton.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset('public/css/ppfoods.css')); ?>" rel="stylesheet">

    <style>
      div.animatedlightSpeedIn{
        -webkit-animation-duration: 2s;
        -moz-animation-duration: 2s;
        animation-duration: 2s;
        -webkit-animation-name: fadeIn;
        animation-name: fadeIn;
        box-shadow: .8rem .8rem 0.1rem 0.1rem rgba(0,0,0,.075)!important;
      }
      label.animatedJackInTheBox::before {
        content: "\f00c";
        font-family: FontAwesome;
        font-size: 13px;
        color: transparent;
        justify-content: center;
        width: 15px;
        height: 15px;
        border-radius: 2px;
        background: #fff;
        border: 1px solid #6b6666;
        left: 0;
        top: 50%;
        -webkit-transform: translateY(-50%);
        -moz-transform: translateY(-50%);
        -ms-transform: translateY(-50%);
        -o-transform: translateY(-50%);
        transform: translateY(-50%);
      }
      input#remember, label.animatedJackInTheBox, #showPassOrNot{
        cursor: pointer;
      }
      input#remember:checked + label.animatedJackInTheBox::before{
        color: #57b846;
        -webkit-animation-duration: 800ms;
        -moz-animation-duration: 800ms;
        animation-duration: 800ms;
        -webkit-animation-name: fadeIn;
        animation-name: fadeIn;
      }
      a.peterriver, a.peterriver:active{
        text-decoration: none;
        padding: .3rem .4rem;
        width: auto;
        background: unset;
        border-bottom: unset;
        border-left: unset;
        border-right: unset;
        color: #000;
        margin-top: .5rem;
      }
      button.animatedSubmit:hover{
        -webkit-animation-duration: 1s;
        -moz-animation-duration: 1s;
        animation-duration: 1s;
        -webkit-animation-name: tada;
        animation-name: tada;
      }
      a.animatedForgot:hover{
        -webkit-animation-duration: 1s;
        -moz-animation-duration: 1s;
        animation-duration: 1s;
        -webkit-animation-name: rubberBand;
        animation-name: rubberBand;
      }
      input.form-control:focus{
        border: 1px solid #57b846;
        border-radius: 3px;
        -webkit-transition: all 0.4s;
        -o-transition: all 0.4s;
        -moz-transition: all 0.4s;
        transition: all 0.4s;
        -webkit-transform: scaleX(1.1) scaleY(1.3);
        -moz-transform: scaleX(1.1) scaleY(1.3);
        -ms-transform: scaleX(1.1) scaleY(1.3);
        -o-transform: scaleX(1.1) scaleY(1.3);
        transform: scaleX(1.1) scaleY(1.3);
      }
      .carousel-control-prev, .carousel-control-next{
        width: 5%;
      }
      .carousel-item, .carousel-item > img{
        height: calc(100vh - 14vh);
      }
      .carousel-item > img {
        position: absolute;
        top: 0;
        left: 0;
        min-width: 100%;
        /* height: 30rem; */
      }
      .animated {
        -webkit-animation-duration: 2s;
        -moz-animation-duration: 2s;
        animation-duration: 2s;
      }
      .carousel-item h1 {
        animation-delay: 1s;
      }
      .carousel-item h4 {
        animation-delay: 800ms;
      }
      .carousel-item h3, .carousel-item h3 strong, .carousel-item h3 span {
        animation-delay: 2s;
      }
      .zIndex{
        z-index: 999
      }
      #showPassOrNot, label.animatedJackInTheBox::before{
        display: -webkit-box;
        display: -webkit-flex;
        display: -moz-box;
        display: -ms-flexbox;
        display: flex;
        align-items: center;
        position: absolute;
      }
      #showPassOrNot{
        font-size: 16px;
        color: #999999;
        height: 100%;
        top: 0;
        right: 25px;
        padding: 0 5px;
        -webkit-transition: background 0.4s;
        -o-transition: background 0.4s;
        -moz-transition: background 0.4s;
        transition: background 0.4s;
      }
      @media (max-width: 870px){
        h1{
          font-size: 1.8rem;
        }
        h2{
          font-size: 1.4rem;
        }
        h3{
          font-size: 1.2rem;
        }
        h4{
          font-size: 1rem;
        }
        h5{
          font-size: 0.8rem;
        }
      }
      img.img-fluid {
        width: 200px;
        height: 65px;
    }
    </style>
  </head>
  <body>
    
    <div class="d-flex flex-column flex-sm-row flex-md-row px-3 py-1 px-md-4 border-bottom shadow-sm pplogin_headerbar">
      <h5 class="my-0 mr-md-auto font-weight-normal d-flex justify-content-start pplogin_headerbar_logo">
        <img src="<?php echo e(asset('public/css/assets/images/logonew1.png')); ?>" class="img-fluid" alt="Responsive image"/>
      </h5>
<!--      <div class="d-flex flex-row justify-content-end pplogin_headerbar_right">
        <nav class="my-2 my-md-0 mr-md-5 d-flex flex-column">
          <span class="p-1 text-light text-center"><i class="fa fa-phone"></i>&nbsp;&nbsp;Call Us</span>
          <span class="px-1 text-center" style="color: #d4d4d4!important;">+91-8750090651, +91-9911313297</span>
        </nav>
        <nav class="my-2 my-md-0 ml-md-4 mr-md-1 d-flex flex-column">
          <span class="p-1 text-light text-center"><i class="fa fa-envelope"></i>&nbsp;&nbsp;Email Us</span>
          <span class="px-1 text-center"><a href="mailto:info@foodkraft.in" class="text-light pplogin_headerbar_mailto">info@foodkraft.in</a></span>
        </nav>
      </div>-->
    </div>
    
    <div id="carouselExampleSlidesOnly" class="carousel slide" data-ride="carousel" data-interval="3000">
      <div class="carousel-inner">
        <div class="carousel-item active">
          <img src="<?php echo e(asset('public/webImages/foodscraft/foodcraft1.jpg')); ?>" class="d-block w-100" alt="..." />
          <div class="d-md-block d-lg-block d-none flex-column justify-content-start m-5">
            <h1 class="animated bounceInLeft text-white zIndex">Happy Meals to You !</h1>
            <h2 class="animated bounceInUp text-white zIndex"><strong class="font-bolder">Simply</strong> <span class="text-success font-italic"><b>delicious</b></span></h2>
          </div>
        </div>
<!--        <div class="carousel-item">
          <img src="<?php echo e(asset('public/webImages/foodscraft/foodcraft3.jpg')); ?>" class="d-block w-100" alt="..." />
          <div class="d-md-block d-lg-block d-none flex-column justify-content-start m-5">
            <h1 class="animated bounceInLeft text-white zIndex">Happy Meals to You !</h1>
            <h4 class="animated bounceInUp text-success font-italic zIndex d-md-none d-lg-block d-none">NO QUEUES-NO CASH-JUST A TAP OF A BUTTON</h4>
          </div>
        </div>-->
        <div class="container mt-5 h-100">
          <div class="row d-flex justify-content-sm-end justify-content-center">
            <div class="col-md-6 col-lg-5 col-sm-8 col-10 my-md-4 my-2 mx-lg-5">
              <div class="card animatedlightSpeedIn" style="border-radius: .7rem;">
                <div class="card-body">
                  <!--<h2 class="text-center"><?php echo e(__('I-Manage')); ?><br/><?php echo e(__('Login..')); ?></h2>-->
                  <h2 class="text-center"><?php echo e(__('Login..')); ?></h2>
                  <br>
                  <form method="POST" action="<?php echo e(route('login')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="form-group col">
                      <label for="username" class="col-md-12 col-form-label text-md-left">Username Or Email</label>
                      <div class="col-md-12">
                        <input id="username" type="username" class="form-control shadow-none <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="username" value="<?php echo e(old('username')); ?>" required autofocus />
                      </div>
                    </div>
                    <div class="form-group col position-relative">
                      <label for="password" class="col-md-12 col-form-label text-md-left"><?php echo e(__('Password')); ?></label>
                      <div class="col-md-12">
                        <div class="input-group-append">
                          <input id="password" type="password" class="form-control shadow-none <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password" required autocomplete="current-password" />
                          <span id="showPassOrNot" onclick="showOrNot();">
                            <i class="fa fa-eye"></i>
                          </span>
                        </div>
                      </div>
                    </div>
                    <div class="form-group col">
                      <div class="col-md-12">
                        <div class="form-check">
                          <input class="form-check-input d-none" type="checkbox" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?> />
                          <label class="form-check-label animatedJackInTheBox mx-2" for="remember">
                            <?php echo e(__('Remember Me')); ?>

                          </label>
                        </div>
                      </div>
                    </div>
                    <div class="form-group col">
                      <div class="col-md-12 d-flex justify-content-center">
                        <?php if(session('error')): ?>
                        <div class="alert-danger shadow-sm p-2 rounded-lg text-center" style="width: max-content;">
                          <?php echo e(session('error')); ?>

                        </div>
                        <?php endif; ?>
                      </div>
                    </div>
                    <div class="form-group col mb-0">
                      <div class="col-12 d-flex flex-column justify-content-center align-items-center">
                        <button type="submit" class="turquoise w-50 animatedSubmit pplogin">
                          <?php echo e(__('Login')); ?>

                        </button>
                        <?php if(Route::has('password.request')): ?>
                        <a class="peterriver animatedForgot" href="<?php echo e(route('password.request')); ?>">
                          <?php echo e(__('Forgot Password?')); ?>

                        </a>
                        <?php endif; ?>
                      </div>
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
<!--      <a class="carouselLinks carousel-control-prev" onclick="previous();" role="button" data-slide="prev">
        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
        <span class="sr-only">Previous</span>
      </a>
      <a class="carouselLinks carousel-control-next" onclick="next();" role="button" data-slide="next">
        <span class="carousel-control-next-icon" aria-hidden="true"></span>
        <span class="sr-only">Next</span>
      </a>-->
    </div>
    
    <script type="text/javascript" src="<?php echo e(asset('public/js/jquery.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('public/bootstrap/js/bootstrap.min.js')); ?>"></script>
    <script>
          function showOrNot() {
            if ($('input#password').attr("type") == "text") {
              $('input#password').attr('type', 'password');
              $('span#showPassOrNot i').addClass("fa-eye-slash");
              $('span#showPassOrNot i').removeClass("fa-eye");
            } else if ($('input#password').attr("type") == "password") {
              $('input#password').attr('type', 'text');
              $('span#showPassOrNot i').removeClass("fa-eye-slash");
              $('span#showPassOrNot i').addClass("fa-eye");
            }
          }
          function next() {
            $('.carousel').carousel('next');
          }
          function previous() {
            $('.carousel').carousel('prev');
          }
          var $myCarousel = $('#carouselExampleSlidesOnly');
          // Initialize carousel
          $myCarousel.carousel();
    </script>
  </body>
</html><?php /**PATH /var/www/vhosts/chemistpoint.com/httpdocs/new_ngo/resources/views/welcome.blade.php ENDPATH**/ ?>