<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

    <head>
        <title>FoodsKraft</title>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta http-equiv="Content-Language" content="en">
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, shrink-to-fit=no" />
        <meta name="description" content="This is an example dashboard created using build-in elements and components.">
        <meta name="msapplication-tap-highlight" content="no">
     
        <!-- Favicon -->
        <link rel="icon" type="image/x-icon" href="<?php echo e(asset('public/css/assets/images/favicon.ico')); ?>">

        <!-- Fonts -->
        <link rel="dns-prefetch" href="//fonts.gstatic.com">
        <link href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@400;600;700&display=swap" rel="stylesheet">
        <!-- <link href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel='stylesheet'> -->
        <link href="<?php echo e(asset('public/fontAwesome/css/font-awesome.min.css')); ?>" rel='stylesheet'>
    
        <!-- Styles -->
        <link href="<?php echo e(asset('public/css/main.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('public/css/toastr.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('public/css/flatUiButton.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('public/css/checkbox.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('public/css/datepicker.css')); ?>" rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/css/bootstrap-select.css" />
        <link href="<?php echo e(asset('public/css/ppfoods.css')); ?>" rel="stylesheet">
        <script type="text/javascript" src="<?php echo e(asset('public/js/qr_packed.js')); ?>"></script>
    </head>
    
    <style>
        * {
          margin: 0px;
          padding: 0px;
        }
        
        body {
          background-color: #05182d;
        }
        
        @-webkit-keyframes backgroundAnimate {
          from {
            left: 0;
            top: 0;
          }
          to {
            left: -10000px;
            top: -2000px;
          }
        }
        
        @-moz-keyframes backgroundAnimate {
          from {
            left: 0;
            top: 0;
          }
          to {
            left: -10000px;
            top: -2000px;
          }
        }

        @-o-keyframes backgroundAnimate {
          from {
            left: 0;
            top: 0;
          }
          to {
            left: -10000px;
            top: -2000px;
          }
        }
        
        @keyframes  backgroundAnimate {
          from {
            left: 0;
            top: 0;
          }
          to {
            left: -10000px;
            top: -2000px;
          }
        }
        
        #back {
          background: url(http://www.tranexnet.com/img/back.png) repeat 20% 20%;
          position: fixed;
          top: 0;
          left: 0;
          right: 0;
          bottom: 0;
          opacity: 0.4;
          z-index: -1;
          -webkit-animation-name: backgroundAnimate;
          -webkit-animation-duration: 500s;
          -webkit-animation-timing-function: linear;
          -webkit-animation-iteration-count: infinite;
          -moz-animation-name: backgroundAnimate;
          -moz-animation-duration: 5s;
          -moz-animation-timing-function: linear;
          -moz-animation-iteration-count: infinite;
          -o-animation-name: backgroundAnimate;
          -o-animation-duration: 500s;
          -o-animation-timing-function: linear;
          -o-animation-iteration-count: infinite;
          animation-name: backgroundAnimate;
          animation-duration: 500s;
          animation-timing-function: linear;
          animation-iteration-count: infinite;
        }
        
        #front {
          background: url(http://www.tranexnet.com/img/front.png) repeat 35% 35%;
          position: fixed;
          top: 0;
          left: 0;
          right: 0;
          bottom: 0;
          opacity: 0.6;
          z-index: -1;
          -webkit-animation-name: backgroundAnimate;
          -webkit-animation-duration: 300s;
          -webkit-animation-timing-function: linear;
          -webkit-animation-iteration-count: infinite;
          -moz-animation-name: backgroundAnimate;
          -moz-animation-duration: 300s;
          -moz-animation-timing-function: linear;
          -moz-animation-iteration-count: infinite;
          -o-animation-name: backgroundAnimate;
          -o-animation-duration: 300s;
          -o-animation-timing-function: linear;
          -o-animation-iteration-count: infinite;
          animation-name: backgroundAnimate;
          animation-duration: 300s;
          animation-timing-function: linear;
          animation-iteration-count: infinite;
        }
    </style>
    
    <body>
        <div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header fixed-footer">
            <?php echo $__env->make('components.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="app-main">
                <div class="app-sidebar sidebar-shadow">
                    <div class="app-header__logo">
                        <div class="logo-src"></div>
                        <div class="header__pane ml-auto">
                            <div>
                                <button type="button" class="hamburger close-sidebar-btn hamburger--elastic" data-class="closed-sidebar">
                                    <span class="hamburger-box">
                                        <span class="hamburger-inner"></span>
                                    </span>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="app-header__mobile-menu">
                        <div>
                            <button type="button" class="hamburger hamburger--elastic mobile-toggle-nav">
                                <span class="hamburger-box">
                                    <span class="hamburger-inner"></span>
                                </span>
                            </button>
                        </div>
                    </div>
                    <div class="app-header__menu">
                        <span>
                            <button type="button" class="btn-icon btn-icon-only btn btn-primary btn-sm mobile-toggle-header-nav">
                                <span class="btn-icon-wrapper">
                                    <i class="fa fa-ellipsis-v fa-w-6"></i>
                                </span>
                            </button>
                        </span>
                    </div>
                    <div class="scrollbar-sidebar">
                        <?php echo $__env->make('components.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
                <div class="app-main__outer">
                    <div id="back"></div>
                    <div id="front"></div>
                    <div class="app-main__inner" id="reloadCardDet">
                        <?php if(\Request::is('home')): ?>
                        <?php elseif(Request::route()->getPrefix() === '/ICount'): ?>
                        <?php elseif(\Request::is('FK-app-section')): ?>
                        <?php else: ?>
                            <div class="row">
                                <div class="col">
                                    
                                    <?php if(Request::route()->getPrefix() === 'ICount/I-count' || Request::route()->getPrefix() === 'client/ICount/I-count' || Request::route()->getPrefix() === 'vendor/ICount/I-count'): ?>
                                    <div class="wetasphalt mx-2 unvirwetasphalt" onclick="redirection('<?php echo e(url()->previous()); ?>');">Back</div>
                                    <div class="wetasphalt mx-2 unvirwetasphalt" onclick="redirection('<?php echo e(url('ICount/I-count')); ?>');">Home</div>
                                    
                                    <?php else: ?>
                                        <div class="wetasphalt mx-2 unvirwetasphalt" onclick="redirection('<?php echo e(url()->previous()); ?>');">Back</div>
                                        <div class="wetasphalt mx-2 unvirwetasphalt" onclick="redirection('<?php echo e(url('home')); ?>');">Home</div>
                                    <?php endif; ?>
                                </div>
                                <div class="col">
                                </div>
                            </div>
                            <br/>
                        <?php endif; ?>
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                    <?php echo $__env->make('components.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>

        <div class="modal fade" id="myModal" role="dialog" data-backdrop="static">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title text-center" style="width: -webkit-fill-available;">Confirm Your Action</h4>
                    </div>
                    <div class="modal-body d-flex justify-content-around">
                        <div class="btn btn-outline-secondary py-2 px-3 font-weight-bold align-center" style="font-size: 1rem;" data-dismiss="modal">Cancel</div>
                        <div class="carrot" id="confirmDelete" style="padding: .4rem .2rem; font-size: 1rem;" onclick="deleteSpecificRole();">Confirm</div>
                        <a class="btn btn-outline-secondary py-2 px-3 font-weight-bold align-center" style="font-size: 1rem;" href="<?php echo e(route('logout')); ?>"
                           onclick="event.preventDefault();
                                         document.getElementById('logout-form').submit();">
                            <?php echo e(__('Logout')); ?>

                        </a>
                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                            <?php echo csrf_field(); ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <script type="text/javascript" src="<?php echo e(asset('public/js/main.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('public/js/jquery.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('public/bootstrap/js/bootstrap.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('public/js/toastr.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('public/js/datepicker.js')); ?>"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/js/bootstrap-select.min.js"></script>
        
        <?php echo $__env->yieldContent('customscript'); ?>
        <script>
            $(function () {
                // INITIALIZE DATEPICKER PLUGIN
                $('.datepicker').datepicker({
                    clearBtn: true,
                    startDate: new Date(),
                    format: "yyyy-mm-dd",
                    autoclose: true
                });
            });
            var deleteRoleSpecific = "";
            var deleteId;
            var token = $("meta[name='csrf-token']").attr("content");
            toastr.options = {
                /*
                    Uncomment these lines when you want to stop the toast to fadeOut.
                    "timeOut": "0",
                    "extendedTimeOut": "0",
                */
                "timeOut": "2000",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut",
                "progressBar": true,
                "positionClass": "toast-top-center",
            }
            <?php if(Session::has('message')): ?>
                var type = "<?php echo e(Session::get('alert-type', 'info')); ?>";
                switch(type){
                    case 'info':
                        toastr.info("<?php echo e(Session::get('message')); ?>");
                        break;
                    case 'warning':
                        toastr.warning("<?php echo e(Session::get('message')); ?>");
                        break;
                    case 'success':
                        toastr.success("<?php echo e(Session::get('message')); ?>");
                        break;
                    case 'error':
                        toastr.error("<?php echo e(Session::get('message')); ?>");
                        break;
                }
            <?php endif; ?>
            function redirection(url){
                console.log("Redirection", url);
                window.location.replace(url);
            }
            function viewOrEdit(url, type, id){
                console.log("View or Edit Role", url, type, id);
                window.location.replace(url + '/' + type + '/' + id);
            }
            function putName(input){
                console.log(input);
                var value = input.value.replace(/C:\\fakepath\\/i, '');
                $(input).next().html(value);
            }
            function headDropDown(){
                $("div#headDropDown").toggleClass("show");
            }
            function deleteModal(url, value){
                $("#myModal").modal();
                $("div#confirmLogout").hide();
                $("div#confirmDelete").show();
                deleteRoleSpecific = url + '/' + value;
                deleteId = value;
            }
            function logoutModal(){
                $("#myModal").modal();
                $("div#confirmLogout").show();
                $("div#confirmDelete").hide();
                $("div#headDropDown").toggleClass("show");
            }
            function deleteSpecificRole(){
                console.log("Delete Specific Role", deleteRoleSpecific);
                var formData = {
                    "_token"  : token,
                    'id'      : deleteId
                };
                console.log(formData);
                $.ajax({
                    type        : 'DELETE',
                    url         : deleteRoleSpecific,
                    data        : formData,
                    dataType    : 'json',
                    encode      : true,
                    success     : function(res){
                        console.log(res);
                        toastr.success(res["success"]);
                        $("#reloadCard").load(" #reloadCard > *");
                    },
                    error       : function(xhr, textStatus, errorThrown){
                        console.log(errorThrown, textStatus);
                        toastr.error(textStatus);
                        toastr.error(errorThrown);
                    }
                });
                deleteRoleSpecific = [];
                $("#myModal").modal('hide');
            }
            // Not in use right now..
            function logout(){
                var logoutUrl = "<?php echo e(route('logout')); ?>";
                console.log("Logout", logoutUrl);
                var formData = {
                    "_token"  : token
                };
                $.ajax({
                    type        : 'POST',
                    url         : logoutUrl,
                    data        : formData,
                    dataType    : 'json',
                    encode      : true,
                    success: function()
                    {
                        location.reload(true);
                    }
                });
                // location.reload(true);
                $("#myModal").modal('hide');
            }

            function csfcothersFunction(){
                var checkBox = document.getElementById("csfcothers");
                var text = document.getElementById("divcsfcother");
                if(checkBox.checked == true){
                    text.style.display = "block";
                }else{
                    text.style.display = "none";
                }
            }
            
            function tosothersFunction(){
              var checkBox = document.getElementById("tosothers");
              var text = document.getElementById("divtosother");
              if (checkBox.checked == true){
                text.style.display = "block";
              } else {
                 text.style.display = "none";
              }
            }
            
            function sendToConcernForm(id, status, newurl){
                var message = document.getElementById('concern_msg').innerHTML;
                if(message !== ''){
                    console.log(id, status, message, newurl);
                    var formData = {
                        "_token"  : token,
                        'id'      : id,
                        'status'  : status,
                        'message' : message
                    };
                    console.log(formData);
                    $.ajax({
                        type        : 'POST',
                        url         : newurl,
                        data        : formData,
                        dataType    : 'json',
                        encode      : true,
                        success     : function(res){
                            console.log(res);
                            document.getElementById('concern_msg').innerHTML = "";
                            $("#allMsg").load(" #allMsg > *");
                            var bottom = document.getElementById("allMsg").scrollHeight;
                            $('#allMsg').animate({scrollTop: bottom}, 'slow');
                        },
                        error       : function(xhr, textStatus, errorThrown){
                            console.log(errorThrown, textStatus);
                            toastr.error('There was an error saving your concern message!');
                        }
                    });
                }else{
                    toastr.error('There was an error saving your empty concern message!');
                }
            }

            function viewText(vendorId, clientId){
                // console.log(vendorId, clientId);
                document.getElementById("actionoptions" + vendorId).style.setProperty("display", "none", "important");
                document.getElementById("reason" + vendorId).style.setProperty("display", "block", "important");
            }

            function tgleExptBtn(element){
                if($('ul#expBtn').css('display') == "flex"){
                    $('ul#expBtn').css('display', 'none');
                }else if($('ul#expBtn').css('display') == "none"){
                    $('ul#expBtn').css('display', 'flex');
                }
            }

            function sendFeedReason(vendorId, clientId){
                // console.log(vendorId, clientId);
                reason = document.getElementById("textReason" + vendorId).value;
                copy_reason = reason.trim();
                if(copy_reason.length < 1){
                    reason = null;
                }else{
                    reason = reason.replace(/\s+$/g, '');
                }
                var formData = {
                    "_token"  : token,
                    'vendorId' : vendorId,
                    'clientId' : clientId,
                    'reason' : reason
                };
                console.log(formData);
                $.ajax({
                    type        : 'POST',
                    url         : "<?php echo e(url('client/feedback')); ?>",
                    data        : formData,
                    dataType    : 'json',
                    encode      : true,
                    success     : function(res){
                        console.log(res);
                        toastr.success(res.success);
                        setTimeout(() => {
                            redirection("<?php echo e(url('client/feedback')); ?>");
                        }, 2000);
                    },
                    error       : function(xhr, textStatus, errorThrown){
                        console.log(errorThrown, textStatus);
                        toastr.error('There was an error saving your feedback message!');
                    }
                });
            }

            function approve_status(vendorId, status){
                console.log(vendorId, status);
                if(vendorId !== "" && status !== ""){
                    var formData = {
                        "_token"  : token,
                        'vendorId' : vendorId,
                        'status' : status
                    };
                    clientToVendorStatus(formData, "<?php echo e(url('client/vendorDocuments/status')); ?>", "<?php echo e(url('client/view/vendorDocuments')); ?>");
                }
            }

            function disapprove_status(vendorId, status){
                console.log(vendorId, status);
                if(vendorId !== "" && status !== ""){
                    vendor_doc = document.getElementById('vendor_doc').value;
                    copy_vendor_doc = vendor_doc.trim();
                    if(copy_vendor_doc.length < 1){
                        vendor_doc = null;
                    }else{
                        vendor_doc = vendor_doc.replace(/\s+$/g, '');
                    }
                    var formData = {
                        "_token"  : token,
                        'vendorId' : vendorId,
                        'status' : status,
                        'vendor_doc_comment' : vendor_doc
                    };
                    clientToVendorStatus(formData, "<?php echo e(url('client/vendorDocuments/status')); ?>", "<?php echo e(url('client/view/vendorDocuments')); ?>");
                }
            }

            function approve_meal_status(vendorId, status){
                console.log(vendorId, status);
                if(vendorId !== "" && status !== ""){
                    var formData = {
                        "_token"  : token,
                        'vendorId' : vendorId,
                        'status' : status
                    };
                    clientToVendorStatus(formData, "<?php echo e(url('client/vendorMenus/status')); ?>", "<?php echo e(url('client/view/vendorMenus')); ?>");
                }
            }

            function disapprove_status(vendorId, status){
                console.log(vendorId, status);
                if(vendorId !== "" && status !== ""){
                    vendor_doc = document.getElementById('vendor_meal_doc').value;
                    copy_vendor_doc = vendor_doc.trim();
                    if(copy_vendor_doc.length < 1){
                        vendor_doc = null;
                    }else{
                        vendor_doc = vendor_doc.replace(/\s+$/g, '');
                    }
                    var formData = {
                        "_token"  : token,
                        'vendorId' : vendorId,
                        'status' : status,
                        'vendor_doc_comment' : vendor_doc
                    };
                    clientToVendorStatus(formData, "<?php echo e(url('client/vendorMenus/status')); ?>", "<?php echo e(url('client/view/vendorMenus')); ?>");
                }
            }

            function clientToVendorStatus(formData, work_url, redirect_url){
                console.log(formData);
                $.ajax({
                    type        : 'POST',
                    url         : work_url,
                    data        : formData,
                    dataType    : 'json',
                    encode      : true,
                    success     : function(res){
                        console.log(res);
                        toastr.success(res.success);
                        setTimeout(() => {
                            redirection(redirect_url);
                        }, 2000);
                    },
                    error       : function(xhr, textStatus, errorThrown){
                        console.log(errorThrown, textStatus);
                        toastr.error('There was an error changing vendor status!');
                    }
                });
            }
        </script>      
        
        
    </body>

</html>
<?php /**PATH C:\xampp7.4\htdocs\foodycraft\resources\views/layouts/masterDashboard.blade.php ENDPATH**/ ?>