<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'FoodsKraft')); ?></title>

    <!-- Scripts -->
    <script src="<?php echo e(asset('public/js/app.js')); ?>" defer></script>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('public/css/assets/images/favicon.ico')); ?>">

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@400;600;700&display=swap" rel="stylesheet">

    <!-- Styles -->
    <link href="<?php echo e(asset('public/css/app.css')); ?>" rel="stylesheet">
    
    <link href="<?php echo e(asset('public/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('public/css/animate.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('public/fontAwesome/css/font-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/fontStyles/font.css')); ?>">
    <link href="<?php echo e(asset('public/css/flatUiButton.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset('public/css/ppfoods.css')); ?>" rel="stylesheet">
    
</head>
<body>
  
  <div class="d-flex flex-column flex-sm-row flex-md-row px-3 py-1 px-md-4 border-bottom shadow-sm pplogin_headerbar">
      <h5 class="my-0 mr-md-auto font-weight-normal d-flex justify-content-start pplogin_headerbar_logo">
        <img src="<?php echo e(asset('public/css/assets/images/logo.png')); ?>"/>
      </h5>
      <div class="d-flex flex-row justify-content-end pplogin_headerbar_right">
        <nav class="my-2 my-md-0 mr-md-5 d-flex flex-column">
          <span class="p-1 text-light text-center"><i class="fa fa-phone"></i>&nbsp;&nbsp;Call Us</span>
          <span class="px-1 text-center" style="color: #d4d4d4!important;">+91-8750090651, +91-9911313297</span>
        </nav>
        <nav class="my-2 my-md-0 ml-md-4 mr-md-1 d-flex flex-column">
          <span class="p-1 text-light text-center"><i class="fa fa-envelope"></i>&nbsp;&nbsp;Email Us</span>
          <span class="px-1 text-center"><a href="mailto:info@foodkraft.in" class="text-light pplogin_headerbar_mailto">info@foodkraft.in</a></span>
        </nav>
      </div>
    </div>
  
    <div id="app">
        <nav class="navbar navbar-expand-md navbar-light bg-white shadow-sm">
            <div class="container">
<!--                <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
                    <?php echo e(config('app.name', 'FoodsKraft')); ?>

                </a>-->
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="<?php echo e(__('Toggle navigation')); ?>">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <!-- Left Side Of Navbar -->
                    <ul class="navbar-nav mr-auto">

                    </ul>

                    <!-- Right Side Of Navbar -->
                    <ul class="navbar-nav ml-auto">
                        <!-- Authentication Links -->
                        <?php if(auth()->guard()->guest()): ?>
                            <li class="nav-item pprestloginlink">
                                <a class="nav-link" href="<?php echo e(route('welcome')); ?>"><?php echo e(__('Login')); ?></a>
                            </li>
                        <?php else: ?>
                            <li class="nav-item dropdown">
                                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                    <?php echo e(Auth::user()->name); ?> <span class="caret"></span>
                                </a>

                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                        <?php echo e(__('Logout')); ?>

                                    </a>

                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </nav>

        <main class="py-4">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>
</body>
</html>
<?php /**PATH /home/nexaipaybr/public_html/foodycraft/resources/views/layouts/app.blade.php ENDPATH**/ ?>