
<?php $__env->startSection('content'); ?>
    <style>
        .multisteps-form__progress {
          display: grid;
          grid-template-columns: repeat(auto-fit, minmax(0, 1fr));
        }

        .multisteps-form__progress-btn {
          transition-property: all;
          transition-duration: 0.15s;
          transition-timing-function: linear;
          transition-delay: 0s;
          position: relative;
          padding-top: 20px;
          color: rgba(108, 117, 125, 0.7);
          text-indent: -9999px;
          border: none;
          background-color: transparent;
          outline: none !important;
          cursor: pointer;
        }

        @media (min-width: 500px) {
          .multisteps-form__progress-btn {
            text-indent: 0;
          }
        }

        .multisteps-form__panel[data-animation=slideHorz].js-active {
          transition-property: all;
          transition-duration: .25s;
          transition-timing-function: cubic-bezier(.2,1.13,.38,1.43);
          transition-delay: 0s;
          left: 0;
        }
        .multisteps-form__panel[data-animation=slideHorz] {
          left: 50px;
        }

        .multisteps-form__progress-btn:before {
          position: absolute;
          top: 0;
          left: 50%;
          display: block;
          width: 13px;
          height: 13px;
          content: '';
          -webkit-transform: translateX(-50%);
          transform: translateX(-50%);
          transition: all 0.15s linear 0s, -webkit-transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s;
          transition: all 0.15s linear 0s, transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s;
          transition: all 0.15s linear 0s, transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s, -webkit-transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s;
          border: 2px solid currentColor;
          border-radius: 50%;
          background-color: #fff;
          box-sizing: border-box;
          z-index: 3;
        }

        .multisteps-form__progress-btn:after {
          position: absolute;
          top: 5px;
          left: calc(-50% - 13px / 2);
          transition-property: all;
          transition-duration: 0.15s;
          transition-timing-function: linear;
          transition-delay: 0s;
          display: block;
          width: 100%;
          height: 2px;
          content: '';
          background-color: currentColor;
          z-index: 1;
        }

        .multisteps-form__progress-btn:first-child:after {
          display: none;
        }

        .multisteps-form__progress-btn.js-active {
          color: #007bff;
        }

        .multisteps-form__progress-btn.js-active:before {
          -webkit-transform: translateX(-50%) scale(1.2);
          transform: translateX(-50%) scale(1.2);
          background-color: currentColor;
        }

        .multisteps-form__form {
          position: relative;
        }

        .multisteps-form__panel {
          position: absolute;
          top: 0;
          left: 0;
          width: 100%;
          height: 0;
          opacity: 0;
          visibility: hidden;
        }

        .multisteps-form__panel.js-active {
          height: auto;
          opacity: 1;
          visibility: visible;
        }
    </style>
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm mb-3">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                  <h3><?php echo $roleType; ?>&nbsp; - Map Details</h3>
                </div>
                <div class="card-body multisteps-form">
                    <?php if(isset($listDetail)): ?>
                        <!--progress bar-->
                        <div class="row">
                            <div class="col-12 col-lg-8 ml-auto mr-auto mt-1">
                                <div class="multisteps-form__progress">
                                    <?php switch($roleType):
                                        case ("vendor"): ?>
                                            <button class="multisteps-form__progress-btn js-active" type="button" data-toggle="tooltip" title="Click to see Client List">Client</button>
                                            <button class="multisteps-form__progress-btn" type="button" data-toggle="tooltip" title="Click to see Marshal List">Marshal</button>
                                        <?php break; ?>
                                        <?php case ("client"): ?>
                                            <button class="multisteps-form__progress-btn js-active" type="button" data-toggle="tooltip" title="Click to see Vendor List">Vendor</button>
                                            <button class="multisteps-form__progress-btn" type="button" data-toggle="tooltip" title="Click to see Marshal List">Marshal</button>
                                        <?php break; ?>
                                        <?php case ("sitemarshal"): ?>
                                            <button class="multisteps-form__progress-btn js-active" type="button" data-toggle="tooltip" title="Click to see Vendor List">Vendor</button>
                                            <button class="multisteps-form__progress-btn" type="button" data-toggle="tooltip" title="Click to see Client List">Client</button>
                                        <?php break; ?>
                                        <?php default: ?>
                                            Something Bad Happened
                                    <?php endswitch; ?>
                                </div>
                            </div>
                        </div>
                        <?php
                            // dd($listDetail);
                        ?>
                        <div class="multisteps-form__form">
                            <?php $__empty_1 = true; $__currentLoopData = $listDetail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role_name => $role_detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php if($role_name == "clientId"): ?>
                                    <?php
                                        $activeDiv = ($roleType == "vendor" ? "multisteps-form__panel p-4 bg-white js-active client" : "multisteps-form__panel p-4 bg-white client");
                                    ?>
                                    <div class="<?php echo e($activeDiv); ?>" data-animation="slideHorz">
                                        <div class="multisteps-form__content">
                                            <div class="row">
                                                <div class="col-12 mt-2">
                                                    <div class="card shadow-none">
                                                        <div class="card-body p-1">
                                                            <table class="table table-hover">
                                                                <thead class="text-dark">
                                                                    <tr>
                                                                        <th class="text-center" scope="col">S.No.</th>
                                                                        <th class="text-center" scope="col">Name</th>
                                                                        <th class="text-center" scope="col">Mobile No.</th>
                                                                        <th class="text-center" scope="col">Location</th>
                                                                        <th class="text-center" scope="col">Action</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody class="tab">
                                                                    <?php $__empty_2 = true; $__currentLoopData = $role_detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $x => $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                                        <tr>
                                                                            <th class="text-center" scope="row"><?php echo e($loop->iteration); ?></th>
                                                                            <td class="text-center"><?php echo e($info['name']); ?></td>
                                                                            <td class="text-center"><?php echo e($info['contactNumber']); ?></td>
                                                                            <td class="text-center"><?php echo e($info['address']); ?></td>
                                                                            <td class="d-flex justify-content-center">
                                                                                <div class="peterriver" onclick="viewOrEdit('<?php echo e(url('viewOrEditRole')); ?>', 'view', '<?php echo e($info['clientId']); ?>');">View</div>
                                                                            </td>
                                                                        </tr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                                                        <p>Role Escaped!</p>
                                                                    <?php endif; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="button-row d-flex mt-4 col-12">
                                                    <?php if($roleType == "vendor"): ?>
                                                        <button class="wetasphalt ml-auto js-btn-next" type="button">Next</button>
                                                    <?php elseif($roleType == "sitemarshal"): ?>
                                                        <button class="wetasphalt js-btn-prev" type="button">Prev</button>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php elseif($role_name == "vendorId"): ?>
                                    <?php
                                        $activeDiv = ($roleType == "client" || $roleType == "sitemarshal" ? "multisteps-form__panel p-4 bg-white js-active vendor" : "multisteps-form__panel p-4 bg-white vendor");
                                    ?>
                                    <div class="<?php echo e($activeDiv); ?>" data-animation="slideHorz">
                                        <div class="multisteps-form__content">
                                            <div class="row">
                                                <div class="col-12 mt-2">
                                                    <div class="card shadow-none">
                                                        <div class="card-body p-1">
                                                            <table class="table table-hover">
                                                                <thead class="text-dark">
                                                                    <tr>
                                                                        <th class="text-center" scope="col">S.No.</th>
                                                                        <th class="text-center" scope="col">Name</th>
                                                                        <th class="text-center" scope="col">Mobile No.</th>
                                                                        <th class="text-center" scope="col">Location</th>
                                                                        <th class="text-center" scope="col">Action</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody class="tab">
                                                                    <?php $__empty_2 = true; $__currentLoopData = $role_detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $x => $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                                        <tr>
                                                                            <th class="text-center" scope="row"><?php echo e($loop->iteration); ?></th>
                                                                            <td class="text-center"><?php echo e($info['name']); ?></td>
                                                                            <td class="text-center"><?php echo e($info['contactNumber']); ?></td>
                                                                            <td class="text-center"><?php echo e($info['address']); ?></td>
                                                                            <td class="d-flex justify-content-center">
                                                                                <div class="peterriver" onclick="viewOrEdit('<?php echo e(url('viewOrEditRole')); ?>', 'view', '<?php echo e($info['vendorId']); ?>');">View</div>
                                                                            </td>
                                                                        </tr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                                                        <p>Role Escaped!</p>
                                                                    <?php endif; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="button-row d-flex mt-4 col-12">
                                                    <?php if($roleType == "sitemarshal" || $roleType == "client"): ?>
                                                        <button class="wetasphalt ml-auto js-btn-next" type="button">Next</button>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php elseif($role_name == "marshalId"): ?>
                                    <div class="multisteps-form__panel p-4 bg-white marshal" data-animation="slideHorz">
                                        <div class="multisteps-form__content">
                                            <div class="row">
                                                <div class="col-12 mt-2">
                                                    <div class="card shadow-none">
                                                        <div class="card-body p-1">
                                                            <table class="table table-hover">
                                                                <thead class="text-dark">
                                                                    <tr>
                                                                        <th class="text-center" scope="col">S.No.</th>
                                                                        <th class="text-center" scope="col">Name</th>
                                                                        <th class="text-center" scope="col">Mobile No.</th>
                                                                        <th class="text-center" scope="col">Location</th>
                                                                        <th class="text-center" scope="col">Action</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody class="tab">
                                                                    <?php $__empty_2 = true; $__currentLoopData = $role_detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $x => $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                                        <tr>
                                                                            <th class="text-center" scope="row"><?php echo e($loop->iteration); ?></th>
                                                                            <td class="text-center"><?php echo e($info['name']); ?></td>
                                                                            <td class="text-center"><?php echo e($info['contactNumber']); ?></td>
                                                                            <td class="text-center"><?php echo e($info['address']); ?></td>
                                                                            <td class="d-flex justify-content-center">
                                                                                <div class="peterriver" onclick="viewOrEdit('<?php echo e(url('viewOrEditRole')); ?>', 'view', '<?php echo e($info['marshalId']); ?>');">View</div>
                                                                            </td>
                                                                        </tr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                                                        <p>Role Escaped!</p>
                                                                    <?php endif; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="button-row d-flex mt-4 col-12">
                                                    <button class="wetasphalt js-btn-prev" type="button">Prev</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p>Not Mapped Yet!</p>
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                        <h2>Something Went Wrong</h2>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->startSection('customscript'); ?>
        <script src="<?php echo e(asset('public/js/progressTableForm.js')); ?>"></script>
        <script>
            marshals = [];
            vendors = [];
            clients = [];

            function functiontofindIndexByKeyValue(arraytosearch, key, valuetosearch){
                for (var i = 0; i < arraytosearch.length; i++) {
                    if (arraytosearch[i][key] == valuetosearch) {
                        return i;
                    }
                }
                return null;
            }

            function checkClients(val){
                clients = [];
                clients.push(val);
                createClientsTable(clients);
            }

            function createClientsTable(value){
                var clientBody = document.getElementById('client');
                clientBody.innerHTML = '';
                var td = "";
                var tr = "";
                var s_no = "";
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    clientBody.appendChild(tr);
                });
            }

            function checkVendors(val){
                if (!val.currentElement.control.checked){
                    vendors.push(val);
                } else if (val.currentElement.control.checked){
                    indexToPop = functiontofindIndexByKeyValue(vendors, "email", val['email']);
                    vendors.splice(indexToPop, 1);
                }
                createVendorsTable(vendors);
                createVendorInputs(vendors);
            }

            function createVendorsTable(value){
                var venBody = document.getElementById('vendor');
                venBody.innerHTML = '';
                var td = "";
                var tr = "";
                var s_no = "";
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    venBody.appendChild(tr);
                });
            }

            function createVendorInputs(value){
                var venBody = document.getElementById('vendorTimingFees');
                venBody.innerHTML = '';
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'address' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    td = document.createElement('td');
                    td.classList.add("text-center");
                    var input = document.createElement('input');
                    input.classList.add("form-control");
                    input.setAttribute('type', 'text');
                    var aggr = "aggregation[" + el['id'] + "]";
                    input.setAttribute('name', aggr);
                    td.appendChild(input);
                    tr.appendChild(td);
                    td = document.createElement('td');
                    td.classList.add("text-center");
                    var textarea = document.createElement('textarea');
                    textarea.classList.add("form-control");
                    var mealTime = "mealTime[" + el['id'] + "]";
                    textarea.setAttribute('name', mealTime);
                    textarea.setAttribute('placeholder', 'Meal Timings');
                    td.appendChild(textarea);
                    tr.appendChild(td);
                    venBody.appendChild(tr);
                });
            }

            function checkMarshals(val){
                if (!val.currentElement.control.checked){
                    marshals.push(val);
                } else if (val.currentElement.control.checked){
                    indexToPop = functiontofindIndexByKeyValue(marshals, "email", val['email']);
                    marshals.splice(indexToPop, 1);
                }
                createMarshalsTable(marshals);
                createMarshalInputs(marshals);
            }

            function createMarshalsTable(value){
                var marBody = document.getElementById('marshal');
                marBody.innerHTML = '';
                var td = "";
                var tr = "";
                var s_no = "";
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    marBody.appendChild(tr);
                });
            }

            function createMarshalInputs(value){
                var marBody = document.getElementById('marshalTiming');
                marBody.innerHTML = '';
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'address' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    td = document.createElement('td');
                    td.classList.add("text-center");
                    var input = document.createElement('input');
                    input.classList.add("form-control");
                    input.setAttribute('type', 'text');
                    var marTime = "marTime[" + el['id'] + "]";
                    input.setAttribute('name', marTime);
                    td.appendChild(input);
                    tr.appendChild(td);
                    marBody.appendChild(tr);
                });
            }
        </script>
    <?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.masterDashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexaipaybr/public_html/foodycraft/app/Modules/Admin/Views/map/map_detail.blade.php ENDPATH**/ ?>