<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

    <head>
        <title>FoodsKraft App Section</title>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta http-equiv="Content-Language" content="en">
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, shrink-to-fit=no" />
        <meta name="description" content="This is an example dashboard created using build-in elements and components.">
        <meta name="msapplication-tap-highlight" content="no">
 
        <!-- Favicon -->
        <link rel="icon" type="image/x-icon" href="<?php echo e(asset('public/css/assets/images/favicon.ico')); ?>">

        <!-- Fonts -->
        <link rel="dns-prefetch" href="//fonts.gstatic.com">
        <link href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@400;600;700&display=swap" rel="stylesheet">
        <link href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel='stylesheet'>

        <!-- Styles -->
        <link href="<?php echo e(asset('public/css/main.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('public/css/toastr.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('public/css/flatUiButton.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('public/css/checkbox.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('public/css/datepicker.css')); ?>" rel="stylesheet">

        <style>
            body {
                margin:0;
                padding:0;
                overflow:hidden;
                background-color:black;
            }
            section{
                height:100%;
                width:100%;
                position:absolute ;  
                /*background:radial-gradient(#333,#000);*/ 
                background:radial-gradient(#37485f,#2e394c);
            }
            .leaf{
                position:absolute ;
                width:100%;
                height:100%;
                top:0;
                left:0;
            }
            .leaf div{
                position:absolute ;
                display:block ;
            }
            .leaf div:nth-child(1){
                left:20%; 
                animation:fall 15s linear infinite ;
                animation-delay:-2s;

            }
            .leaf div:nth-child(2){
                left:70%; 
                animation:fall 15s linear infinite ;
                animation-delay:-4s;
            }
            .leaf div:nth-child(3){
                left:10%; 
                animation:fall 20s linear infinite ;
                animation-delay:-7s;

            }
            .leaf div:nth-child(4){
                left:50%; 
                animation:fall 18s linear infinite ; 
                animation-delay:-5s;
            }
            .leaf div:nth-child(5){
                left:85%; 
                animation:fall 14s linear infinite ;
                animation-delay:-5s;
            }
            .leaf div:nth-child(6){
                left:15%; 
                animation:fall 16s linear infinite ;
                animation-delay:-10s;
            }
            .leaf div:nth-child(7){
                left:90%; 
                animation:fall 15s linear infinite ;
                animation-delay:-4s;
            }

            @keyframes  fall{
                0%{
                    opacity:1;
                    top:-10%;
                    transform:translateX (20px) rotate(0deg);
                }
                20%{
                    opacity:0.8;
                    transform:translateX (-20px) rotate(45deg);
                }
                40%{

                    transform:translateX (-20px) rotate(90deg);
                }
                60%{

                    transform:translateX (-20px) rotate(135deg); 
                }
                80%{

                    transform:translateX (-20px) rotate(180deg);
                }
                100%{

                    top:110%;
                    transform:translateX (-20px) rotate(225deg);
                }
            }
            .leaf1{
                transform: rotateX(180deg);
            }
            h2{
                /*position:absolute ;*/
                /*top:40%;*/
                width:100%;
                /*font-family: 'Courgette', cursive;*/
                font-size:2em;
                text-align:center;
                transform:translate ;
                color:#fff;
                /*transform:translateY (-50%);*/
            }
            .fk-section-button{
                position:absolute ;
                top:20%;
                width:100%;
                text-align:center;
                transform:translate ;
                color:#fff;
                transform:translateY (-50%);
                z-index: 9999;
            }
            
            /* Glow on hover button */
            .glow-on-hover {
                width: 200px;
                height: 65px;
                border: none;
                outline: none;
                color: #fff;
                background: #111;
                cursor: pointer;
                position: relative;
                z-index: 9;
                border-radius: 10px;
                font-size: 25px;
            }

            .glow-on-hover:before {
                content: '';
                background: linear-gradient(45deg, #ff0000, #ff7300, #fffb00, #48ff00, #00ffd5, #002bff, #7a00ff, #ff00c8, #ff0000);
                position: absolute;
                top: -2px;
                left:-2px;
                background-size: 400%;
                z-index: -1;
                filter: blur(5px);
                width: calc(100% + 4px);
                height: calc(100% + 4px);
                animation: glowing 20s linear infinite;
                opacity: 0;
                transition: opacity .3s ease-in-out;
                border-radius: 10px;
            }

            .glow-on-hover:active {
                color: #000
            }

            .glow-on-hover:active:after {
                background: transparent;
            }

            .glow-on-hover:hover:before {
                opacity: 1;
            }

            .glow-on-hover:after {
                z-index: -1;
                content: '';
                position: absolute;
                width: 100%;
                height: 100%;
                /*background: #111;*/
                background: #818994;
                left: 0;
                top: 0;
                border-radius: 10px;
            }

            @keyframes  glowing {
                0% { background-position: 0 0; }
                50% { background-position: 400% 0; }
                100% { background-position: 0 0; }
            }
            .fk-section-button-ul{
                list-style: none;
                text-decoration: none;
                text-align: center;
                width: 50%;
                margin: 0 auto;
                padding: 0px;
            }
            .fk-section-button-li{
                float: left;
                padding: 10px;
                width: 50%;
            }
        </style>

    </head>
    <body>
        <div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header fixed-footer">
            <?php echo $__env->make('components.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="app-main">
                <section>
                    <div class="fk-section-button">
                        <h2>
                            Welcome to Foodskraft !!
                        </h2>
                        <br>
                        <ul class="fk-section-button-ul">
                            <li class="fk-section-button-li">
                                <a href="<?php echo e(url('/home')); ?>">
                                    <button class="glow-on-hover" type="button">I-Manage</button>
                                </a>
                            </li>
                            <li class="fk-section-button-li">
                                <a href="<?php echo e(url('ICount/I-count')); ?>">
                                    <button class="glow-on-hover" type="button">I-Count</button>
                                </a>
                            </li>
                        </ul>
                    </div>
                    <div class="leaf">
                        <div>  <img src="<?php echo e(asset('public/webImages/FK-app-section/Fall-Autumn-Leaves-Transparent-PNG.png')); ?>" height="75px" width="75px"></img></div>
                        <div><img src="<?php echo e(asset('public/webImages/FK-app-section/Autumn-Fall-Leaves-Pictures-Collage-PNG.png')); ?>" height="75px" width="75px"></img></div>
                        <div>  <img src="<?php echo e(asset('public/webImages/FK-app-section/Autumn-Fall-Leaves-Clip-Art-PNG.png')); ?>" height="75px" width="75px" ></img></div>
                        <div><img  src="<?php echo e(asset('public/webImages/FK-app-section/Green-Leaves-PNG-File.png')); ?>" height="75px" width="75px"></img></div>
                        <div> <img src="<?php echo e(asset('public/webImages/FK-app-section/Transparent-Autumn-Leaves-Falling-PNG.png')); ?>" height="75px" width="75px"></img></div>
                        <div>   <img src="<?php echo e(asset('public/webImages/FK-app-section/Realistic-Autumn-Fall-Leaves-PNG.png')); ?>" height="75px" width="75px"></div>
                        <div><img src="<?php echo e(asset('public/webImages/FK-app-section/autumn_leaves_025.png')); ?>" height="75px" width="75px"></div>
                    </div>

                    <div class="leaf leaf1">
                        <div>  <img src="<?php echo e(asset('public/webImages/FK-app-section/Fall-Autumn-Leaves-Transparent-PNG.png')); ?>" height="75px" width="75px"></img></div>
                        <div><img src="<?php echo e(asset('public/webImages/FK-app-section/Autumn-Fall-Leaves-Pictures-Collage-PNG.png')); ?>" height="75px" width="75px"></img></div>
                        <div>  <img src="<?php echo e(asset('public/webImages/FK-app-section/Autumn-Fall-Leaves-Clip-Art-PNG.png')); ?>" height="75px" width="75px" ></img></div>
                        <div><img  src="<?php echo e(asset('public/webImages/FK-app-section/Green-Leaves-PNG-File.png')); ?>" height="75px" width="75px"></img></div>
                        <div> <img src="<?php echo e(asset('public/webImages/FK-app-section/Transparent-Autumn-Leaves-Falling-PNG.png')); ?>" height="75px" width="75px"></img></div>
                        <div>   <img src="<?php echo e(asset('public/webImages/FK-app-section/Realistic-Autumn-Fall-Leaves-PNG.png')); ?>" height="75px" width="75px"></div>
                        <div><img src="<?php echo e(asset('public/webImages/FK-app-section/autumn_leaves_025.png')); ?>" height="75px" width="75px"></div>
                    </div>

                    <div class="leaf leaf2">
                        <div>  <img src="<?php echo e(asset('public/webImages/FK-app-section/Fall-Autumn-Leaves-Transparent-PNG.png')); ?>" height="75px" width="75px"></img></div>
                        <div><img src="<?php echo e(asset('public/webImages/FK-app-section/Autumn-Fall-Leaves-Pictures-Collage-PNG.png')); ?>" height="75px" width="75px"></img></div>
                        <div>  <img src="<?php echo e(asset('public/webImages/FK-app-section/Autumn-Fall-Leaves-Clip-Art-PNG.png')); ?>" height="75px" width="75px" ></img></div>
                        <div><img  src="<?php echo e(asset('public/webImages/FK-app-section/Green-Leaves-PNG-File.png')); ?>" height="75px" width="75px"></img></div>
                        <div> <img src="<?php echo e(asset('public/webImages/FK-app-section/Transparent-Autumn-Leaves-Falling-PNG.png')); ?>" height="75px" width="75px"></img></div>
                        <div>   <img src="<?php echo e(asset('public/webImages/FK-app-section/Realistic-Autumn-Fall-Leaves-PNG.png')); ?>" height="75px" width="75px"></div>
                        <div><img src="<?php echo e(asset('public/webImages/FK-app-section/autumn_leaves_025.png')); ?>" height="75px" width="75px"></div>
                    </div>
                </section>
            </div>

        </div>
        <!--</div>-->

        <div class="modal fade" id="myModal" role="dialog" data-backdrop="static">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title text-center" style="width: -webkit-fill-available;">Confirm Your Action</h4>
                    </div>
                    <div class="modal-body d-flex justify-content-around">
                        <div class="btn btn-outline-secondary py-2 px-3 font-weight-bold align-center" style="font-size: 1rem;" data-dismiss="modal">Cancel</div>
                        <div class="carrot" id="confirmDelete" style="padding: .4rem .2rem; font-size: 1rem;" onclick="deleteSpecificRole();">Confirm</div>
                        <a class="btn btn-outline-secondary py-2 px-3 font-weight-bold align-center" style="font-size: 1rem;" href="<?php echo e(route('logout')); ?>"
                           onclick="event.preventDefault();
                                         document.getElementById('logout-form').submit();">
                            <?php echo e(__('Logout')); ?>

                        </a>
                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                            <?php echo csrf_field(); ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <script type="text/javascript" src="<?php echo e(asset('public/js/main.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('public/js/jquery.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('public/bootstrap/js/bootstrap.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('public/js/toastr.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('public/js/datepicker.js')); ?>"></script>
        <?php echo $__env->yieldContent('customscript'); ?>
        <script>
                               $(function () {
                                   // INITIALIZE DATEPICKER PLUGIN
                                    $('.datepicker').datepicker({
                                        clearBtn: true,
                                        startDate: new Date(),
                                        format: "dd/mm/yyyy",
                                        autoclose: true
                                    });
                               });
                               var deleteRoleSpecific = "";
                               var deleteId;
                               var token = $("meta[name='csrf-token']").attr("content");
                               toastr.options = {
                               /*
                                Uncomment these lines when you want to stop the toast to fadeOut.
                                "timeOut": "0",
                                "extendedTimeOut": "0",
                                */
                               "timeOut": "2000",
                                       "showMethod": "fadeIn",
                                       "hideMethod": "fadeOut",
                                       "progressBar": true,
                                       "positionClass": "toast-top-center",
                               }
                               <?php if(Session::has('message')): ?>
                               var type = "<?php echo e(Session::get('alert-type', 'info')); ?>";
                               switch (type) {
                                   case 'info':
                                       toastr.info("<?php echo e(Session::get('message')); ?>");
                                       break;
                                   case 'warning':
                                       toastr.warning("<?php echo e(Session::get('message')); ?>");
                                       break;
                                   case 'success':
                                       toastr.success("<?php echo e(Session::get('message')); ?>");
                                       break;
                                   case 'error':
                                       toastr.error("<?php echo e(Session::get('message')); ?>");
                                       break;
                               }
                               <?php endif; ?>
                                       function redirection(url) {
                                           console.log("Redirection", url);
                                           window.location.replace(url);
                                       }
                               function viewOrEdit(url, type, id) {
                                   console.log("View or Edit Role", url, type, id);
                                   window.location.replace(url + '/' + type + '/' + id);
                               }
                               function putName(input) {
                                   console.log(input);
                                   var value = input.value.replace(/C:\\fakepath\\/i, '');
                                   $(input).next().html(value);
                               }
                               function headDropDown() {
                                   $("div#headDropDown").toggleClass("show");
                               }
                               function deleteModal(url, value) {
                                   $("#myModal").modal();
                                   $("div#confirmLogout").hide();
                                   $("div#confirmDelete").show();
                                   deleteRoleSpecific = url + '/' + value;
                                   deleteId = value;
                               }
                               function logoutModal() {
                                   $("#myModal").modal();
                                   $("div#confirmLogout").show();
                                   $("div#confirmDelete").hide();
                                   $("div#headDropDown").toggleClass("show");
                               }
                               function deleteSpecificRole() {
                                   console.log("Delete Specific Role", deleteRoleSpecific);
                                   var formData = {
                                       "_token": token,
                                       'id': deleteId
                                   };
                                   console.log(formData);
                                   $.ajax({
                                       type: 'DELETE',
                                       url: deleteRoleSpecific,
                                       data: formData,
                                       dataType: 'json',
                                       encode: true,
                                       success: function (res) {
                                           console.log(res);
                                           toastr.success(res["success"]);
                                           $("#reloadCard").load(" #reloadCard > *");
                                       },
                                       error: function (xhr, textStatus, errorThrown) {
                                           console.log(errorThrown, textStatus);
                                           toastr.error(textStatus);
                                           toastr.error(errorThrown);
                                       }
                                   });
                                   deleteRoleSpecific = [];
                                   $("#myModal").modal('hide');
                               }
                               // Not in use right now..
                               function logout() {
                                   var logoutUrl = "<?php echo e(route('logout')); ?>";
                                   console.log("Logout", logoutUrl);
                                   var formData = {
                                       "_token": token
                                   };
                                   $.ajax({
                                       type: 'POST',
                                       url: logoutUrl,
                                       data: formData,
                                       dataType: 'json',
                                       encode: true,
                                       success: function ()
                                       {
                                           location.reload(true);
                                       }
                                   });
                                   // location.reload(true);
                                   $("#myModal").modal('hide');
                               }

                               function csfcothersFunction() {
                                   var checkBox = document.getElementById("csfcothers");
                                   var text = document.getElementById("divcsfcother");
                                   if (checkBox.checked == true) {
                                       text.style.display = "block";
                                   } else {
                                       text.style.display = "none";
                                   }
                               }

                               function tosothersFunction() {
                                   var checkBox = document.getElementById("tosothers");
                                   var text = document.getElementById("divtosother");
                                   if (checkBox.checked == true) {
                                       text.style.display = "block";
                                   } else {
                                       text.style.display = "none";
                                   }
                               }

                               function sendToConcernForm(id, status, newurl) {
                                   var message = document.getElementById('concern_msg').innerHTML;
                                   if (message !== '') {
                                       console.log(id, status, message, newurl);
                                       var formData = {
                                           "_token": token,
                                           'id': id,
                                           'status': status,
                                           'message': message
                                       };
                                       console.log(formData);
                                       $.ajax({
                                           type: 'POST',
                                           url: newurl,
                                           data: formData,
                                           dataType: 'json',
                                           encode: true,
                                           success: function (res) {
                                               console.log(res);
                                               document.getElementById('concern_msg').innerHTML = "";
                                               $("#allMsg").load(" #allMsg > *");
                                               var bottom = document.getElementById("allMsg").scrollHeight;
                                               $('#allMsg').animate({scrollTop: bottom}, 'slow');
                                           },
                                           error: function (xhr, textStatus, errorThrown) {
                                               console.log(errorThrown, textStatus);
                                               toastr.error('There was an error saving your concern message!');
                                           }
                                       });
                                   } else {
                                       toastr.error('There was an error saving your empty concern message!');
                                   }
                               }

                               function viewText(vendorId, clientId) {
                                   // console.log(vendorId, clientId);
                                   document.getElementById("actionoptions" + vendorId).style.setProperty("display", "none", "important");
                                   document.getElementById("reason" + vendorId).style.setProperty("display", "block", "important");
                               }

                               function tgleExptBtn(element) {
                                   if ($('ul#expBtn').css('display') == "flex") {
                                       $('ul#expBtn').css('display', 'none');
                                   } else if ($('ul#expBtn').css('display') == "none") {
                                       $('ul#expBtn').css('display', 'flex');
                                   }
                               }

                               function sendFeedReason(vendorId, clientId) {
                                   // console.log(vendorId, clientId);
                                   reason = document.getElementById("textReason" + vendorId).value;
                                   copy_reason = reason.trim();
                                   if (copy_reason.length < 1) {
                                       reason = null;
                                   } else {
                                       reason = reason.replace(/\s+$/g, '');
                                   }
                                   var formData = {
                                       "_token": token,
                                       'vendorId': vendorId,
                                       'clientId': clientId,
                                       'reason': reason
                                   };
                                   console.log(formData);
                                   $.ajax({
                                       type: 'POST',
                                       url: "<?php echo e(url('client/feedback')); ?>",
                                       data: formData,
                                       dataType: 'json',
                                       encode: true,
                                       success: function (res) {
                                           console.log(res);
                                           toastr.success(res.success);
                                           setTimeout(() => {
                                               redirection("<?php echo e(url('client/feedback')); ?>");
                                           }, 2000);
                                       },
                                       error: function (xhr, textStatus, errorThrown) {
                                           console.log(errorThrown, textStatus);
                                           toastr.error('There was an error saving your feedback message!');
                                       }
                                   });
                               }

                               function approve_status(vendorId, status) {
                                   console.log(vendorId, status);
                                   if (vendorId !== "" && status !== "") {
                                       var formData = {
                                           "_token": token,
                                           'vendorId': vendorId,
                                           'status': status
                                       };
                                       clientToVendorStatus(formData, "<?php echo e(url('client/vendorDocuments/status')); ?>", "<?php echo e(url('client/view/vendorDocuments')); ?>");
                                   }
                               }

                               function disapprove_status(vendorId, status) {
                                   console.log(vendorId, status);
                                   if (vendorId !== "" && status !== "") {
                                       vendor_doc = document.getElementById('vendor_doc').value;
                                       copy_vendor_doc = vendor_doc.trim();
                                       if (copy_vendor_doc.length < 1) {
                                           vendor_doc = null;
                                       } else {
                                           vendor_doc = vendor_doc.replace(/\s+$/g, '');
                                       }
                                       var formData = {
                                           "_token": token,
                                           'vendorId': vendorId,
                                           'status': status,
                                           'vendor_doc_comment': vendor_doc
                                       };
                                       clientToVendorStatus(formData, "<?php echo e(url('client/vendorDocuments/status')); ?>", "<?php echo e(url('client/view/vendorDocuments')); ?>");
                                   }
                               }

                               function approve_meal_status(vendorId, status) {
                                   console.log(vendorId, status);
                                   if (vendorId !== "" && status !== "") {
                                       var formData = {
                                           "_token": token,
                                           'vendorId': vendorId,
                                           'status': status
                                       };
                                       clientToVendorStatus(formData, "<?php echo e(url('client/vendorMenus/status')); ?>", "<?php echo e(url('client/view/vendorMenus')); ?>");
                                   }
                               }

                               function disapprove_status(vendorId, status) {
                                   console.log(vendorId, status);
                                   if (vendorId !== "" && status !== "") {
                                       vendor_doc = document.getElementById('vendor_meal_doc').value;
                                       copy_vendor_doc = vendor_doc.trim();
                                       if (copy_vendor_doc.length < 1) {
                                           vendor_doc = null;
                                       } else {
                                           vendor_doc = vendor_doc.replace(/\s+$/g, '');
                                       }
                                       var formData = {
                                           "_token": token,
                                           'vendorId': vendorId,
                                           'status': status,
                                           'vendor_doc_comment': vendor_doc
                                       };
                                       clientToVendorStatus(formData, "<?php echo e(url('client/vendorMenus/status')); ?>", "<?php echo e(url('client/view/vendorMenus')); ?>");
                                   }
                               }

                               function clientToVendorStatus(formData, work_url, redirect_url) {
                                   console.log(formData);
                                   $.ajax({
                                       type: 'POST',
                                       url: work_url,
                                       data: formData,
                                       dataType: 'json',
                                       encode: true,
                                       success: function (res) {
                                           console.log(res);
                                           toastr.success(res.success);
                                           setTimeout(() => {
                                               redirection(redirect_url);
                                           }, 2000);
                                       },
                                       error: function (xhr, textStatus, errorThrown) {
                                           console.log(errorThrown, textStatus);
                                           toastr.error('There was an error changing vendor status!');
                                       }
                                   });
                               }
        </script>
    </body>

</html><?php /**PATH /home/nexaipaybr/public_html/foodycraft/resources/views/components/fkappsection.blade.php ENDPATH**/ ?>