<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMealCountDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('meal_count_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('client_code', 200);
            $table->char('meal_type', 40);
            $table->bigInteger('meal_rate')->nullable();
            $table->integer('meal_count');
            $table->bigInteger('total');
            $table->date('date');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('meal_count_details');
    }
}
