<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQRScanDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('qr_scan_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('qr_id');
            $table->char('client_code', 200);
            $table->integer('emp_id');
            $table->char('meal_type', 40);
            $table->char('meal_category', 50);
            $table->bigInteger('meal_rate')->nullable();
            $table->date('date');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('qr_scan_details');
    }
}
