<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientsEmpsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clients_emps', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('client_id');
            $table->char('client_code', 100);
            $table->char('emp_name', 150);
            $table->integer('emp_id')->nullable();
            $table->char('designation', 150);
            $table->char('assign_qr_status', 50);
            $table->integer('emp_height')->nullable();
            $table->integer('emp_weight')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('clients_emps');
    }
}
