<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQRDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('qr_code_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('qr_id');
            $table->integer('client_id');
            $table->char('client_code', 100);
            $table->char('meal_category', 50);
            $table->char('qr_path', 150);
            $table->integer('assigned_emp_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('qr_code_details');
    }
}
