<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMealMenusTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('meal_menus', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('vendorId');
            $table->integer('clientId');
            $table->char('morning_meal', 150)->nullable();
            $table->char('morning_description', 250)->nullable();
            $table->char('afternoon_meal', 150)->nullable();
            $table->char('afternoon_description', 250)->nullable();
            $table->char('evening_snacks', 150)->nullable();
            $table->char('snacks_description', 250)->nullable();
            $table->char('dinner_meal', 150)->nullable();
            $table->char('dinner_description', 250)->nullable();
            $table->char('client_meal_status', 50)->default('pending');
            $table->char('client_meal_comment', 200)->nullable();
            $table->dateTime('from_time');
            $table->dateTime('to_time');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('meal_menus');
    }
}
