<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRolesEventsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('roles_events', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('event_ticket');
            $table->integer('client_id');
            $table->integer('assigned_vendor')->nullable();
            $table->bigInteger('event_date');
            $table->bigInteger('guest_number');
            $table->bigInteger('rate_per_plate');
            $table->bigInteger('settled_rate')->nullable();
            $table->string('decoration_needed');
            $table->string('type_of_event');
            $table->string('status');
            $table->char('cultry_crockery', 10);
            $table->char('menu_suggest', 200)->nullable();
            $table->char('description', 200)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('roles_events');
    }
}
