<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMapRolesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('map_roles', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('clientId');
            $table->integer('marshalId');
            $table->integer('vendorId');
            $table->char('vendor_aggregation', 200)->nullable();
            $table->char('meal_time', 200)->nullable();
            $table->char('marshal_time', 20)->nullable();
            $table->string('commitment')->nullable();
            $table->char('vendor_doc_status', 50)->default('pending');
            $table->char('vendor_doc_comment', 200)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('map_roles');
    }
}
