<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMarshalsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('marshals', function (Blueprint $table) {
            $table->bigIncrements('id')->unique();
            $table->integer('marshalId')->unique();
            $table->string('username')->unique();
            $table->string('designation');
            $table->bigInteger('employeeId')->nullable();
            $table->char('govId', 100);
            $table->smallInteger('expInYrs');
            $table->string('siteAssigned');
            $table->string('assignedSite')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('marshals');
    }
}
