<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('clientId')->references('id')->on('users');
            $table->string('username')->unique()->references('username')->on('users');
            $table->string('contactName');
            $table->bigInteger('employeeNumber');
            $table->string('headOffice');
            $table->string('clientCategory');
            $table->longText('typeOfServices');
            $table->longText('clientScopeCafe');
            $table->string('paymentTerms');
            $table->char('paymentdetails', 100)->nullable();
            $table->char('paymentcycle', 80)->nullable();
            $table->char('typeServiceSuggestion', 150)->nullable();
            $table->char('clientScopeSuggestion', 150)->nullable();
            $table->char('qr_code_status', 20)->default('no');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('clients');
    }
}
