<?php

Route::group(['module' => 'Vendor', 'prefix' => 'vendor', 'middleware' => ['web', 'auth', 'role:vendor'], 'namespace' => 'App\Modules\Vendor\Controllers'], function() {

    Route::resource('vendor', 'VendorController');
    Route::get('event/{type?}/{eventId?}', 'VendorController@newOrApproved');
    Route::get('event/client/{type?}/{eventId?}', 'VendorController@newOrApproved');
    Route::post('event/response', 'VendorController@statusAcceptOrDecline');
    Route::get('submit/documents/{type}', 'VendorController@vendorDocuments');
    Route::post('submit/documents', 'VendorController@saveVendorDocuments');
    Route::get('view/clients/{clientId?}', 'VendorController@view_client');
    Route::post('meal/menu', 'VendorController@acceptMenu');
    Route::post('update/menu', 'VendorController@updateMenu');
    Route::get('concerns/{id?}', 'VendorController@allRelatedConcern');
    Route::post('concern/message', 'VendorController@concernMessageInput');

    Route::get('view/feedback/{vendorId?}/{clientId?}', 'VendorController@feedback');
    Route::get('notifications', 'VendorController@notifications');
    Route::get('client_detail/{id}', 'VendorController@client_detail');
    
    Route::get('edit/documents/{type}', 'VendorController@editvendorDocuments');
    Route::get('view/marshal/{marshalId?}', 'VendorController@view_marshal');

    //AI Feeds
    Route::get('aiFeedsClientList','VendorController@viewAIFeedClient');
    Route::get('viewAICamera/{id}','VendorController@viewAIClientCameraList');
    Route::get('viewclientaifeeds/{id}', 'VendorController@viewClientAIFeeds');
    Route::get('add_menu', 'VendorController@add_menu');
    Route::get('view_menu', 'VendorController@view_menu');
    Route::post('upload_menu', 'VendorController@upload_menu');
   

});


Route::group(['module' => 'Vendor', 'prefix' => 'vendor/ICount/I-count', 'middleware' => ['web', 'auth', 'role:vendor'], 'namespace' => 'App\Modules\Vendor\Controllers'], function() {

    Route::get('scan_view', function(){
        return view("Vendor::icount/scan_qr");
    });
    Route::get('client_invoice_list/{search?}', 'VendorController@client_invoice_list');
    Route::get('view_invoice', 'VendorController@view_invoice');
    Route::post('export_invoice', 'VendorController@export_invoice');
    
    
    Route::get('place_dining_order/{clientid?}/{vendorid?}/{qrid?}', 'VendorController@place_dining_order');
    Route::any('diningplace', 'VendorController@diningplace');
    
    //Generate Dining Sale Reports
    Route::get('alldiningsalereport/{search?}', 'VendorController@alldiningsalereport');
    Route::match(['get', 'post'], 'generate_diningsale_report', 'VendorController@generate_diningsale_report');

});

 

// Route::post('ai_feed', 'App\Modules\Vendor\Controllers\VendorController@aiFeedsAlert');
// Route::post('ai_feed/video/{id}', 'App\Modules\Vendor\Controllers\VendorController@aiFeedsVideoAlert');
// Route::get('ai_feed/mail', 'App\Modules\Vendor\Controllers\VendorController@sendAIMail');