@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>All Notifications</h3>
                </div>
                <div class="card-body">
                    @if(isset($notifications))
                        <div class="table-responsive p-2">
                            <table class="table table-hover">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-center" scope="col">S.No.</th>
                                        <th class="text-center" scope="col">From</th>
                                        <th class="text-center" scope="col">To</th>
                                        <th class="text-center" scope="col">Subject</th>
                                        <!-- <th scope="col" class="d-flex justify-content-center">Action</th> -->
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($notifications as $value)
                                        <?php
                                            // dd($value->content);
                                        ?>
                                        <tr>
                                            <td class="text-center" scope="row">{{ $loop->iteration }}</td>
                                            <td class="text-center">{{ $value->from }}</td>
                                            <td class="text-center">{{ $value->to }}</td>
                                            <td class="text-center">{{ $value->subject }}</td>
                                            <td class="text-center" style="padding: 0px">
                                                @php
                                                    $url = "";
                                                    if($value->type == 'usercreate'){
                                                        $url = url('viewOrEditRole/view') . '/' . $value->content;
                                                    }else if($value->type == 'newMapping'){
                                                        $contents = explode(", ", $value->content);
                                                        $id = $contents[1];
                                                        $role = $contents[0] == 'marshal' ? 'sitemarshal' : $contents[0];
                                                        $url = url('existingMap') . '/' . $role . '/' . $id;
                                                    }else if($value->type == 'newEvent'){
                                                        $url = url('notification/event') . '/' . $value->content;
                                                    }else if($value->type == 'newConcern'){
                                                        $url = url('view/concern') . '/' . $value->content;
                                                    }
                                                @endphp
                                                <!-- <a class="btn btn-info mx-1" style="color: cornsilk;font-size: smaller;font-weight: bold;" title="View" href="{{ $url }}">
                                                    <i class="fa fa-eye"></i>
                                                </a>
                                                <a class="btn btn-danger mx-1" style="color: cornsilk;font-size: smaller;font-weight: bold;" title="Delete" href="#">
                                                    <i class="fa fa-trash"></i>
                                                </a> -->
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" align="center">No Notifications Yet!</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
                <div class="card-footer p-0" style="align-self: center;text-align: center;border-bottom: none;border-top: none;color: #d45353;display: flex;justify-content: center;">
                    <h6>{{ $notifications->links() }}</h6>
                </div>
            </div>
        </div>
    </div>
@endsection