@extends('layouts.masterDashboard')
@section('content')
    <dov class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>{{ isset($allClients) ? 'Clients List' : (isset($clientDetails) ? 'Client Meal Menu' : '') }}</h3>
                </div>
                <div class="card-body">
                    @if(isset($allClients))
                        <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-hover">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-left" scope="col">S.No.</th>
                                        <th class="text-left" scope="col">Client (Name - Code)</th>
                                        <th class="text-left" scope="col">Contact Person</th>
                                        <th class="text-left" scope="col">Phone No.</th>
                                        <th scope="col" class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($allClients as $client)
                                        <tr>
                                            <th class="text-left" scope="row">{{ $loop->iteration }}</th>
                                            <td class="text-left">{{ $client->name . ' - ' . $client->username }}</td>
                                            <td class="text-left">{{ $client->contactName }}</td>
                                            <td class="text-left">{{ $client->contactNumber }}</td>
                                            <td class="d-flex justify-content-center">
                                                <form method='GET' action='{{ url('vendor/ICount/I-count/generate_diningsale_report') }}'>
                                                  <input type='hidden' name='_token' value='{{ csrf_token() }}' >
                                                  <input type='hidden' name='client_id' value="{{ $client->clientId }}" >
                                                  <input type='hidden' name='client_name' value="{{ $client->contactName }}" >
                                                  <input type='hidden' name='client_code' value="{{ $client->username }}" >
                                                  <input type='hidden' name='client_contact_name' value="{{ $client->contactNumber }}" >
                                                  <input type='submit' style="padding: 8px!important;font-size: 14px;font-weight: bold;" class='btn btn-info p-1 mx-1' value='Generate Sale Report' >
                                              </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" align="center">Not Found any</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection