@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>Events</h3>
                </div>
                <div class="card-body">
                    @if(!isset($type))
                        <div class="d-flex justify-content-center">
                            <button class="peterriver mr-4 w-25" onclick="redirection('{{ url('vendor/event/newList') }}');">Pending Events</button>
                            <button class="peterriver ml-4 w-25" onclick="redirection('{{ url('vendor/event/approvedList') }}');">Approved Events</button>
                        </div>
                    @elseif(isset($type))
                        @if($type == "newList")
                            <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                                <table class="table table-hover">
                                    <thead class="text-dark">
                                        <tr>
                                            <th class="text-center" scope="col">S.No.</th> 
                                            <th class="text-center" scope="col">Client Name</th> 
                                            <th class="text-center" scope="col">Type of Event</th>
                                            <th scope="col" class="d-flex justify-content-center">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($newList as $key=>$value)
                                            <tr>
                                                <th class="text-center" scope="row">{{ ++$key }}</th>
                                                <td class="text-center">{{ $value->client_name }}</td>
                                                <td class="text-center">{{ $value->type_of_event }}</td>
                                                <td class="d-flex justify-content-center">
                                                    <a href="{{ url('vendor/event/client/specificEvent').'/'.$value->event_ticket }}" class="peterriver text-decoration-none text-white py-0">View</a>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="7" align="center">Not Found any</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        @elseif($type == "approvedList")
                            <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                                <table class="table table-hover">
                                    <thead class="text-dark">
                                        <tr>
                                            <th class="text-center" scope="col">S.No.</th> 
                                            <th class="text-center" scope="col">Client Name</th> 
                                            <th class="text-center" scope="col">Type of Event</th>
                                            <th scope="col" class="d-flex justify-content-center">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($approvedList as $key=>$value)
                                            <tr>
                                                <th class="text-center" scope="row">{{ ++$key }}</th>
                                                <td class="text-center">{{ $value->client_name }}</td>
                                                <td class="text-center">{{ $value->type_of_event }}</td>
                                                <td class="d-flex justify-content-center">
                                                    <div class="alizarin" style="padding: .3rem .2rem;" onclick="console.log('Delete the Approved Event');">Delete</div>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="7" align="center">Not Found any</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        @elseif($type == "specificEvent")
                            <form method="POST" action="{{ url('vendor/event/response') }}" class="border rounded my-4 mx-2 p-4 shadow-sm" style="background-color: #f5f5f58c;border: 1px solid #b8daff;">
                                @csrf
                                <input type="hidden" name="ticket" value="{{ $specificEvent->event_ticket }}" />
                                <div class="row">
                                    <div class="col-md-4 col-sm-12 pr-md-1">
                                        <div class="form-group">
                                            <label for="reservationDate">Date of Event</label>
                                            <div class="input-group p-0 shadow-sm">
                                                <input type="text" class="form-control" value="{{ date('d/m/Y', $specificEvent->event_date) }}" readonly />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-12">
                                        <div class="form-group">
                                            <label for="guest_num">Guests Number</label>
                                            <input type="text" name="guest_num" class="form-control" value="{{ $specificEvent->guest_number }}" readonly />
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-12">
                                        <div class="form-group">
                                            <label for="plate_rate">Rates Per Plate</label>
                                            <input class="form-control shadow-sm" name="plate_rate" value="{{ $specificEvent->settled_rate }}" readonly />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 col-sm-12">
                                        <div class="form-group">
                                            <label for="plate_rate">Type of Event</label>
                                            <input class="form-control shadow-sm" name="plate_rate" value="{{ $specificEvent->type_of_event }}" readonly />
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-sm-12">
                                        <div class="form-group">
                                            <h5 class="text-center d-flex justify-content-center"><span class="border-bottom">Decoration needed</span></h5>
                                            <div class="d-flex justify-content-around flex-wrap">
                                                <?php
                                                    $decoration = isset($specificEvent->decoration_needed) && !empty($specificEvent->decoration_needed);
                                                ?>
                                                <label class="radio mx-4 my-2">
                                                    <input type="radio" name="eventDecoration" value="yes" <?php echo (!isset($specificEvent->decoration_needed) && empty($specificEvent->decoration_needed)) ? "" : ($specificEvent->decoration_needed == "yes" ? ($type == "view" ? "checked disabled" : "checked") : ($type == "edit" ? "" : "disabled")) ?> />
                                                    <span>Yes</span>
                                                </label>
                                                <label class="radio mx-4 my-2">
                                                    <input type="radio" name="eventDecoration" value="no" <?php echo (!isset($specificEvent->decoration_needed) && empty($specificEvent->decoration_needed)) ? "" : ($specificEvent->decoration_needed == "no" ? ($type == "view" ? "checked disabled" : "checked") : ($type == "edit" ? "" : "disabled")) ?> />
                                                    <span>No</span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 col-sm-12">
                                        <div class="form-group">
                                            <h5 class="text-center d-flex justify-content-center">
                                                <span class="border-bottom">Contract Response</span>
                                            </h5>
                                            <div class="d-flex justify-content-between flex-wrap">
                                                <label class="radio mx-4 my-2">
                                                    <input type="radio" name="approval" value="approved" checked />
                                                    <span>Accept</span>
                                                </label>
                                                <label class="radio mx-4 my-2">
                                                    <input type="radio" name="approval" value="decline" />
                                                    <span>Decline</span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row d-flex justify-content-center">
                                    <div class="back">
                                        <div class="wetasphalt" style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;" onclick="redirection('{{ url()->previous() }}');">Back</div>
                                    </div>
                                    <div class="response">
                                        <button type="submit" class="sunflower w-100" style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;">Response</button>
                                    </div>
                                </div>
                            </form>
                        @endif
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
