@extends('layouts.placeordermasterDashboard')
<?php
    $roleName = "vendor";
    // dd($result, $roleName);
?>
@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="main-card mb-3 card">
            <div class="card-header p-2">
                <h3 class="w-100 text-center">Place Dining Order</h3>
            </div>
            <div class="card-body">
                <form method="POST" class="fkformlabel" action="{{ url('vendor/ICount/I-count/diningplace') }}" enctype='multipart/form-data'>
                    @csrf
                    <input id="foodscraftRole" type="hidden" name="foodscraftRole" value="Vendor" readonly />
                    <div class="row">
                        <div class="col-md-3 col-sm-12 pr-md-1">
                          <div class="form-group">
                              <label for="name">Client's ID</label>
                              <span class="required-field">*</span>
                              <input type="text" id="clientid" class="form-control" autocomplete="off" name="clientid" value="{{ isset($clientid) ? $clientid : null }}" readonly />
                          </div>
                        </div>
                        <div class="col-md-3 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="username">Vendor's ID</label>
                                <span class="required-field">*</span>
                                <input type="text" id="vendorid" class="form-control" autocomplete="off" name="vendorid" value="{{ isset($vendorid) ? $vendorid : null }}" readonly />
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="email">QR ID</label>
                                <span class="required-field">*</span>
                                <input type="text" id="qrid" class="form-control" autocomplete="off" name="qrid" value="{{ isset($qrid) ? $qrid : null }}" readonly />
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="email">QR Type</label>
                                <span class="required-field">*</span>
                                <input type="text" id="qrtype" class="form-control" autocomplete="off" name="qrtype" value="type4" readonly />
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                      <div class="col-md-4 col-sm-12 pl-md-1 mb-sm-2">
                            <div class="form-group">
                                <label for="mealtype">Meal Type</label>
                                <span class="required-field">*</span>
                                <select class="form-control" name="mealtype" id="mealtype" required>
                                    <option value="" checked>Select Meal Type</option>
                                    <option value="breakfast">Breakfast</option>
                                    <option value="lunch">Lunch</option>
                                    <option value="dinner">Dinner</option>
                                    <!--<option value="evening">Evening Snacks</option>-->
                                    <option value="others">Others</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                      <div class="col-md-4 col-sm-12 pl-md-1 mb-sm-2">
                          <div class="form-group">
                              <label for="itemname1">Item Name 1</label>
                              <span class="required-field">*</span>
                              <select class="form-control" name="itemname1" id="itemname1" required>
                                  <option value="">Select Item Name</option>
                                  <?php foreach($items as $item) { ?>
                                    <option value="<?php echo $item->item_code; ?>"><?php echo $item->item_name; ?></option>
		                          <?php } ?>
                              </select>
                          </div>
                      </div>
                      <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="itemquantity1">Item Quantity</label>
                                <span class="required-field">*</span>
                                <input type="number" id="itemquantity1" class="form-control" autocomplete="off" name="itemquantity1" value="" min="1" required />
                            </div>
                        </div>                      
                    </div>
                    
                    <div class="row">
                      <div class="col-md-4 col-sm-12 pl-md-1 mb-sm-2">
                          <div class="form-group">
                              <label for="itemname2">Item Name 2</label>
                              <span class="required-field">*</span>
                              <select class="form-control" name="itemname2" id="itemname2">
                                  <option value="">Select Item Name</option>
                                  <?php foreach($items as $item) { ?>
                                    <option value="<?php echo $item->item_code; ?>"><?php echo $item->item_name; ?></option>
		                          <?php } ?>
                              </select>
                          </div>
                      </div>
                      <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="itemquantity2">Item Quantity</label>
                                <span class="required-field">*</span>
                                <input type="number" id="itemquantity2" class="form-control" autocomplete="off" name="itemquantity2" value="" min="1"/>
                            </div>
                        </div>                      
                    </div>
                    
                    <div class="row">
                      <div class="col-md-4 col-sm-12 pl-md-1 mb-sm-2">
                          <div class="form-group">
                              <label for="itemname3">Item Name 3</label>
                              <span class="required-field">*</span>
                              <select class="form-control" name="itemname3" id="itemname3">
                                  <option value="">Select Item Name</option>
                                  <?php foreach($items as $item) { ?>
                                    <option value="<?php echo $item->item_code; ?>"><?php echo $item->item_name; ?></option>
		                          <?php } ?>
                              </select>
                          </div>
                      </div>
                      <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="itemquantity3">Item Quantity</label>
                                <span class="required-field">*</span>
                                <input type="number" id="itemquantity3" class="form-control" autocomplete="off" name="itemquantity3" value="" min="1"/>
                            </div>
                        </div>                      
                    </div>
                    
                    <div class="row">
                      <div class="col-md-4 col-sm-12 pl-md-1 mb-sm-2">
                          <div class="form-group">
                              <label for="itemname4">Item Name 4</label>
                              <span class="required-field">*</span>
                              <select class="form-control" name="itemname4" id="itemname4">
                                  <option value="">Select Item Name</option>
                                  <?php foreach($items as $item) { ?>
                                    <option value="<?php echo $item->item_code; ?>"><?php echo $item->item_name; ?></option>
		                          <?php } ?>
                              </select>
                          </div>
                      </div>
                      <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="itemquantity4">Item Quantity</label>
                                <span class="required-field">*</span>
                                <input type="number" id="itemquantity4" class="form-control" autocomplete="off" name="itemquantity4" value="" min="1"/>
                            </div>
                        </div>                      
                    </div>
                    
                    <div class="row">
                      <div class="col-md-4 col-sm-12 pl-md-1 mb-sm-2">
                          <div class="form-group">
                              <label for="itemname5">Item Name 5</label>
                              <span class="required-field">*</span>
                              <select class="form-control" name="itemname5" id="itemname5">
                                  <option value="">Select Item Name</option>
                                  <?php foreach($items as $item) { ?>
                                    <option value="<?php echo $item->item_code; ?>"><?php echo $item->item_name; ?></option>
		                          <?php } ?>
                              </select>
                          </div>
                      </div>
                      <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="itemquantity5">Item Quantity</label>
                                <span class="required-field">*</span>
                                <input type="number" id="itemquantity5" class="form-control" autocomplete="off" name="itemquantity5" value="" min="1"/>
                            </div>
                        </div>                      
                    </div>
                    
                    <div class="row">
                      <div class="col-md-4 col-sm-12 pl-md-1 mb-sm-2">
                          <div class="form-group">
                              <label for="itemname6">Item Name 6</label>
                              <span class="required-field">*</span>
                              <select class="form-control" name="itemname6" id="itemname6">
                                  <option value="">Select Item Name</option>
                                  <?php foreach($items as $item) { ?>
                                    <option value="<?php echo $item->item_code; ?>"><?php echo $item->item_name; ?></option>
		                          <?php } ?>
                              </select>
                          </div>
                      </div>
                      <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="itemquantity6">Item Quantity</label>
                                <span class="required-field">*</span>
                                <input type="number" id="itemquantity6" class="form-control" autocomplete="off" name="itemquantity6" value="" min="1"/>
                            </div>
                        </div>                      
                    </div>
                    
                    <div class="row">
                        <div class="update ml-auto mr-auto">
                            <button type="submit" class="turquoise">{{ __('Place Order') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection