@extends('layouts.masterDashboard')
@section('content')
    <dov class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>{{ isset($allClients) ? 'Clients List' : (isset($clientDetails) ? 'Client Meal Menu' : '') }}</h3>
                </div>
                <div class="card-body">
                    @if(isset($allClients))
                        <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-hover">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-left" scope="col">S.No.</th>
                                        <th class="text-left" scope="col">Client (Name - Code)</th>
                                        <th class="text-left" scope="col">Contact Person</th>
                                        <th class="text-left" scope="col">Phone No.</th>
                                        <th scope="col" class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($allClients as $client)
                                        <tr>
                                            <th class="text-left" scope="row">{{ $loop->iteration }}</th>
                                            <td class="text-left">{{ $client->name . ' - ' . $client->username }}</td>
                                            <td class="text-left">{{ $client->contactName }}</td>
                                            <td class="text-left">{{ $client->contactNumber }}</td>
                                            <td class="d-flex justify-content-center">
                                                <a href="{{ url('vendor/client_detail/'.$client->clientId) }}" title="Menu" class="btn btn-info mx-2 font-weight-bold">View Client</a>
                                                <a href="{{ url('vendor/view/clients/'.$client->clientId) }}" title="Menu" class="btn btn-info mx-2 font-weight-bold">View Menu</i></a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" align="center">Not Found any</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @elseif(isset($clientDetails))
                        <form action="{{ isset($menu) ? url('vendor/update/menu') : url('vendor/meal/menu') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @if(isset($menu))
                                <input type="hidden" name="requestId" value="{{ $menu->id }}" />
                            @endif
                            <!-- Client Info -->
                            <div class="row">
                                @php
                                    $dt_min = new DateTime('-10 minutes');
                                    $dt_min = $dt_min->format('Y-m-d\TH:i');
                                    if(isset($menu)){
                                        $datetime_from = new DateTime($menu->from_time);
                                        $datetime_from = $datetime_from->format('Y-m-d\TH:i');
                                        $datetime_to = new DateTime($menu->to_time);
                                        $datetime_to = $datetime_to->format('Y-m-d\TH:i');
                                    }
                                @endphp
                                <div class="form-group col">
                                    <label for="clientId">Client (Name - Code)</label>
                                    <input class="form-control" type="text" value="{{ $clientDetails->name.' - '.$clientDetails->username }}" id="clientId" readonly />
                                    <input type="hidden" name="clientId" value="{{ $clientDetails->id }}" />
                                    <input type="hidden" name="vendorId" value="{{ Auth::user()->id }}" />
                                </div>
                                <div class="form-group col">
                                    <label for="fromtime">Client Menu From</label>
                                    <input class="form-control" name="from_time" min="{{ $dt_min }}" value="{{ isset($menu) ? $datetime_from : '' }}" type="datetime-local" placeholder="Meal from.." id="fromtime" required />
                                </div>
                                <div class="form-group col">
                                    <label for="totime">Client Menu To</label>
                                    <input class="form-control" name="to_time" min="{{ $dt_min }}" value="{{ isset($menu) ? $datetime_to : '' }}" type="datetime-local" placeholder="Meal to.." id="totime" required />
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col">
                                    <p style="margin-bottom: .55rem;">Upload Menu</p>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="menu" lang="es" name="menu" onchange="putName(this);" accept=".doc, .pdf" required />
                                        <label class="custom-file-label" for="menu">Menu</label>
                                    </div>
                                </div>
                                <div class="form-group col">
                                    <label for="suggestion">Suggestion Box</label>
                                    <textarea name="suggestion" class="form-control" id="suggestion" readonly>{!! isset($menu) ? $menu->client_meal_comment : '' !!}</textarea>
                                </div>
                            </div>
                            @if(isset($menu) && isset($menu->morning_meal))
                                <div class="row">
                                    <div class="form-group col-3">
                                        <label for="uploaded_menu">Uploaded Menu: </label>
                                        <a href="{{ url('public/storage/menu/vendors').'/'.$menu->vendorId.'/'.$menu->morning_meal }}" target="_blank" class="btn btn-primary font-weight-bold">Menu</a>
                                    </div>
                                </div>
                            @endif
                            <!-- Submit -->
                            <div class="row">
                                <div class="update ml-auto mr-auto">
                                    @if(!isset($menu))
                                        <button type="submit" class="turquoise">Submit</button>
                                    @elseif(isset($menu))
                                        <button type="submit" class="sunflower">Edit</button>
                                    @endif
                                </div>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection