@extends('layouts.masterDashboard')
@section('content')
    <dov class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>{{ isset($allMarshals) ? 'Marshal List' : ''}}</h3>
                </div>
                <div class="card-body">
                    @if(isset($allMarshals))
                        <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-hover">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-left" scope="col">S.No.</th>
                                        <th class="text-left" scope="col">Marshal Name</th>
                                        <th class="text-left" scope="col">Email</th>
                                        <th class="text-left" scope="col">Phone No.</th>
                                        <!--<th scope="col" class="text-center">Action</th>-->
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($allMarshals as $marshal)
                                        <tr>
                                            <th class="text-left" scope="row">{{ $loop->iteration }}</th>
                                            <td class="text-left">{{ $marshal->name }}</td>
                                            <td class="text-left">{{ $marshal->email }}</td>
                                            <td class="text-left">{{ $marshal->contactNumber }}</td>
<!--                                            <td class="d-flex justify-content-center">
                                                <a href="{{ url('vendor/marshal_detail/'.$marshal->marshalId) }}" title="Menu" class="btn btn-info mx-2 font-weight-bold">View Marshal</a>
                                            </td>-->
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" align="center">Not Found any</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection