<?php

namespace App\Modules\Vendor\Controllers;

use App\AIFeed;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Role;
use Illuminate\Validation\Rule;
use Illuminate\Http\Request;
use App\ConcernMessage;
use App\Notifications;
use App\RaiseConcern;
use App\VendorDocs;
use App\RolesEvent;
use App\MealMenu;
use App\MapRole;
use App\Feedback;
use App\Marshal;
use App\Vendor;
use App\Client;
use App\Invoice;
use App\MealCountDetail;
use App\Exports\InvoiceExport;
use App\Mail\SendMail;
use Excel;
use Validator;
use App\User;
use Auth;
use Hash;
use App\CsvData;
use App\Imports\CsvDataImport;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Imports\UsersImport;
use App\Imports\ImportMenu;
use DB;
 
use App\Type4QrScanDetail;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;

class VendorController extends Controller
{

    public function view_client(int $clientId=null)
    {
        if($clientId == null)
        {
            $allClients = MapRole::where('vendorId', Auth::user()->id)
                ->join('users', 'map_roles.clientId', '=', 'users.id')
                ->join('clients', 'users.id', 'clients.clientId')
                ->select(
                    'name',
                    'users.username',
                    'email',
                    'contactNumber',
                    'address',
                    'map_roles.clientId',
                    'clients.contactName'
                )
                // ->groupBy('username')
                ->get();
            // dd($allClients);
            return view('Vendor::clientMenu', compact('allClients'));
        }
        else
        {
            // dd("ClientId: ", $clientId);
            $menu = MealMenu::where('clientId', $clientId)
                ->where('vendorId', Auth::user()->id)
                ->select(
                    'id',
                    'clientId',
                    'vendorId',
                    'morning_meal',
                    'morning_description',
                    'client_meal_comment',
                    'from_time',
                    'to_time'
                )
                ->orderBy('id', 'DESC')
                ->first();
            $clientDetails = User::where('id', $clientId)->select('id', 'name', 'username', 'email')->first();
            // dd($menu);
            return view('Vendor::clientMenu', compact('menu', 'clientDetails'));
        }
    }

    protected function userInfo($id)
    {
        return User::where('id', $id)
            ->select('id', 'name', 'email', 'username', 'contactNumber', 'address')
            ->first()->toArray();
    }

    protected function clientDetails($user)
    {
        return Client::where([
                ['clientId', '=', $user['id']],
                ['username', '=', $user['username']]
            ]);
    }

    public function client_detail(int $id)
    {
        $user = $this->userInfo($id);
        $role['foodscraftRole'] = User::find($id)->getRoleNames()->toArray()[0];
        $details = [];
        if($role['foodscraftRole'] == "client"){
            $details = $this->clientDetails($user)->first()->toArray();
        }
        $result = array_merge($user, array_merge($details, $role));
        $type = "view";
        return view("Vendor::client_detail", compact('result', 'type'));
    }

    public function validateMenu($menu)
    {
        return Validator::make($menu, [
            'from_time' => 'required',
            'to_time' => 'required',
            'clientId' => 'required|integer',
            'menu' => 'required|mimes:doc,pdf,docx,zip,xls|max:10000'
        ]);
    }

    public function acceptMenu(Request $request)
    {
        // dd($request->all());
        $validate = $this->validateMenu($request->all());
        // dd($validate->fails());
        if($validate->fails()){
            return back()->with($this->errorBag($validate->errors()->all()));
        }else{
            $new_file_name = md5(uniqid()) . '.' . $request->file('menu')->getClientOriginalExtension();
            $path = $request->file('menu')->move(storage_path() . '/menu_import/', $new_file_name);
            Excel::import(new ImportMenu, $path);
            if(isset($request->menu) && !empty($request->menu)){
                $files = $request->menu;
                $name = pathinfo($files->getClientOriginalName(), PATHINFO_FILENAME);
                $extension = $files->getClientOriginalExtension();
                $storageName = $name . '_' . rand(10, 10000) . '.' . $extension;
                $store = $files->storeAs('public/menu/vendors/'.Auth::user()->id.'/', $storageName);
            }
            MealMenu::create([
                'vendorId' => Auth::user()->id,
                'clientId' => $request->clientId,
                'from_time' => $request->from_time,
                'to_time' => $request->to_time,
                'morning_meal' => $storageName
            ]);
            return redirect('vendor/view/clients')->with(["message" => "Menu Submitted Successfully.", "alert-type" => "success"]);
        }
    }

    public function updateMenu(Request $request)
    {
        // dd($request->all());
        $validate = $this->validateMenu($request->all());
        // dd($validate->fails());
        if($validate->fails()){
            $request->flash();
            return back()->with($this->errorBag($validate->errors()->all()));
        }else{
            if(isset($request->menu) && !empty($request->menu)){
                $files = $request->menu;
                $name = pathinfo($files->getClientOriginalName(), PATHINFO_FILENAME);
                $extension = $files->getClientOriginalExtension();
                $storageName = $name . '_' . rand(10, 10000) . '.' . $extension;
                $store = $files->storeAs('public/menu/vendors/'.Auth::user()->id.'/', $storageName);
            }
            MealMenu::where('vendorId', Auth::user()->id)
            ->where('clientId', $request->clientId)
            ->update([
                'vendorId' => Auth::user()->id,
                'clientId' => $request->clientId,
                'from_time' => $request->from_time,
                'to_time' => $request->to_time,
                'morning_meal' => $storageName
            ]);
            return redirect('vendor/view/clients')->with(["message" => "Menu Submitted Successfully.", "alert-type" => "success"]);
        }
    }
    
    public function allRelatedConcern(int $id=null)
    {
        // dd($id);
        if($id == null){
            $concerns = MapRole::where('vendorId', Auth::user()->id)
                ->join('raise_concerns', 'map_roles.clientId', '=', 'raise_concerns.clientId')
                ->join('users as u1', 'raise_concerns.clientId', '=', 'u1.id')
                ->select('raise_concerns.*', 'u1.name', 'u1.username')
                ->distinct()
                ->get();
            // dd($concerns);
            return view('Vendor::concern', compact('concerns'));
        }else{
            // dd($id);
            $concern = RaiseConcern::where('raise_concerns.id', $id)
                ->join('users as u1', 'raise_concerns.clientId', '=', 'u1.id')
                ->join('clients', 'u1.id', '=', 'clients.clientId')
                ->join('users as u2', 'raise_concerns.vendorEmail', '=', 'u2.email')
                ->select(
                    'raise_concerns.id',
                    'clients.clientId',
                    'description',
                    'vendorEmail',
                    'status',
                    'comment',
                    'images',
                    'videos',
                    'u1.name as client_name',
                    'u1.username as client_code',
                    'u1.contactNumber as client_number',
                    'clients.contactName as client_contact_person',
                    'u2.username as vendor_username',
                    'u2.name as vendor_name'
                )
                ->first();
            $messages = ConcernMessage::where('concern_id', $id)
                ->where('status', '!=', 'closed')
                ->orderBy('created_at')->get();
            // dd($concern);
            return view('Vendor::concern', compact('concern', 'messages'));
        }
    }

    public function concernMessageInput(Request $request)
    {
        \Log::info($request->all());
        try{
            $concern_msg = new ConcernMessage;
            $concern_msg->concern_id = $request->id;
            $concern_msg->status = $request->status;
            $concern_msg->sender = Auth::user()->username;
            $concern_msg->messages = $request->message;
            $concern_msg->save();
            return response()->json([
                'success' => 'Concern Message Saved Successfully!'
            ]);
        }
        catch(Exception $e){
            \Log::info($e);
        }
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function newOrApproved($type = null, $eventId = null)
    {
        if($type == null){
            return view("Vendor::events");
        }else{
            switch($type){
                case "newList":
                    $newList = RolesEvent::where('assigned_vendor', Auth::user()->id)
                    ->where('status', 'pending')
                    ->join('users as u1', 'roles_events.client_id', '=', 'u1.id')
                    ->select('roles_events.*', 'u1.name as client_name', 'u1.username as client_username')
                    ->get();
                    return view("Vendor::events", compact('newList', 'type'));
                    break;
                case "approvedList":
                    $approvedList = RolesEvent::where('assigned_vendor', Auth::user()->id)
                    ->where('status', 'approved')
                    ->join('users as u1', 'roles_events.client_id', '=', 'u1.id')
                    ->select('roles_events.*', 'u1.name as client_name', 'u1.username as client_username')
                    ->get();
                    return view("Vendor::events", compact('approvedList', 'type'));
                    break;
                case "specificEvent":
                    $specificEvent = RolesEvent::where('event_ticket', $eventId)->where('assigned_vendor', Auth::user()->id)->first();
                    return view("Vendor::events", compact('specificEvent', 'type'));
                    break;
                default:
                    dd("Invalid Type");
                    break;
            }
        }
    }

    protected function errorBag(array $errors)
    {
        $message = ["message" => implode(" ", $errors), "alert-type" => "error"];
        return $message;
    }

    public function statusAcceptOrDecline(Request $request)
    {
        // dd($request->all());
        $validate = Validator::make($request->all(), [
            'approval' => ['required', Rule::in(['decline', 'approved'])],
        ]);

        if($validate->fails()){
            return back()->with($this->errorBag($validate->errors()->all()));
        }else{
            if($request->approval == "decline"){
                // NOTIFY
                RolesEvent::where('assigned_vendor', Auth::user()->id)
                    ->where('id', (int)$request->event_ticket)
                    ->update([
                        'assigned_vendor' => 0,
                        'status' => $request->approval
                    ]);
            }elseif($request->approval == "approved"){
                // dd($request->approval, Auth::user()->id,(int)$request->ticket);
                RolesEvent::where('assigned_vendor', Auth::user()->id)
                    ->where('event_ticket', (int)$request->ticket)
                    ->update([
                        'status' => $request->approval
                    ]);
            }
            return redirect('vendor/event')->with(["message" => "Event Updated Successfully", "alert-type" => "success"]);
        }
    }

    public function vendorDocuments($type)
    {
        $elements = VendorDocs::where('vendorId', Auth::user()->id)->first();
        if($elements == null){
            return view('Vendor::reqDocs', compact('type'));
        }else{
            $type = "submitted";
            return view('Vendor::reqDocs', compact('elements', 'type'));
        }
    }
    
    public function editvendorDocuments($type)
    {
      //$type = "resubmit";
      $elements = VendorDocs::where('vendorId', Auth::user()->id)->first();
      return view('Vendor::editreqDocs', compact('elements', 'type'));
    }

    public function saveVendorDocuments(Request $request)
    {
        // dd($request->all());
        // dd(count($request->all()));
        $validate = Validator::make($request->all(), [
            'companyProfile.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
            'fssai.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
            'gst.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
            'panCard.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
            'companyReg.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
            //'pf.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
            //'labourLicense.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
            //'workerHealth.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
            //'foodTestReport.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
            //'waterTestReport.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
            //'pestControlReport.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
            //'kitchenAuditReport.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
            //'policeVerificationReport.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
            //'cancelledCheque.*' => 'required|mimes:doc,pdf,docx,zip|max:10000'
        ]);

        if($validate->fails()){
            return back()->with($this->errorBag($validate->errors()->all()));
        }elseif(!$validate->fails() && count($request->all()) == 1){
            // dd("only token");
            return back()->with(["message" => "Nothing to submit!", "alert-type" => "warning"]);
        }else{
            //dd("hello");
            $elements = [];
            foreach($request->all() as $key => $files){
                if($key !== "_token"){
                    // dd(is_file($files));
                    // dd(is_string($files));
                    if(is_file($files)){
                        $name = pathinfo($files->getClientOriginalName(), PATHINFO_FILENAME);
                        $extension = $files->getClientOriginalExtension();
                        $storageName = $name . '_' . rand(10, 10000) . '.' . $extension;
                        $store = $files->storeAs('public/documents/vendors/'.Auth::user()->id.'/', $storageName);
                        $elements = VendorDocs::updateOrCreate(
                            ['vendorId' => Auth::user()->id],
                            [$key => $storageName]
                        );
                    }elseif(is_string($files)){
                        // dd($key, $files);
                        $elements = VendorDocs::updateOrCreate(
                            ['vendorId' => Auth::user()->id],
                            [$key => $files]
                        );
                    }
                }
            }
            $map_role_doc_status = MapRole::where('vendorId', Auth::user()->id)->update(['vendor_doc_status' => 'submitted']);
            if(isset($elements) && !empty($elements)){
              $elements = $elements->toArray();
            }
            //$elements = $elements->toArray();
            $type = "submitted";
            $docredirect = $request->docredirect;
            if(isset($docredirect) && !empty($docredirect)){
              $elements = VendorDocs::where('vendorId', Auth::user()->id)->first();
              //return view('Vendor::reqDocs', compact('elements', 'type', 'docredirect'));
              return redirect('vendor/submit/documents/new')->with(["message" => "Documents Submitted Successfully", "alert-type" => "success"]);
            } else {
              return back()->with(["message" => "Documents Submitted Successfully", "alert-type" => "success"]);
            }            
        }
    }

    public function feedback(int $vendorId=null, int $clientId=null)
    {
        if($clientId == null){
            $clientList = Feedback::join('map_roles', function($join){
                $join->on('feedback.clientId', '=', 'map_roles.clientId')
                ->on('feedback.vendorId', '=', 'map_roles.vendorId');
            })
            ->join('users', 'map_roles.clientId', '=', 'users.id')
            ->get();
            // dd($clientList);
            return view('Vendor::feedback', compact('clientList'));
        }else{
            $menuDetails = MealMenu::where('vendorId', $vendorId)->where('clientId', $clientId)->orderBy('id', 'DESC')->first();
            $vendorDetails = User::where('id', $vendorId)->select('id', 'name', 'username', 'email')->first();
            return view('Vendor::feedback', compact('menuDetails', 'vendorDetails', 'vendorId'));
        }
    }

    public function notifications()
    {
        $notifications = Notifications::where('to', Auth::user()->email)
            ->orderBy('created_at', 'desc')->paginate(5);
        // dd($notifications);
        return view('Vendor::notifications', compact('notifications'));
    }

    public function eventNotification(int $id)
    {
        // dd($id);
        $event = RolesEvent::where('id', $id)->first();
        $vendorList = MapRole::where('clientId', $event->client_id)
        ->join('users', 'map_roles.vendorId', '=', 'users.id')
        ->select('name', 'username', 'vendorId')
                    ->first();
        // dd($vendorList);
        $type = "view";
        return view('Vendor::event', compact('event', 'vendorList', 'type'));
        // return view('Vendor::eventNotification', compact('roleEvent', 'vendorList'));
    }

    public function client_invoice_list(Request $request, $search=null)
    {
        if($request->ajax()){
            $data = MapRole::where('vendorId', Auth::user()->id)
                ->join('users', 'map_roles.clientId', '=', 'users.id')
                ->join('clients', 'users.id', 'clients.clientId')
                ->where('users.name', 'LIKE', "%{$search}%")
                ->select(
                    'name',
                    'users.username',
                    'email',
                    'contactNumber',
                    'address',
                    'map_roles.clientId',
                    'map_roles.vendor_aggregation',
                    'clients.contactName'
                )
                ->paginate(4);
            return $data;
        }
        return view('Vendor::icount/invoice/client_list');
    }

    public function view_invoice(Request $request)
    {
        $invoices = Invoice::where('invoices.client_code', $request->client_code)
            ->join('users', 'invoices.client_code', '=', 'users.username')
            ->select('invoices.*', 'users.name as client_name')
            ->paginate(5);
        $vendor_aggregation = $request->vendor_aggregation;
        return view('Vendor::icount/invoice/view_invoice', compact('invoices', 'vendor_aggregation'));
    }

    public function export_invoice(Request $request)
    {
        $from = "";
        $to = "";
        $dates = "";
        if(!isset($request->date_from) && !isset($request->date_to)){
            $time = Carbon::now();
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', $time->toDateString())
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(isset($request->date_from) && !isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', '>=', $request->date_from)
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(!isset($request->date_from) && isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', '<=', $request->date_to)
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(isset($request->date_from) && isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->whereBetween('date', [$request->date_from, $request->date_to])
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        $dates = $dates->select(
                    'users.name',
                    'meal_count_details.client_code',
                    'meal_count_details.meal_type',
                    'meal_count_details.meal_rate',
                    'meal_count_details.meal_count',
                    'meal_count_details.total',
                    'meal_count_details.date'
                )
            ->orderBy('date', 'asc')
            ->get();
        $fetch_invoice = Invoice::where('id', $request->invoice_id)
            ->where('client_code', $request->client_code)
            ->first();
        $empty = ['', '', '', '', '', '', ''];
        $dates->push($empty);
        $invoice_info = ['', '', 'Total Sum', "meal_rate_total" => $fetch_invoice->meal_rate_total, "meal_count_total" => $fetch_invoice->meal_count_total, "total" => $fetch_invoice->total, $fetch_invoice->created_at];
        $dates->push(collect($invoice_info));
        $meal_total_rate = 0;
        $meal_total = 0;
        foreach($dates as $date){
            if(isset($date->meal_rate)){
                $date->meal_rate = (int) round($date->meal_rate - ($date->meal_rate * ($request->vendor_aggregation/100)));
                $date->total = $date->meal_rate * $date->meal_count;
                $meal_total_rate = $meal_total_rate + $date->meal_rate;
                $meal_total = $meal_total + $date->total;
            }elseif(isset($date['meal_rate_total']) && isset($date['total'])){
                $date['meal_rate_total'] = $meal_total_rate;
                $date['total'] = $meal_total;
            }
        }
        // dd($dates);
        $export = new InvoiceExport([$dates->toArray()]);
        // dd($export);
        $filename = $request->client_code . "_invoice" . '.xlsx';
        return Excel::download($export, $filename);
    }
    
    public function place_dining_order(int $clientid=null, int $vendorid=null, int $qrid=null)
    {
//      $clientid = 23;
//      $vendorid = 26;
//      $qrid = 7;
        $items = DB::table('calorie_item_table')
            ->select('item_name', 'item_code')
            ->where('vendor_id', '=', $vendorid) 
            ->get();
      return view('Vendor::dining_place_order', compact('clientid', 'vendorid', 'qrid', 'items'));
    }
    
    public function diningplace(Request $request)
    {
      //dd($request->all());
      try {
        $clientid = $request->clientid;
        $vendorid = $request->vendorid;
        $qrid = $request->qrid;
        
        $empid = DB::table('qr_code_details')
            ->select('assigned_emp_id')
            ->where('client_id', '=', $clientid)
            ->where('qr_id', '=', $qrid)    
            ->first();
        $empid = $empid->assigned_emp_id;
        $qrtype = "type4";
        $mealtype = $request->mealtype;
        
        if(!empty($request->itemname1)){
          $item1Details = DB::table('calorie_item_table')
            ->where('item_code', '=', $request->itemname1)
            ->where('vendor_id', '=', $vendorid)    
            ->first();
          $itemquantity1 = isset($request->itemquantity1) ? $request->itemquantity1 : 1;
          $item1TotalPrice = $itemquantity1 * $item1Details->item_price;
          
          $item1Values = array('client_id' => $clientid,'vendor_id' => $vendorid,'qr_id' => $qrid,'emp_id' => $empid,'qr_type' => $qrtype,'meal_type' => $mealtype,'item_name' => $item1Details->item_name,'item_code' => $item1Details->item_code,'item_quantity' => $itemquantity1,'item_approx_calorie' => $item1Details->item_approx_calorie,'item_price' => $item1Details->item_price,'item_total_price' => $item1TotalPrice,'created_at' => date('Y-m-d H:i:s'));
          DB::table('type4_qr_scan_details')->insert($item1Values);
          
        }
        if(!empty($request->itemname2)){
          $item2Details = DB::table('calorie_item_table')
            ->where('item_code', '=', $request->itemname2)
            ->where('vendor_id', '=', $vendorid)    
            ->first();
          $itemquantity2 = isset($request->itemquantity2) ? $request->itemquantity2 : 1;
          $item2TotalPrice = $itemquantity2 * $item2Details->item_price;
          
          $item2Values = array('client_id' => $clientid,'vendor_id' => $vendorid,'qr_id' => $qrid,'emp_id' => $empid,'qr_type' => $qrtype,'meal_type' => $mealtype,'item_name' => $item2Details->item_name,'item_code' => $item2Details->item_code,'item_quantity' => $itemquantity2,'item_approx_calorie' => $item2Details->item_approx_calorie,'item_price' => $item2Details->item_price,'item_total_price' => $item2TotalPrice,'created_at' => date('Y-m-d H:i:s'));
          DB::table('type4_qr_scan_details')->insert($item2Values);
          
        }
        if(!empty($request->itemname3)){
          $item3Details = DB::table('calorie_item_table')
            ->where('item_code', '=', $request->itemname3)
            ->where('vendor_id', '=', $vendorid)    
            ->first();
          $itemquantity3 = isset($request->itemquantity3) ? $request->itemquantity3 : 1;
          $item3TotalPrice = $itemquantity3 * $item3Details->item_price;
          
          $item3Values = array('client_id' => $clientid,'vendor_id' => $vendorid,'qr_id' => $qrid,'emp_id' => $empid,'qr_type' => $qrtype,'meal_type' => $mealtype,'item_name' => $item3Details->item_name,'item_code' => $item3Details->item_code,'item_quantity' => $itemquantity3,'item_approx_calorie' => $item3Details->item_approx_calorie,'item_price' => $item3Details->item_price,'item_total_price' => $item3TotalPrice,'created_at' => date('Y-m-d H:i:s'));
          DB::table('type4_qr_scan_details')->insert($item3Values);
          
        }
        if(!empty($request->itemname4)){
          $item4Details = DB::table('calorie_item_table')
            ->where('item_code', '=', $request->itemname4)
            ->where('vendor_id', '=', $vendorid)    
            ->first();
          $itemquantity4 = isset($request->itemquantity4) ? $request->itemquantity4 : 1;
          $item4TotalPrice = $itemquantity4 * $item4Details->item_price;
          
          $item4Values = array('client_id' => $clientid,'vendor_id' => $vendorid,'qr_id' => $qrid,'emp_id' => $empid,'qr_type' => $qrtype,'meal_type' => $mealtype,'item_name' => $item4Details->item_name,'item_code' => $item4Details->item_code,'item_quantity' => $request->itemquantity4,'item_approx_calorie' => $item4Details->item_approx_calorie,'item_price' => $item4Details->item_price,'item_total_price' => $item4TotalPrice,'created_at' => date('Y-m-d H:i:s'));
          DB::table('type4_qr_scan_details')->insert($item4Values);
          
        }
        if(!empty($request->itemname5)){
          $item5Details = DB::table('calorie_item_table')
            ->where('item_code', '=', $request->itemname5)
            ->where('vendor_id', '=', $vendorid)    
            ->first();
          $itemquantity5 = isset($request->itemquantity5) ? $request->itemquantity5 : 1;
          $item5TotalPrice = $itemquantity5 * $item5Details->item_price;
          
          $item5Values = array('client_id' => $clientid,'vendor_id' => $vendorid,'qr_id' => $qrid,'emp_id' => $empid,'qr_type' => $qrtype,'meal_type' => $mealtype,'item_name' => $item5Details->item_name,'item_code' => $item5Details->item_code,'item_quantity' => $itemquantity5,'item_approx_calorie' => $item5Details->item_approx_calorie,'item_price' => $item5Details->item_price,'item_total_price' => $item5TotalPrice,'created_at' => date('Y-m-d H:i:s'));
          DB::table('type4_qr_scan_details')->insert($item5Values);
          
        }
        if(!empty($request->itemname6)){
          $item6Details = DB::table('calorie_item_table')
            ->where('item_code', '=', $request->itemname6)
            ->where('vendor_id', '=', $vendorid)    
            ->first();
          $itemquantity6 = isset($request->itemquantity6) ? $request->itemquantity6 : 1;
          $item6TotalPrice = $itemquantity6 * $item6Details->item_price;
          
          $item6Values = array('client_id' => $clientid,'vendor_id' => $vendorid,'qr_id' => $qrid,'emp_id' => $empid,'qr_type' => $qrtype,'meal_type' => $mealtype,'item_name' => $item6Details->item_name,'item_code' => $item6Details->item_code,'item_quantity' => $itemquantity6,'item_approx_calorie' => $item6Details->item_approx_calorie,'item_price' => $item6Details->item_price,'item_total_price' => $item6TotalPrice,'created_at' => date('Y-m-d H:i:s'));
          DB::table('type4_qr_scan_details')->insert($item6Values);
          
        }
        
        return redirect('ICount/I-count')->with(["message" => "Order Placed Successfully", "alert-type" => "success"]);
        
        } catch (Exception $e) {
            \Log::info($e);
            report($e);
            return false;
        }
    }
    
    public function alldiningsalereport(Request $request){
      $allClients = MapRole::where('vendorId', Auth::user()->id)
                ->join('users', 'map_roles.clientId', '=', 'users.id')
                ->join('clients', 'users.id', 'clients.clientId')
                ->select(
                    'name',
                    'users.username',
                    'email',
                    'contactNumber',
                    'address',
                    'map_roles.clientId',
                    'clients.contactName'
                )
                ->get();
      return view('Vendor::icount/icount-dining-sale-report/alldiningsalereport', compact('allClients'));
    }
    
    public function generate_diningsale_report(Request $request)
    {
        // dd($request->all(), $request->isMethod('get'), $request->isMethod('post'));
        if($request->isMethod('get')){
          //dd("get");
            $client = (object) $request->all();
            return view('Vendor::icount/icount-dining-sale-report/generate_dining_report', compact('client'));
        }elseif($request->isMethod('post')){
          $clientDataPP = Client::select('clientname', 'username')->where('clientId', $request->client_id)->first();
        // $report_data = Type4QrScanDetail::where('client_id', $request->client_id)
        //         ->whereBetween('created_at', [$request->date_from." 00:00:00", $request->date_to." 23:59:59"])
        //         ->get();
        $report_data = Type4QrScanDetail::where('client_id', $request->client_id)
            ->whereBetween('created_at', [$request->date_from." 00:00:00", $request->date_to." 23:59:59"])
            ->select('id', 'client_id', 'vendor_id', 'qr_type', 'item_quantity',
                'emp_id', 'item_total_price',
                DB::raw("DATE(created_at) as date,sum(CASE
                            WHEN meal_type = 'breakfast' THEN item_total_price
                            ELSE 0
                            END) as sum_price_breakfast, 
                            sum(CASE
                            WHEN meal_type = 'lunch' THEN item_total_price
                            ELSE 0
                            END) as sum_price_lunch,
                            sum(CASE
                            WHEN meal_type = 'dinner' THEN item_total_price
                            ELSE 0
                            END) as sum_price_dinner,
                            sum(CASE
                            WHEN meal_type = 'others' THEN item_total_price
                            ELSE 0
                            END) as sum_price_others,
                    GROUP_CONCAT(DISTINCT 
                        @item_name := (CASE
                            WHEN meal_type = 'breakfast' THEN concat(item_name,' (',item_quantity,' Quantity)(',item_price,' Rs)')
                            ELSE ''
                            END
                        ) SEPARATOR ', ') as breakfast,
                    GROUP_CONCAT(DISTINCT 
                        @item_name := (CASE
                            WHEN meal_type = 'lunch' THEN concat(item_name,' (',item_quantity,' Quantity)(',item_price,' Rs)')
                            ELSE ''
                            END
                        ) SEPARATOR ', ') as lunch,
                    GROUP_CONCAT(DISTINCT 
                        @item_name := (CASE
                            WHEN meal_type = 'dinner' THEN concat(item_name,' (',item_quantity,' Quantity)(',item_price,' Rs)')
                            ELSE ''
                            END
                        ) SEPARATOR ', ') as dinner,
                    GROUP_CONCAT(DISTINCT 
                        @item_name := (CASE
                            WHEN meal_type = 'others' THEN concat(item_name,' (',item_quantity,' Quantity)(',item_price,' Rs)')
                            ELSE ''
                            END
                        ) SEPARATOR ', ') as others"))
            ->groupBY('emp_id','date')->orderBy('date')->get();
        foreach($report_data as $key => $data){
          $vendorid = isset($data->vendor_id) ? $data->vendor_id : '';
        }
        if(!empty($vendorid)) {
          $vendorDataPP = User::select('name', 'username', 'address')->where('id', $vendorid)->first();
        }else{
            $vendorDataPP = '';
        }
        $date_from = $request->date_from;
        $date_to = $request->date_to;
        // dd($report_data);
        $client = Client::find($request->client_id);

        return view('Vendor::icount/icount-dining-sale-report/get_dining_sale_report', compact('client', 'report_data', 'clientDataPP', 'vendorDataPP', 'date_from', 'date_to'));
            
        }
    }
    
    public function view_marshal(int $marshalId=null)
    {
        if($marshalId == null)
        {
            $allMarshals = MapRole::where('vendorId', Auth::user()->id)
                ->join('users', 'map_roles.marshalId', '=', 'users.id')
                ->join('marshals', 'users.id', 'marshals.marshalId')
                ->select(
                    'name',
                    'users.username',
                    'email',
                    'contactNumber',
                    'address',
                    'map_roles.marshalId',
                    'marshals.marshalname'
                )
                // ->groupBy('username')
                ->get();
            //dd($allMarshals);
//            echo "<pre>";
//            print_r($allMarshals);
//            echo "</pre>";
            return view('Vendor::allmarshal', compact('allMarshals'));
        }
    }

    public function viewAIFeedClient(Request $request){
        $user = json_decode(json_encode(auth()->user()),true);
        $clientIds = DB::table('map_roles')->where('vendorId',$user['id'])
                    ->select('clientId')->get();
        $vendor = DB::table('vendors')
                    ->where('vendorId',$user['id'])
                    ->select('cameraNumber')
                    ->first();
        $i=0;
        $clientDetails=array();
        while($i<count($clientIds)){
            $userclient=(array)$clientIds[$i];
            $id= $userclient['clientId'];
            $client = DB::table('clients')
                            ->where('clientId',$id)
                            ->select('id','clientId','clientName','contactName')
                            ->get();
            $clientDetails[$i] = $client[0];
            $i++;
        }
        return view('Vendor::aiClientList',compact('clientDetails','vendor'));
    }

    public function viewAIClientCameraList(int $id){
        $user = json_decode(json_encode(auth()->user()),true);
        $cameraDetails = DB::table('vendor_cameras')
                        ->where('vendorId',$user['id'])
                        ->where('clientId',$id)
                        ->select('id','cameraId','clientId','cameraLocation')
                        ->get();
                        
        return view('Vendor::aiClientCameraList',compact('cameraDetails'));
    }

    public function viewClientAIFeeds(string $id){
        $feeds = AIFeed::where('cameraId',$id)
                    ->orderBy('id','DESC')
                    ->get();
        return view('Vendor::aifeedsclientview',compact('feeds'));
    }

    public function aiFeedsAlert(Request $request){
        // libxml_use_internal_errors(true);
        $data = $request->all();
        if($data['errorMessage']=="" && $data['statusCode'] == 200){
            // to check the number of images received
            $count = count($data['body']);
            $alert = $data['body'];
            $i=0;
            // for folder creation
            $folder = Carbon::now()->format('Y/M/d');
            while($i<$count){
                $data = $alert[$i];
                $data = json_decode(json_encode((array)simplexml_load_string($data)),true);
                $cameraId = $data['CameraInfo']['CameraId'];
                $input['cameraId'] = str_replace(' ', '', $cameraId);
                // For vendor Id and Client ID
                $cameraDetails = DB::table('vendor_cameras')
                                    ->where('cameraId', $input['cameraId'])
                                    ->select('clientId','vendorId','cameraLocation')
                                    ->get();
                $cameraDetail = (array)$cameraDetails[0];
                $clientId = $cameraDetail['clientId'];
                $vendorId = $cameraDetail['vendorId'];
                $cameraLocation = $cameraDetail['cameraLocation'];
                //To check weather folder exist or not
                $checkFolder = storage_path('app/public/'.$clientId.'/'.$vendorId.'/'. $input['cameraId'].'/'.$folder);
                $folderStatus = File::isDirectory($checkFolder);
                if(! $folderStatus){
                    File::makeDirectory($checkFolder, 0755, true, true);
                }
                $input['clientId'] = $clientId;
                $input['vendorId'] = $vendorId;
                $input['cameraLocation'] = $cameraLocation;
                $input['ai_Feed_Id'] = str_replace(' ', '', $data['AlertInfo']['Id']);
                $ai_feedType= $data['AlertInfo']['Type'];
                $input['ai_Feed_Type']= str_replace(' ', '', $ai_feedType);
                $input['ai_Feed_Time'] = str_replace(' ', '', $data['AlertInfo']['Time']);
                $input['ai_Feed_ROI'] = str_replace(' ', '',  $data['AlertInfo']['Attr']['roi']);
                $input['ai_Feed_Color'] = str_replace(' ', '', $data['AlertInfo']['Attr']['color']);
                $image_parts = explode(";base64,", $data['AlertInfo']['ImgData']);
                $image_type_aux = explode("image/", $image_parts[0]);
                $image_type = $image_type_aux[0];
                $image_base64 = base64_decode($image_parts[0]);
                Storage::put('public/'.$clientId.'/'.$vendorId.'/'. $input['cameraId'].'/'.$folder.'/'.$input['ai_Feed_Type'].'.png', $image_base64);
                
                $input['imageLink'] = asset('public/storage/'.$clientId.'/'.$vendorId.'/'. $input['cameraId'].'/'.$folder.'/'.$input['ai_Feed_Type'].'.png');
                $input['videoId'] = str_replace(' ', '', $data['AlertInfo']['VidData']);
                
                $ch = curl_init("https://phantom.vehant.in:60061/v1/api/foodkraft/video/". $input['videoId']);

                curl_setopt_array($ch, array(
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_TIMEOUT => 30000,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        // Set Here Your Requesred Headers
                        'X-Api-Key: foodkraft.10042021.57obij6er7.8fc0d5odli.9e27epypgl', 
                        'Content-Type: application/json',
                    ),
                ));
                $response = curl_exec($ch);
                $err = curl_error($ch);
                curl_close($ch);

                Storage::put('public/'.$clientId.'/'.$vendorId.'/'. $input['cameraId'].'/'.$folder.'/'. $input['videoId'], $response);              
                $input['videoLink'] = asset('public/storage/'.$clientId.'/'.$vendorId.'/'. $input['cameraId'].'/'.$folder.'/'. $input['videoId']);
                AIFeed::create(
                    $input
                );
                $i++;
            }
            if($count>0){
                $this->sendAIMail();
            }   
            return response()->json(["successCode"=>200]);
        }
        else{
            return response()->json(["errorCode"=>400]);;
        }

    }

    public function sendAIMail(){
        $clientEmailId = 'anoop@uginfosystems.com';
        $vendorEmailId = 'pradeep@uginfosystems.com';
        $adminEmailId = 'pradeep@finchat.tech';
        $data['type'] = 'aiFeedsEmail';
        $data['subject'] = 'AI Feeds Alert Mail';
        $data['mailId'] = $clientEmailId;   
        $data['note'] = 'You have received this notification mail informing that one or more anomalies have been detected at the kitchen.
Kindly log in to your Foodskraft portal to view the same in detail and take necessary step.';

        $res = Mail::to($clientEmailId)
                    ->cc($vendorEmailId)
                    ->cc($adminEmailId)
                    ->send(new SendMail($data));
    }
    
    
    
   public function add_menu(){
                   $allClients = MapRole::where('vendorId', Auth::user()->id)
                ->join('users', 'map_roles.clientId', '=', 'users.id')
                ->join('clients', 'users.id', 'clients.clientId')
                ->select(
                    'name',
                    'users.username',
                    'email',
                    'contactNumber',
                    'address',
                    'map_roles.clientId',
                    'clients.contactName'
                )
                ->groupBy('username')
                ->get();
            // dd($allClients);
            return view('Vendor::add_menu', compact('allClients'));
    
    }
    
    public function upload_menu(Request $request){
    $file = $request->file('menu_file'); 
   
   try {
            Excel::load($request->file('menu_file'), function ($reader) {

                foreach ($reader->toArray() as $row) {
                    
                }
            });
           echo 'success';
        } catch (\Exception $e) {
          echo 'error';
        }
        
    
    
     
    }
}