@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Menus List</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                        <table class="table table-hover">
                            <thead class="text-dark">
                                <tr>
                                    <th class="text-left" scope="col">S.No.</th>
                                    <th class="text-left" scope="col">Client (Name - Code)</th>
                                    <th class="text-left" scope="col">Vendor (Name - Code)</th>
                                    <th class="text-left" scope="col">Valid From</th>
                                    <th class="text-left" scope="col">Valid To</th>
                                    <th scope="col" class="d-flex justify-content-center">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($menu_list as $menus)
                                    <tr>
                                        <th class="text-left" scope="row">{{ $loop->iteration }}</th>
                                        <td class="text-left">{{ $menus->client_name . ' - ' . $menus->client_code }}</td>
                                        <td class="text-left">{{ $menus->vendor_name . ' - ' . $menus->vendor_code }}</td>
                                        <td class="text-left">{{ Carbon\Carbon::parse($menus->from_time)->format('d-m-Y h:m') }}</td>
                                        <td class="text-left">{{ Carbon\Carbon::parse($menus->to_time)->format('d-m-Y h:m') }}</td>
                                        <td class="d-flex justify-content-center">
                                            <?php
                                                $id = isset($client->client_id) ? $client->client_id : '';
                                            ?>
                                            <!-- <a href="{{ url('sitemarshal/view/role').'/'.$id }}" class="btn btn-info font-weight-bold mx-2">View</a> -->
                                            <form action="{{ url('sitemarshal/menus') }}" method="POST">
                                                @csrf
                                                <input type="hidden" value="{{ $menus->meal_id }}" name="meal_id" />
                                                <input type="hidden" value="{{ $menus->client_id }}" name="client_id" />
                                                <input type="hidden" value="{{ $menus->vendor_id }}" name="vendor_id" />
                                                <input type="submit" class="btn btn-info font-weight-bold mx-2" value="View" />
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" align="center">Not Found any</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection