@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Feedback</h3>
                </div>
                <div class="card-body">
                    @if(isset($feedbacks))
                        <?php
                            // dd($feedbacks->toArray());
                        ?>
                        <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-hover">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-center" scope="col">S.No.</th> 
                                        <th class="text-center" scope="col">Vendor Name</th> 
                                        <th class="text-center" scope="col">Mobile Number</th>
                                        <th class="text-center" scope="col">Status</th>
                                        <th class="text-center" scope="col">Feed</th>
                                        <th class="text-center" scope="col">Menu</th>
                                        <!-- <th scope="col" class="d-flex justify-content-center">Action</th> -->
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($feedbacks as $feedback)
                                        <tr>
                                            <th class="text-center" scope="row">{{ $loop->iteration }}</th>
                                            <td class="text-center">{{ $feedback->vendor_name }}</td>
                                            <td class="text-center">{{ $feedback->vendor_number }}</td>
                                            <td class="text-center">
                                                @if(isset($feedback->reply))
                                                    <span class="badge badge-danger">Disapproved</span>
                                                @else
                                                    <span class="badge badge-success">Approved</span>
                                                @endif
                                            </td>
                                            <td class="text-center">{{ isset($feedback->reply) ? $feedback->reply : 'N/A' }}</td>
                                            <td class="text-center">
                                                <a class="btn btn-info" href="{{ url('sitemarshal/feedbacks') . '/' . $feedback->vendorId . '/' . $feedback->clientId }}">
                                                    <i class="fa fa-eye" aria-hidden="true"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" align="center">Not Found any</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @else
                        <?php
                            // dd($menuDetails->toArray());
                        ?>
                        <div>
                            @if(!isset($menuDetails))
                                <div class="row">
                                    <div class="col form-group d-flex justify-content-center mb-2">
                                        <span class="badge badge-warning">No Meal Menu is Provided!</span>
                                    </div>
                                </div>
                            @endif
                            <!-- Client Info -->
                            <div class="row">
                                @php
                                    $dt_min = new DateTime('-10 minutes');
                                    $dt_min = $dt_min->format('Y-m-d\TH:i');
                                    if(isset($menuDetails)){
                                        $datetime_from = new DateTime($menuDetails->from_time);
                                        $datetime_from = $datetime_from->format('Y-m-d\TH:i');
                                        $datetime_to = new DateTime($menuDetails->to_time);
                                        $datetime_to = $datetime_to->format('Y-m-d\TH:i');
                                    }
                                @endphp
                                <div class="form-group col">
                                    <label for="vendorId">Vendor Name</label>
                                    <input class="form-control" type="text" value="{{ $vendorDetails->vendor_name.' - '.$vendorDetails->vendor_username }}" id="vendorId" readonly />
                                </div>
                                <div class="form-group col">
                                    <label for="clientId">Client Name</label>
                                    <input class="form-control" type="text" value="{{ $clientDetails->client_name.' - '.$clientDetails->client_username }}" id="clientId" readonly />
                                </div>
                                <div class="form-group col">
                                    <label for="fromtime">Menu From</label>
                                    <input class="form-control" name="from_time" min="{{ $dt_min }}" value="{{ isset($menuDetails) ? $datetime_from : '' }}" type="datetime-local" placeholder="Meal from.." id="fromtime" readonly />
                                </div>
                                <div class="form-group col">
                                    <label for="totime">Menu To</label>
                                    <input class="form-control" name="to_time" value="{{ isset($menuDetails) ? $datetime_to : '' }}" type="datetime-local" placeholder="Meal to.." id="totime" readonly />
                                </div>
                            </div>
                            <!-- Morning -->
                            <div class="row">
                                <div class="form-group col">
                                    <label for="morning_meal">Morning Meal</label>
                                    <input type="text" name="morning_meal" class="form-control" value="{{ isset($menuDetails) ? $menuDetails->morning_meal : old('morning_meal') }}" id="morning_meal" readonly />
                                </div>
                                <div class="form-group col">
                                    <label for="morning_description">Morning Description</label>
                                    <textarea type="text" name="morning_description" class="form-control" id="morning_description" readonly>{{ isset($menuDetails) ? $menuDetails->morning_description : old('morning_description') }}</textarea>
                                </div>
                            </div>
                            <!-- Afternoon -->
                            <div class="row">
                                <div class="form-group col">
                                    <label for="afternoon_meal">Afternoon Meal</label>
                                    <input type="text" name="afternoon_meal" class="form-control" value="{{ isset($menuDetails) ? $menuDetails->afternoon_meal : old('afternoon_meal') }}" id="afternoon_meal" readonly />
                                </div>
                                <div class="form-group col">
                                    <label for="afternoon_description">Afternoon Description</label>
                                    <textarea type="text" name="afternoon_description" class="form-control" id="afternoon_description" readonly>{{ isset($menuDetails) ? $menuDetails->afternoon_description : old('afternoon_description') }}</textarea>
                                </div>
                            </div>
                            <!-- Evening -->
                            <div class="row">
                                <div class="form-group col">
                                    <label for="snacks">Evening Snacks</label>
                                    <input type="text" name="evening_snacks" class="form-control" value="{{ isset($menuDetails) ? $menuDetails->evening_snacks : old('evening_snacks') }}" id="snacks" readonly />
                                </div>
                                <div class="form-group col">
                                    <label for="snacks_description">Snacks Description</label>
                                    <textarea type="text" name="snacks_description" class="form-control" id="snacks_description" readonly>{{ isset($menuDetails) ? $menuDetails->snacks_description : old('snacks_description') }}</textarea>
                                </div>
                            </div>
                            <!-- Dinner -->
                            <div class="row">
                                <div class="form-group col">
                                    <label for="dinner_meal">Dinner Meal</label>
                                    <input type="text" name="dinner_meal" class="form-control" value="{{ isset($menuDetails) ? $menuDetails->dinner_meal : old('dinner_meal') }}" id="dinner_meal" readonly />
                                </div>
                                <div class="form-group col">
                                    <label for="dinner_description">Dinner Description</label>
                                    <textarea type="text" name="dinner_description" class="form-control" id="dinner_description" readonly>{{ isset($menuDetails) ? $menuDetails->dinner_description : old('dinner_description') }}</textarea>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection