<?php

namespace App\Modules\Customer\Controllers;
use App\Http\Controllers\Controller;
use App\Customer;
use App\User;
use App\Client;
use App\Vendor;
use App\MapRole;
use App\MealMenu;
use App\CompPaidOrder;
use App\Payment;
use App\SelfPaidOrderItem;
use App\Cart;
use App\Feedbacks;
use Auth;
use DB;


class CustomerController extends Controller
{

    protected function index()
    {
       echo 'Invalid URL .....';
    }

  

    public function mobile_verify(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('name','mobile_number','company_id','login_code');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
         date_default_timezone_set("Asia/Kolkata");
        $mobile_number=$datas['mobile_number'];
        $client_code=$datas['company_id'];
        $name=$datas['name'];
        $login_code=$datas['login_code'];
        $otp=rand(111111,999999);
        
        $customer= Customer::where('mobile_number',$mobile_number)
                    ->where('login_code', 'like', '%' . $login_code . '%')
                    ->select('id', 'name', 'login_code', 'mobile_number', 'client_code', 'otp','token')
                    ->first();
                    
         
         if(!isset($customer->login_code)){
           if(!empty($client_code)){
                $clients = Client::where('username',$client_code)->first();
                $client_id=$clients->clientId;
              if(!empty($clients->clientId)) { 
                $Customers = new Customer;
                $Customers->name = $name;
                $Customers->login_code = $login_code;
                $Customers->mobile_number = $mobile_number;
				$Customers->client_code = $client_code;
				$Customers->clientId = $client_id;
				$Customers->otp = $otp;
				$Customers->created_at = date('Y-m-d H:i:s');
				$Customers->save();
                return response()->json(['status'=>1,'otp'=>$otp,'message'=>'success']);
              } else {
                  return response()->json(['status'=>0,'message'=>'Invalid Company ID']);
              }
                
                
            }
            else{
                return response()->json(['status'=>0,'message'=>'user not exits please provide companey id for register first time']);
            }  
         }
         else {
             
        if($login_code==$customer->login_code){
          $customer->otp = $otp;
          $customer->message = 'success';
          $customer->status = 1;
          DB::update('update customers set otp = ?,token = ? where mobile_number = ?',[$otp,'',$mobile_number]);
          return response()->json($customer);
        } 
        
        if($mobile_number==$customer->mobile_number){
            $customer->otp = $otp;
             DB::update('update customers set otp = ?,token = ? where mobile_number = ?',[$otp,'',$mobile_number]);
             return response()->json(['status'=>1,'otp'=>$otp,'message'=>'success']);
            
        } 
            
         }   
         
    }

    public function otp_verify(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('mobile_number','otp');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $mobile_number=$datas['mobile_number'];
        $otp=$datas['otp'];
        $token=rand(111111111,999999999);
        
        $customer = Customer::where('mobile_number',$mobile_number)
        ->join('users', 'customers.client_code', '=', 'users.username')
        ->select('customers.id', 'customers.name', 'customers.login_code', 'customers.mobile_number', 'customers.client_code','customers.clientId', 'customers.otp','customers.token','users.name as client_name')
        ->first();
        
       
        
        if(!empty($customer->mobile_number)){
            if($customer->otp==$otp){
             $customer->status = 1;   
             $customer->token = $token;   
             $customer->message = 'success';   
             DB::update('update customers set  otp = ?, token = ? where mobile_number = ?',['',$token,$mobile_number]);
             return response()->json($customer);
            }else{
          return response()->json(['status'=>0,'message'=>'Invalid OTP']); 
        }
        }else{
          return response()->json(['status'=>0,'message'=>'Invalid Mobile Number']); 
        }

    }
    
    
    public function tuckShopVendorList(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        if(!isset($datas)){   return  response()->json(['status'=>0,'message'=>'token key is required']);  }
        $should_be=array('token');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
          $company_id=$customer->client_code;
         
          $clients = Client::where('username',$company_id)->first();
          $company_id=$clients->clientId;
         
         
                
           if(!empty($company_id))  {
           
            $search1='livemeals';
            $search2='mrp';
            $search3='beverages';
            $search4='tuckShop';
            
            $query= "select `users`.`name`, `users`.`username`, `users`.`email`, `users`.`contactNumber`, `address`, `vendors`.`vendorScope`, `vendors`.`auditRating`, `map_roles`.`vendorId` from `map_roles` left join `users` on `map_roles`.`vendorId` = `users`.`id` left join `vendors` on `map_roles`.`vendorId` = `vendors`.`vendorId` where `map_roles`.`v_type` = 0 AND `map_roles`.`clientId` = $company_id AND (`vendors`.`vendorScope` LIKE '%$search1%' or `vendors`.`vendorScope` LIKE '%$search2%' or `vendors`.`vendorScope` LIKE '%$search3%' or `vendors`.`vendorScope` LIKE '%$search4%' ) group by `users`.`username`";
            $vendors= DB::select($query);
         
           if(isset($vendors[0])){
            return response()->json(['status'=>1,'message'=>'success','data'=>$vendors]);  
           } else {
             return response()->json(['status'=>0,'message'=>'No results found']);  
           }
           } else {
             return response()->json(['status'=>0,'message'=>'Invalid Company ID']);  
           }
                
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    }
    
    public function cashCarryVendorList(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        if(!isset($datas)){   return  response()->json(['status'=>0,'message'=>'token key is required']);  }
        $should_be=array('token');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
          $company_id=$customer->client_code;
         
          $clients = Client::where('username',$company_id)->first();
          $company_id=$clients->clientId;
          
         
                
           if(!empty($company_id))  {
           
            $search1='mainMeal';
          
           $query= "select `users`.`name`, `users`.`username`, `users`.`email`, `users`.`contactNumber`, `address`, `vendors`.`vendorScope`, `vendors`.`auditRating`, `map_roles`.`vendorId` from `map_roles` left join `users` on `map_roles`.`vendorId` = `users`.`id` left join `vendors` on `map_roles`.`vendorId` = `vendors`.`vendorId` where `map_roles`.`v_type` = 0 AND `map_roles`.`clientId` = $company_id AND (`vendors`.`vendorScope` LIKE '%$search1%') group by `users`.`username`";
           $vendors= DB::select($query);
          
           if(isset($vendors[0])){
            return response()->json(['status'=>1,'message'=>'success','data'=>$vendors]);  
           } else {
             return response()->json(['status'=>0,'message'=>'No results found']);  
           }
          
           
           } else {
             return response()->json(['status'=>0,'message'=>'Invalid Company ID']);  
           }
                
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    }
    
    
     public function getVendorList(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        if(!isset($datas)){   return  response()->json(['status'=>0,'message'=>'token key is required']);  }
        $should_be=array('token');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
          $company_id=$customer->client_code;
         
          $clients = Client::where('username',$company_id)->first();
          $company_id=$clients->clientId;
          
           if(!empty($company_id))  {
           
            $search1='mainMeal';
          
           $query= "select `users`.`name`, `users`.`username`, `users`.`email`, `users`.`contactNumber`, `address`, `vendors`.`vendorScope`, `vendors`.`auditRating`, `map_roles`.`vendorId`, `map_roles`.`v_type`, 
           (select sum(`rating`) from feedbacks where `feedbacks`.`vendor_id` = `map_roles`.`vendorId`) as rating_sum, (select count(`rating`) from feedbacks where `feedbacks`.`vendor_id` = `map_roles`.`vendorId`) as rating_count
           from `map_roles` left join `users` on `map_roles`.`vendorId` = `users`.`id` left join `vendors` on `map_roles`.`vendorId` = `vendors`.`vendorId` where  `map_roles`.`clientId` = $company_id  group by `users`.`username`";
           $vendors= DB::select($query);
          
           if(isset($vendors[0])){
            return response()->json(['status'=>1,'message'=>'success','data'=>$vendors]);  
           } else {
             return response()->json(['status'=>0,'message'=>'No results found']);  
           }
          
           
           } else {
             return response()->json(['status'=>0,'message'=>'Invalid Company ID']);  
           }
                
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    }
    
    
    public function companyPaidVendorList(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        if(!isset($datas)){   return  response()->json(['status'=>0,'message'=>'token key is required']);  }
        $should_be=array('token');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
          $company_id=$customer->client_code;
         
          $clients = Client::where('username',$company_id)->first();
          $company_id=$clients->clientId;
          
         
                
           if(!empty($company_id))  {
           
            $search1='mainMeal';
          
            $vendors= MapRole::where('clientId', $company_id)
                     ->where('map_roles.v_type', 1)
                    ->join('users', 'map_roles.vendorId', '=', 'users.id')
                    ->join('vendors', 'map_roles.vendorId', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.email', 'users.contactNumber', 'address', 'vendors.vendorScope', 'vendors.auditRating', 'map_roles.vendorId')
                    ->groupBy('username')
                    ->get();
                    
       
          if(isset($vendors[0])){
            return response()->json(['status'=>1,'message'=>'success','data'=>$vendors]);  
           } else {
             return response()->json(['status'=>0,'message'=>'No results found']);  
           }
                
            } else {
               return response()->json(['status'=>0,'message'=>'No results found']); 
            }
        
        }
        else {
               return response()->json(['status'=>0,'message'=>'Invalid token . Please login for access']);  
            }
        
    }
    
    public function item_list(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
         $should_be=array('token','vendor_id');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        $vendor_id=$datas['vendor_id'];
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
         
            
            $items = DB::table('calorie_item_table')
            ->select('id', 'item_name', 'item_code','item_quantity','item_price')
            ->where('vendor_id', '=', $vendor_id) 
            ->where('is_available', '=', 1) 
            ->get();
        
                
           if(isset($items[0]->item_name))  {
            return response()->json(['status'=>1,'message'=>'success','data'=>$items]); 
           } else {
             return response()->json(['status'=>0,'message'=>'No any items on this vendor id']);  
           } 
                
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    }
    
    
     public function menu(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
         $should_be=array('token','vendor_id');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        $vendor_id=$datas['vendor_id'];
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
            $menu = DB::table('app_menu')
            ->select( 'vendorId', 'clientId', 'menu_title', 'menu_time', 'menu_description', 'date', 'status')
            ->where('vendorId', '=', $vendor_id) 
            ->where('clientId', '=', $customer->clientId) 
            ->get();
          
            
             
           if(isset($menu[0]->vendorId))  {
             return response()->json(['status'=>1,'message'=>'success','data'=>$menu]);  
           } else {
             return response()->json(['status'=>0,'message'=>'No any menu on this vendor id']);  
           } 
                
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    }
    
    public function company_menu(){
        
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
         $should_be=array('token');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        
        $customer = Customer::where('token',$token)->first();
        
        if(!empty($customer->mobile_number)){
           
            $menu = DB::table('app_menus')
            ->join('vendors', 'app_menus.vendorId', '=', 'vendors.vendorId')
            ->join('users', 'users.username', '=', 'vendors.username')
            ->select( 'app_menus.vendorId', 'app_menus.clientId', 'app_menus.menu_title', 'app_menus.menu_time','vendors.vendorname','users.address','app_menus.menu_description', 'app_menus.date', 'app_menus.status')
            ->where('clientId', '=', $customer->clientId) 
            ->get();
          
            
             
           if(isset($menu[0]->vendorId))  {
             return response()->json(['status'=>1,'message'=>'success','data'=>$menu]);  
           } else {
             return response()->json(['status'=>0,'message'=>'No any menu on this vendor id']);  
           } 
                
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    
    }
    
    
     public function vendor_company_menu(){
        
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
         $should_be=array('token','vendor_id');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        $vendor_id=$datas['vendor_id'];
        
        $customer = Customer::where('token',$token)->first();
        
        if(!empty($customer->mobile_number)){
           
            $menu = DB::table('app_menus')
            ->join('vendors', 'app_menus.vendorId', '=', 'vendors.vendorId')
            ->join('users', 'users.username', '=', 'vendors.username')
            ->select( 'app_menus.id', 'app_menus.vendorId', 'app_menus.clientId', 'app_menus.menu_title', 'app_menus.menu_time','vendors.vendorname','users.address','app_menus.menu_description', 'app_menus.date', 'app_menus.status')
            ->where('app_menus.clientId', '=', $customer->clientId) 
            ->where('app_menus.vendorId', '=', $vendor_id)
            ->get();
          
             
           if(isset($menu[0]->vendorId))  {
             return response()->json(['status'=>1,'message'=>'success','data'=>$menu]);  
           } else {
             return response()->json(['status'=>0,'message'=>'No any menu on this vendor id']);  
           } 
                
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    
    }
    
    
    
    public function add_to_cart(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
         $should_be=array('token','vendorId','clientId','qty','item_id');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        }  
        
        
        date_default_timezone_set("Asia/Kolkata");        
        $token=$datas['token'];
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
          
            $Cart = Cart::where('customer_id',$customer->id)
            ->where('clientId',$datas['clientId'])
            ->where('vendorId',$datas['vendorId'])
            ->where('item_id',$datas['item_id'])
            ->first();
            
            if(!empty($Cart->qty)){
                $qty=$Cart->qty+$datas['qty'];
                $cart_id=$Cart->id;
                DB::update('update carts set qty = ? where id = ?',[$qty,$cart_id]);
            } else {
              
                $Cart = new Cart;
                $Cart->clientId = $datas['clientId'];
                $Cart->vendorId = $datas['vendorId'];
                $Cart->customer_id = $customer->id;
				$Cart->item_id = $datas['item_id'];
				$Cart->qty = $datas['qty'];
				$Cart->created_at = date('Y-m-d H:i:s');
				$Cart->save(); 
			}	
               
           return response()->json(['status'=>1,'message'=>'success']);  
         
                
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
        
    }
    
    public function cart_list(){
        
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");          
        $token=$datas['token'];
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
            
         $carts= Cart::where('customer_id', $customer->id)
        ->join('calorie_item_table', 'calorie_item_table.id', '=', 'carts.item_id')
        ->join('vendors', 'vendors.vendorId', '=', 'carts.vendorId')
        ->select('carts.id','carts.item_id', 'carts.qty', 'calorie_item_table.item_name', 'calorie_item_table.item_price', 'calorie_item_table.is_available', 'carts.vendorId', 'vendors.vendorname')
        ->get();
     
        return response()->json(['status'=>1,'message'=>'success','data'=>$carts]);
        
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    }
    
    public function update_cart(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
         $should_be=array('token','cart_id','qty');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        }  
        
        
        date_default_timezone_set("Asia/Kolkata");        
        $token=$datas['token'];
        $cart_id=$datas['cart_id'];
        $qty=$datas['qty'];
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
          
            DB::update('update carts set qty = ? where id = ?',[$qty,$cart_id]);
            return response()->json(['status'=>1,'message'=>'success']);  
                  
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
        
    }
    
    public function delete_cart(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
         $should_be=array('token','cart_id');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        }  
        
        
        date_default_timezone_set("Asia/Kolkata");        
        $token=$datas['token'];
        $cart_id=$datas['cart_id'];
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
          
            DB::table('carts')->where('id', $cart_id)->delete();
            return response()->json(['status'=>1,'message'=>'success']);  
                  
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
        
    }
    
    public function count_cart(){
        
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");          
        $token=$datas['token'];
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
           $count = DB::table('carts')
                ->where('customer_id', '=', $customer->id)
                ->sum('carts.qty');
        
        return response()->json(['status'=>1,'message'=>'success','count'=>(int)$count]);
        
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    }
    
    public function comp_paid_orders_add(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token','vendorId','menu_id');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");          
        $token=$datas['token'];
        $vendor_id=$datas['vendorId'];
        $menu_id=$datas['menu_id'];
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
            
         $res = CompPaidOrder::where('menu_id',$menu_id)
         ->where('customer_id',$customer->id)
         ->first();
        if(!empty($res->order_id)){
          return response()->json(['status'=>0,'message'=>'already ordered!']);   
        } else{
            
            $orderId='1'.rand(111111,999999);
            $CompPaidOrder = new CompPaidOrder;
            $CompPaidOrder->order_id = $orderId;
            $CompPaidOrder->menu_id = $menu_id;
            $CompPaidOrder->customer_id = $customer->id;
			$CompPaidOrder->vendor_id = $vendor_id;
			$CompPaidOrder->status = 1;
	    	$CompPaidOrder->created_at = date('Y-m-d H:i:s');
			$CompPaidOrder->save();
            return response()->json(['status'=>1,'message'=>'Thank you! Your order was successfully submitted!', 'order_id'=>$orderId ]); 
        }
          
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    }
    
    public function comp_paid_order_list(){
        
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");          
        $token=$datas['token'];
      
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
            
        $orders= CompPaidOrder::where('customer_id', $customer->id)
        ->join('app_menus', 'app_menus.id', '=', 'comp_paid_orders.menu_id')
        ->join('vendors', 'vendors.vendorId', '=', 'comp_paid_orders.vendor_id')
        ->select('comp_paid_orders.id','comp_paid_orders.order_id','comp_paid_orders.menu_id','comp_paid_orders.customer_id','comp_paid_orders.vendor_id','comp_paid_orders.status','comp_paid_orders.created_at', 'app_menus.menu_title', 'app_menus.menu_time', 'app_menus.menu_description', 'app_menus.date', 'vendors.vendorname')
        ->orderBy('id', 'DESC')
        ->get();
     
        return response()->json(['status'=>1,'message'=>'success','data'=>$orders]);
           
           
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    
    }
    
    public function comp_paid_order_del(){
        
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token','order_id');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");          
        $token=$datas['token'];
        $order_id=$datas['order_id'];
      
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
          
        
        $orders= CompPaidOrder::where('order_id', $order_id)->first();
        
        if(isset($orders->status)){
         if($orders->status<=1){
            DB::table('comp_paid_orders')->where('order_id', $order_id)->delete();
            return response()->json(['status'=>1,'message'=>'success']);  
         } else {
           return response()->json(['status'=>0,'message'=>'You can not delete, Order already accepted.']);   
         }
        } else {
            return response()->json(['status'=>0,'message'=>'Order ID not exits.']);  
        } 
     
        
           
           
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    
    }
    
    
    public function vendor_login(){
        
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('username','password');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");          
        $username=$datas['username'];
        $password=$datas['password'];
      
       $vendor = Vendor::where('username',$username)
       ->select('id', 'vendorId', 'vendorname', 'username', 'contactName', 'companyRole', 'employeeNumber', 'yearExp', 'kitchenArea', 'mealCapacity', 'companyType', 'vendorScope', 'auditRating', 'cameraNumber', 'cameraMegaPixel')
       ->first();
        if(!empty($vendor->id)){
            if(auth()->attempt(array('username' => $datas['username'], 'password' => $datas['password'])))
            {
                 $token=rand(111111111,999999999);
                 DB::update('update vendors set  token = ? where username = ?',[$token,$username]); 
                 return response()->json(['status'=>1,'message'=>'success','token'=>$token,'data'=>$vendor]);
               } else {
               return response()->json(['status'=>0,'message'=>'Invalid password']);  
              }
                
                
            } else {
               return response()->json(['status'=>0,'message'=>'Invalid username']);  
            }
    }
    
    public function vendor_item_list(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token','vendor_id');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        $vendor_id=$datas['vendor_id'];
        
        $vendor = Vendor::where('token',$token)->first();
        if(!empty($vendor->username)){
         
            
            $items = DB::table('calorie_item_table')
            ->select('id', 'item_name', 'item_code','item_quantity','item_price','is_available')
            ->where('vendor_id', '=', $vendor_id) 
            ->get();
        
                
           if(isset($items[0]->item_name))  {
            return response()->json(['status'=>1,'message'=>'success','data'=>$items]); 
           } else {
             return response()->json(['status'=>0,'message'=>'No any items on this vendor id']);  
           } 
                
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    }
    
    public function update_item_available(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token','item_id','is_available');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        $item_id=$datas['item_id'];
        $is_available=$datas['is_available'];
        
        $vendor = Vendor::where('token',$token)->first();
        if(!empty($vendor->username)){
            DB::update('update calorie_item_table set is_available = ? where id = ?',[$is_available,$item_id]);
            return response()->json(['status'=>1,'message'=>'success']);  
                
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    }
    
    public function verify_order(){
       
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token','order_id');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        $order_id=$datas['order_id'];
        $start_with_order_id=substr( $order_id, 0, 1 );
        
       $vendor = Vendor::where('token',$token)->first();
        if(!empty($vendor->username)){
         
          
        if($start_with_order_id==1){  
        
            $orders = DB::table('comp_paid_orders')
                    ->join('app_menus', 'app_menus.id', '=', 'comp_paid_orders.menu_id')
                    ->join('customers', 'customers.id', '=', 'comp_paid_orders.customer_id')
                    ->join('users', 'users.username', '=', 'customers.client_code')
                    ->where('order_id', $order_id)
                    ->where('vendor_id', $vendor->vendorId)
                    ->select('comp_paid_orders.id','comp_paid_orders.order_id','comp_paid_orders.menu_id','comp_paid_orders.customer_id', 'comp_paid_orders.status','comp_paid_orders.created_at', 'app_menus.menu_title', 'app_menus.menu_time', 'app_menus.menu_description', 'app_menus.date', 'customers.name','users.name as company_name', 'users.address as company_address')
                    ->first();
                    
            if(!empty($orders->id)){
                return response()->json(['status'=>1,'message'=>'success','data'=>$orders]);  
            } else {
                return response()->json(['status'=>0,'message'=>'Order ID not exits.']);  
            }  
              
        }else if($start_with_order_id==2){
            
            $orders = DB::table('payments')
                    ->join('customers', 'customers.id', '=', 'payments.customer_id')
                    ->join('users', 'users.username', '=', 'customers.client_code')
                    ->where('order_id', $order_id)
                    ->where('vendor_id', $vendor->vendorId)
                    ->select('payments.id','payments.order_id','payments.total','payments.paid_status', 'payments.status','payments.delivery_time', 'payments.created_at', 'customers.name','users.name as company_name', 'users.address as company_address')
                    ->first();
               
            if(!empty($orders->id)){
                $orders->items = DB::table('self_paid_order_items')->where('order_id', $orders->order_id)
                        ->join('calorie_item_table', 'calorie_item_table.id', '=', 'self_paid_order_items.item_id')
                        ->select('self_paid_order_items.item_id','self_paid_order_items.qty','self_paid_order_items.mrp', 'calorie_item_table.item_name')
                        ->get()->toArray();
                return response()->json(['status'=>1,'message'=>'success','data'=>$orders]);  
            } else {
                return response()->json(['status'=>0,'message'=>'Order ID not exits.']);  
            }     
        }
                
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
     
    }
    
    public function vendor_cpaid_orders(){
       
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token','date');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        $date=$datas['date'];
        $vendor = Vendor::where('token',$token)->first();
        if(!empty($vendor->username)){
        
            $orders = DB::table('comp_paid_orders')
                    ->join('app_menus', 'app_menus.id', '=', 'comp_paid_orders.menu_id')
                    ->join('customers', 'customers.id', '=', 'comp_paid_orders.customer_id')
                    ->join('users', 'users.username', '=', 'customers.client_code')
                    ->where('comp_paid_orders.vendor_id', $vendor->vendorId)
                    ->whereDate('app_menus.date', $date)
                    ->select('comp_paid_orders.id','comp_paid_orders.order_id','comp_paid_orders.menu_id','comp_paid_orders.customer_id', 'comp_paid_orders.status','comp_paid_orders.created_at', 'app_menus.menu_title', 'app_menus.menu_time', 'app_menus.menu_description', 'app_menus.date', 'customers.name', 'users.name as company_name', 'users.address as company_address')
                    ->get();
        
                return response()->json(['status'=>1,'message'=>'success','data'=>$orders]);  
       
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    }
    
    public function upd_comp_paid_order(){
      
       
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token','order_id','status');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        $order_id=$datas['order_id'];
        $status=$datas['status'];
    
        $vendor = Vendor::where('token',$token)->first();
        if(!empty($vendor->username)){
         
          
        
        $orders = DB::table('comp_paid_orders')
        ->where('order_id', $order_id)
        ->first();
                    
       
        if(!empty($orders->id)){
       
            DB::update('update comp_paid_orders set status = ? where order_id = ?',[$status, $order_id]);
            return response()->json(['status'=>1,'message'=>'success']);  
       
        } else {
            return response()->json(['status'=>0,'message'=>'Order ID not exits.']);  
        }  
              
        
                
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
     
      
    }
    
    
    public function create_self_paid_order(){
           header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);

        $should_be=array('token','vendor_id','amount','productinfo','firstname','phone','email','items');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']);
        }
        
        $key = "2PBP7IABZ2";
        $salt = "DAH88E3UWQ";
        $txnid = intval(microtime(true)*10000);
        $hash = $this->generate_payu_hash( $salt, $key, $txnid, $datas['amount'], $datas['firstname'], $datas['email'], $datas['productinfo'] );
        $surl = "https://www.mysite.com/success.php";
        $furl = "https://www.mysite.com/fail.php";
        
        date_default_timezone_set("Asia/Kolkata");    
        $token=$datas['token'];
        $items=isset($datas['items'])?$datas['items']:array();
        if(empty($items)){ return  response()->json(['status'=>0,'message'=>'Items can not be empty']);  };
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
            
            $post_data = [
                'key' => $key,
                'txnid' => $txnid,
                'amount' => $datas['amount'],
                'productinfo' => $datas['productinfo'],
                'firstname' => $datas['firstname'],
                'phone' => $datas['phone'],
                'email' => $datas['email'],
                'surl' => $surl,
                'furl' => $furl,
                'hash' => $hash
            ];
            //$post_data = json_encode($post_data, true);
            $ch1 = curl_init('https://testpay.easebuzz.in/payment/initiateLink');
            curl_setopt($ch1, CURLOPT_POST, true);
            curl_setopt($ch1, CURLOPT_POSTFIELDS, $post_data);
            //curl_setopt($ch1, CURLOPT_HTTPHEADER, array("Content-Type: application/json"));
            curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
            $response1 = curl_exec($ch1);
            $json_res = json_decode($response1);
            
            if($json_res->status == 1){
            
                $orderId='2'.rand(111111,999999);
                $Payment = new Payment;
                $Payment->customer_id = $customer->id;
                $Payment->vendor_id = $datas['vendor_id'];
                $Payment->order_id = $orderId;
        		$Payment->txn_id = $txnid;
        		$Payment->total = $datas['amount'];
        		$Payment->paid_status = 0;
        		$Payment->created_at = date('Y-m-d H:i:s');
        		$Payment->save();
    		
    		    foreach($items as $key=>$val){
    		    
            		$SelfPaidOrder = new SelfPaidOrderItem;
                    $SelfPaidOrder->order_id = $orderId;
                    $SelfPaidOrder->item_id = $val['item_id'];
                    $SelfPaidOrder->qty =$val['qty'];
            		$SelfPaidOrder->mrp = $val['mrp'];
            		$SelfPaidOrder->created_at = date('Y-m-d H:i:s');
            		$SelfPaidOrder->save();  
    		    
    		    }
    		
    		    return response()->json(['status'=>1,'message'=>'success','order_id'=>$orderId, 'access_key'=>$json_res->data]); 
            }else{
                return response()->json(['status'=>0,'message'=>'Payment fail! '.$json_res->error_desc]); 
            }
		
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    }
    
    
    public function generate_payu_hash($salt, $key,$txnid,$amount,$firstname,$email,$productinfo){
        
        $hash = '';
        // Hash Sequence
        $hashSequence = "key|txnid|amount|productinfo|firstname|email|udf1|udf2|udf3|udf4|udf5|udf6|udf7|udf8|udf9|udf10";
        
        if(empty($salt) || empty($key) || empty($txnid) || empty($amount) || empty($firstname) || empty($email) || empty($productinfo) ) {
             return response()->json(['status'=>0,'message'=>'Some feals are empty please check']);
        } else {
            $hash_string = '';	
            $hash_string = $key.'|'.$txnid.'|'.$amount.'|'.$productinfo.'|'.$firstname.'|'.$email.'|||||||||||'.$salt;
            $hash = strtolower(hash('sha512', $hash_string));
            
            return $hash; 
        
       }
 
    }
    
    public function confirm_self_order(){
         header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token','order_id','items');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");    
        $token=$datas['token'];
        $order_id=$datas['order_id'];
        $items=isset($datas['items'])?$datas['items']:array();
        if(empty($items)){ return  response()->json(['status'=>0,'message'=>'Items can not be empty']);  };
  
    
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
            
       
         
        if(empty($items)){ $items=array(); };
		
		foreach($items as $key=>$val){
		    
    	     DB::table('carts')
    	     ->where('customer_id', $customer->id)
    	     ->where('item_id', $val['item_id'])
    	     ->delete();
         }
		
		 DB::update('update payments set paid_status = ? where order_id = ?',[1,$order_id]);
		 
		 return response()->json(['status'=>1,'message'=>'success']);  
        }else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    }
     public function self_paid_order_list(){
        
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");          
        $token=$datas['token'];
      
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
            
         
        $orders= Payment::where('customer_id', $customer->id)
        ->join('vendors', 'vendors.vendorId', '=', 'payments.vendor_id')
        ->select('payments.id','payments.order_id','payments.txn_id','payments.total','payments.paid_status','payments.status','payments.delivery_time','payments.created_at','vendors.vendorname','vendors.gst_no','vendors.pan_no')
        ->orderBy('payments.id', 'DESC')
        ->get();
        if( count($orders)>0)
		{ 
		    for ($i = 0; $i < count($orders); $i++) {
                $orders[$i]['items'] = DB::table('self_paid_order_items')->where('order_id', $orders[$i]['order_id'])
                ->join('calorie_item_table', 'calorie_item_table.id', '=', 'self_paid_order_items.item_id')
                ->select('self_paid_order_items.item_id','self_paid_order_items.qty','self_paid_order_items.mrp', 'calorie_item_table.item_name', 'calorie_item_table.gst')
                ->get()->toArray();
            }
		    return response()->json(['status'=>1,'message'=>'success','data'=>$orders]);
		}
		else
		{
		    return response()->json(['status'=>1,'message'=>'success','data'=>$orders]);
		}
        
        return response()->json(['status'=>1,'message'=>'success','data'=>$orders]);
           
           
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    }

    public function update_self_paid_order(){
      
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token','order_id','status','reject_reason');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        $order_id=$datas['order_id'];
        $status=$datas['status'];
        $reject_reason=$datas['reject_reason'];
        $delivery_time=$datas['delivery_time'];
    
        $vendor = Vendor::where('token',$token)->first();
        if(!empty($vendor->username)){
         
          
        $orders = DB::table('payments')
        ->where('order_id', $order_id)
        ->first();
                    
       
        if(!empty($orders->id)){
            if(!empty($delivery_time))
            DB::update('update payments set status = ?,reject_reason = ? , delivery_time = ? where order_id = ?',[$status,$reject_reason,$delivery_time,$order_id]);
            else 
            DB::update('update payments set status = ?,reject_reason = ? where order_id = ?',[$status,$reject_reason,$order_id]);
            return response()->json(['status'=>1,'message'=>'success']);  
       
        } else {
            return response()->json(['status'=>0,'message'=>'Order ID not exits.']);  
        }  
              
        
                
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
      
    }
    
    public function vendor_self_paid_orders(){
        
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");          
        $token=$datas['token'];
        $date=$datas['date'];
        
        $vendor = Vendor::where('token',$token)->first();
        if(!empty($vendor->username)){
            
            $orders= Payment::where('vendor_id', $vendor->vendorId)
            ->whereDate('payments.created_at', $date)
            ->where('payments.paid_status', 1)
            ->join('customers', 'customers.id', '=', 'payments.customer_id')
            ->join('users', 'users.username', '=', 'customers.client_code')
            ->select('payments.id','payments.order_id','payments.txn_id','payments.total','payments.paid_status','payments.status','payments.delivery_time','payments.created_at','customers.name','users.name as company_name', 'users.address as company_address')
            ->orderBy('payments.id', 'DESC')
            ->get();
            
        if( count($orders)>0)
		{ 
		    for ($i = 0; $i < count($orders); $i++) {
                $orders[$i]['items'] = DB::table('self_paid_order_items')->where('order_id', $orders[$i]['order_id'])
                ->join('calorie_item_table', 'calorie_item_table.id', '=', 'self_paid_order_items.item_id')
                ->select('self_paid_order_items.item_id','self_paid_order_items.qty','self_paid_order_items.mrp', 'calorie_item_table.item_name')
                ->get()->toArray();
            }
		    return response()->json(['status'=>1,'message'=>'success','data'=>$orders]);
		}
		else
		{
		    return response()->json(['status'=>1,'message'=>'success','data'=>$orders]);
		}
        
        return response()->json(['status'=>1,'message'=>'success','data'=>$orders]);
           
           
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    }
    
    
     public function get_customer_option(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        if(!isset($datas)){   return  response()->json(['status'=>0,'message'=>'token key is required']);  }
        $should_be=array('token');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
          $company_id=$customer->client_code;
         
          $clients = Client::where('username',$company_id)->first();
          $company_id=$clients->clientId;
          
          
          if(!empty($company_id))  {
            $is_company_paid=false;
            $is_self_paid=false;
            $query_cpaid= "select `map_roles`.`v_type` from `map_roles` where  `map_roles`.`clientId` = $company_id and `map_roles`.`v_type` = '1' ";
            $vendors_cpaid= DB::select($query_cpaid);
            if(isset($vendors_cpaid[0])) $is_company_paid=true;
            
            $query_selfpaid= "select `map_roles`.`v_type` from `map_roles` where  `map_roles`.`clientId` = $company_id and `map_roles`.`v_type` = '0' ";
            $vendors_selfpaid= DB::select($query_selfpaid);
            if(isset($vendors_selfpaid[0])) $is_self_paid=true;
           
            return response()->json(['status'=>1,'message'=>'success', 'is_company_paid'=>$is_company_paid, 'is_self_paid'=>$is_self_paid ]);  
              
          } else {
             return response()->json(['status'=>0,'message'=>'Invalid Company ID']);  
          }
                
        } else {
          return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
        
    }
    
    public function get_vendor_option(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        if(!isset($datas)){   return  response()->json(['status'=>0,'message'=>'token key is required']);  }
        $should_be=array('token');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
        
        $vendor = Vendor::where('token',$token)->first();
        if(!empty($vendor->username)){
          $vendorId=$vendor->vendorId;
         
          if(!empty($vendorId))  {
            $is_company_paid=false;
            $is_self_paid=false;
            $query_cpaid= "select `map_roles`.`v_type` from `map_roles` where  `map_roles`.`vendorId` = $vendorId and `map_roles`.`v_type` = '1' ";
            $vendors_cpaid= DB::select($query_cpaid);
            if(isset($vendors_cpaid[0])) $is_company_paid=true;
            
            $query_selfpaid= "select `map_roles`.`v_type` from `map_roles` where  `map_roles`.`vendorId` = $vendorId and `map_roles`.`v_type` = '0' ";
            $vendors_selfpaid= DB::select($query_selfpaid);
            if(isset($vendors_selfpaid[0])) $is_self_paid=true;
           
            return response()->json(['status'=>1,'message'=>'success', 'is_company_paid'=>$is_company_paid, 'is_self_paid'=>$is_self_paid ]);  
              
          } else {
             return response()->json(['status'=>0,'message'=>'Invalid Company ID']);  
          }
                
        } else {
          return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
        
    }
    
    
    public function save_feedback(){
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token','vendor_id','rating','review');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        }  
        
        date_default_timezone_set("Asia/Kolkata");        
        $token=$datas['token'];
        
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
          
            $Feedback = Feedbacks::where('customer_id',$customer->id)
            ->where('vendor_id',$datas['vendor_id'])
            ->first();
            
            if(!empty($Feedback->id)){
                DB::update('update feedbacks set rating = ? , review = ? , updated_at = ? where id = ?',[$datas['rating'],$datas['review'], date('Y-m-d H:i:s'), $Feedback->id]);
            } else {
              
                $Fdbk = new Feedbacks;
                $Fdbk->customer_id = $customer->id;
                $Fdbk->vendor_id = $datas['vendor_id'];
				$Fdbk->rating = $datas['rating'];
				$Fdbk->review = $datas['review'];
				$Fdbk->created_at = date('Y-m-d H:i:s');
				$Fdbk->updated_at = date('Y-m-d H:i:s');
				$Fdbk->save(); 
			}	
               
           return response()->json(['status'=>1,'message'=>'success']);  
         
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    }
    
    public function get_feedbacks(){
       
        header('Content-Type: application/json');
        $datas = json_decode(file_get_contents('php://input'), true);
        $should_be=array('token','vendor_id');
        $post=array_keys($datas);
        $result=array_diff($should_be,$post);
        if(!empty($result)){
            $result=implode(',',$result);
            return  response()->json(['status'=>0,'message'=>$result.' key is required']); 
        } 
        date_default_timezone_set("Asia/Kolkata");
        $token=$datas['token'];
       
        $customer = Customer::where('token',$token)->first();
        if(!empty($customer->mobile_number)){
            $myorder = DB::table('feedbacks')
                    ->where('feedbacks.customer_id', $customer->id)
                    ->where('feedbacks.vendor_id', $datas['vendor_id'])
                    ->select('feedbacks.rating','feedbacks.review','feedbacks.created_at', 'feedbacks.updated_at')
                    ->first();
            $orders = DB::table('feedbacks')
                    ->join('customers', 'customers.id', '=', 'feedbacks.customer_id')
                    ->where('feedbacks.vendor_id', $datas['vendor_id'])
                    ->select('feedbacks.rating','feedbacks.review','feedbacks.created_at', 'feedbacks.updated_at', 'customers.name')
                    ->limit(200)->offset(0)->orderBy('feedbacks.id', 'DESC')
                    ->get();
        
                return response()->json(['status'=>1,'message'=>'success','myfeedback'=>$myorder, 'data'=>$orders]);  
       
        } else {
           return response()->json(['status'=>0,'message'=>'Please login for access']);  
        }
    
    }

  
}