<?php

Route::group(['module' => 'Client', 'prefix' => 'client', 'middleware' => ['web', 'auth', 'role:client'], 'namespace' => 'App\Modules\Client\Controllers'], function() {

    Route::resource('client', 'ClientController');

    Route::get('marshal', 'ClientController@marshal_list');

    Route::get('existing/event', 'ClientController@showEventsList');
    Route::get('book/event', 'ClientController@showEventForm');
    Route::post('book/event', 'ClientController@add_event');
    Route::get('event/{type}/{id}', 'ClientController@viewOrEditEvent');
    Route::any('editevent', 'ClientController@updateEvent');

    Route::any('existing/concern', 'ClientController@all_concerns');
    Route::get('raise/concern', 'ClientController@concern');
    Route::post('raise/concern', 'ClientController@generateConcern');
    Route::get('view/concern/{id}', 'ClientController@viewConcern');
    Route::get('close/concern/{id}', 'ClientController@closeConcern');
    Route::post('concern/msg', 'ClientController@concernMessageInput');

    Route::get('view/vendorMenus/{vendorId?}', 'ClientController@viewVendorMenu');
    Route::post('vendorMenus/status', 'ClientController@changeMealStatus');
    Route::get('feedback', 'ClientController@feedback');
    Route::post('feedback', 'ClientController@submitFeedback');

    Route::get('view/vendor/{type?}/{vendorId?}', 'ClientController@viewVendorDocuments');
    Route::post('vendorDocuments/status', 'ClientController@changeStatus');

    Route::post('marshal_detail', 'ClientController@marshal_detail');
    
    Route::get('notifications', 'ClientController@notifications');

    //AI Feeds
    Route::get('aiFeedsVendorList','ClientController@viewAIFeedVendor');
    Route::get('viewAIVendorCamera/{id}','ClientController@viewAIVendorCameraList');
    Route::get('viewvendoraifeeds/{id}', 'ClientController@viewVendorAIFeeds');

});



Route::group(['module' => 'Client', 'prefix' => 'client/ICount/I-count', 'middleware' => ['web', 'auth', 'role:client'], 'namespace' => 'App\Modules\Client\Controllers'], function() {

    Route::get('new_qr', 'ClientController@new_qr_generate_view');
    Route::post('generate_qr_code', 'ClientController@qr_code_generator');
    Route::get('client_success_qr_generate', 'ClientController@success_qr_generate');
    
    Route::get('client_qr_code', 'ClientController@client_qr_code');

    Route::get('emp_list', 'ClientController@emp_list');
    Route::get('add_emp_view', 'ClientController@add_emp_view');
    Route::post('add_emp', 'ClientController@add_emp');
    
    Route::post('edit_emp', 'ClientController@edit_emp');
    Route::post('update_emp', 'ClientController@update_emp');

    Route::post('delete_emp', 'ClientController@delete_emp');

    Route::get('view_invoice', 'ClientController@view_invoice');
    Route::any('generate_invoice', 'ClientController@generate_invoice');
    Route::post('export_invoice', 'ClientController@export_invoice');
    
    Route::get('view_report', 'ClientController@view_report');
    Route::any('generate_report', 'ClientController@generate_report');
    Route::post('export_report', 'ClientController@export_report');
    
//    Route::get('view_dining_report', 'ClientController@view_report');
//    Route::any('generate_report', 'ClientController@generate_report');
//    Route::post('export_report', 'ClientController@export_report');
    
    Route::match(['get', 'post'], 'client_emp_type4_view_list/{search?}', 'ClientController@client_emp_type4_view_list');
    //Single EMP
    Route::post('client_emp_cal_report', 'ClientController@client_emp_cal_report');
    Route::post('emp_cal_report', 'ClientController@getEmpCalReport');
    //All EMP
    Route::get('client_emp_cal_report', 'ClientController@client_all_emp_cal_report');
    Route::post('client_all_emp_cal_report', 'ClientController@client_all_emp_cal_report');
    Route::post('client_employees_cal', 'ClientController@getClientEmployeesCal');
    
    Route::get('give_qr_type_detail/{qr_type?}/{client_code?}', 'ClientController@give_qr_type_detail');
    
    //Generate Dining Sale Reports
    Route::get('alldiningsalereport/{search?}', 'ClientController@alldiningsalereport');
    Route::match(['get', 'post'], 'generate_diningsale_report', 'ClientController@generate_diningsale_report');
    
    //Generate single employee sale report
    Route::match(['get', 'post'], 'client_emp_type4_sale_view_list/{search?}', 'ClientController@client_emp_type4_sale_view_list');
    Route::post('client_emp_sale_report', 'ClientController@client_emp_sale_report');
    Route::match(['get', 'post'], 'generate_emp_diningsale_report', 'ClientController@generate_emp_diningsale_report');
    

});