@extends('layouts.masterDashboard')
@section('content')
<?php
    $roleName = isset($result['foodscraftRole']) && !empty($result['foodscraftRole']) ? strtolower($result['foodscraftRole']) : (isset($roleType) && !empty($roleType) ? strtolower($roleType) : '');
    // dd($result, $roleName);
?>
<div class="row">
    <div class="col-md-12">
        <div class="main-card mb-3 card">
            <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                @if(isset($result))
                    @if($roleName !== 'sitemarshal')
                        <h3>{{ 'VIEW '. $roleName .' PROFILE' }}</h3>
                    @else
                        <h3>{{ 'VIEW Team FK PROFILE' }}</h3>
                    @endif
                @else
                    <h3>REGISTER</h3>
                @endif
            </div>
            <div class="card-body">
                <form class="fkformlabel">
                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="name">{{ $roleName == "client" ? "Client's Name" : ($roleName == "vendor" ? 'Name of the Company' : 'Name') }}</label><span class="required-field">*</span>
                                <input type="text" id="name" class="form-control" autocomplete="off" name="name" value="{{ isset($result['name']) ? $result['name'] : '' }}" required <?php echo!isset($result['name']) && empty($result['name']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="username">Vendor Code</label><span class="required-field">*</span>
                                <input type="text" id="username" class="form-control" autocomplete="off" name="username" value="{{ isset($result['username']) ? $result['username'] : '' }}" required <?php echo!isset($result['username']) && empty($result['username']) ? '' : ($type == "edit" ? 'readonly' : ($type == "view" ? 'disabled' : '')) ?> />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="email">Email address</label><span class="required-field">*</span>
                                <input type="email" id="email" class="form-control" name="email" required autocomplete="off" value="{{ isset($result['email']) ? $result['email'] : '' }}" required <?php echo!isset($result['email']) && empty($result['email']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="contactName">Contact person name</label><span class="required-field">*</span>
                                <input id="contactName" type="text" class="form-control" name="contactName" autocomplete="off" value="{{ isset($result['contactName']) && !empty($result['contactName']) ? $result['contactName'] : '' }}" required <?php echo!isset($result['contactName']) && empty($result['contactName']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="contactNumber">{{ $roleName == "vendor" ? 'Contact person number' : 'Mobile number' }}</label><span class="required-field">*</span>
                                <input id="contactNumber" type="tel" pattern="^[0-9]{10}$" data-toggle="tooltip" title="10 Digit Mobile Number Only" class="form-control" name="contactNumber" autocomplete="off" value="{{ isset($result['contactNumber']) && !empty($result['contactNumber']) ? $result['contactNumber'] : '' }}" required <?php echo!isset($result['contactNumber']) && empty($result['contactNumber']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="address">{{ $roleName .' address' }}</label><span class="required-field">*</span>
                                <input id="address" type="text" class="form-control" name="address" autocomplete="off" value="{{ isset($result['address']) && !empty($result['address']) ? $result['address'] : '' }}" required <?php echo!isset($result['address']) && empty($result['address']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                            </div>
                        </div>
                    </div>

                    @if($roleName == "vendor")
                        @include('Admin::registerVendor')
                    @endif

                    @if(isset($result))
                        @if($type == "view")
                            <div class="mb-4 p-1 {{ isset($result['documents']) && !empty($result['documents']) ? '' : 'd-flex justify-content-center' }}">
                                @if(isset($result['documents']) && !empty($result['documents']))
                                    <?php
                                        //$url = asset('storage/documents/vendors') . '/' . $result['vendorId'] . '/';
                                        $url = asset('storage/app/public/documents/vendors') . '/' . $result['vendorId'] . '/';
                                        $elements = $result['documents'][0];
                                    ?>
                                    <div class="row justify-content-center">
                          @if(!empty($elements['companyProfile']))
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <div class="form-group mb-1">
                                      <a
                                          class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                          data-toggle="tooltip"
                                          target="_blank"
                                          title="{{ $elements['companyProfile'] }}"
                                          href="{{ $url.$elements['companyProfile'] }}"
                                      >
                                          Company Profile
                                      </a>
                                  </div>
                              </div>
                          @endif
                      </div>
                      <div class="row justify-content-center">
                          @if(!empty($elements['fssai']))
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="{{ $elements['fssai'] }}"
                                      href="{{ $url.$elements['fssai'] }}"
                                  >
                                      Fssai
                                  </a>
                              </div>
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm">
                                          <input class="form-control shadow-sm" id="fssai_expiry_date" type="text" name="fssai_expiry_date" value="{{ $elements['fssai_expiry_date'] }}" readonly>
                                      </div>
                                  </div>
                              </div>
                          @endif
                      </div>
                      <div class="row justify-content-center">
                          @if(!empty($elements['gst']))
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="{{ $elements['gst'] }}"
                                      href="{{ $url.$elements['gst'] }}"
                                  >
                                      GST
                                  </a>
                              </div>
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm">
                                          <input class="form-control shadow-sm" id="gst_expiry_date" type="text" name="gst_expiry_date" value="{{ $elements['gst_expiry_date'] }}" readonly>
                                      </div>
                                  </div>
                              </div>
                          @endif
                      </div>
                      <div class="row justify-content-center">
                          @if(!empty($elements['panCard']))
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="{{ $elements['panCard'] }}"
                                      href="{{ $url.$elements['panCard'] }}"
                                  >
                                      Pan Card
                                  </a>
                              </div>
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm">
                                          <input class="form-control shadow-sm" id="pancard_expiry_date" type="text" name="pancard_expiry_date" value="{{ $elements['pancard_expiry_date'] }}" readonly>
                                      </div>
                                  </div>
                              </div>
                          @endif
                      </div>
                      <div class="row justify-content-center">
                          @if(!empty($elements['companyReg']))
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="{{ $elements['companyReg'] }}"
                                      href="{{ $url.$elements['companyReg'] }}"
                                  >
                                      Company Registration
                                  </a>
                              </div>
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm">
                                          <input class="form-control shadow-sm" id="cr_expiry_date" type="text" name="cr_expiry_date" value="{{ $elements['cr_expiry_date'] }}" readonly>
                                      </div>
                                  </div>
                              </div>
                          @endif
                      </div>
                      <div class="row justify-content-center">
                        @if(!empty($elements['pf']))
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="{{ $elements['pf'] }}"
                                      href="{{ $url.$elements['pf'] }}"
                                  >
                                      PF
                                  </a>
                              <!--</div>-->
                          </div>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                            <div class="custom-file">
                                <div class="input-group p-0 shadow-sm">
                                    <input class="form-control shadow-sm" id="pf_expiry_date" type="text" name="pf_expiry_date" value="{{ $elements['pf_expiry_date'] }}" readonly>
                                </div>
                            </div>
                          </div>
                        @endif
                      </div>
                      <div class="row justify-content-center">
                      @if(!empty($elements['labourLicense']))
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="{{ $elements['labourLicense'] }}"
                                      href="{{ $url.$elements['labourLicense'] }}"
                                  >
                                      Labour License
                                  </a>
                              <!--</div>-->
                          </div>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <div class="custom-file">
                                  <div class="input-group p-0 shadow-sm">
                                      <input class="form-control shadow-sm" id="labourLicense_expiry_date" type="text" name="labourLicense_expiry_date" value="{{ $elements['labourLicense_expiry_date'] }}" readonly>
                                  </div>
                              </div>
                          </div>
                      @endif
                      </div>
                      <div class="row justify-content-center">
                      @if(!empty($elements['workerHealth']))
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="{{ $elements['workerHealth'] }}"
                                      href="{{ $url.$elements['workerHealth'] }}"
                                  >
                                      Worker Health
                                  </a>
                              <!--</div>-->
                          </div>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <div class="custom-file">
                                  <div class="input-group p-0 shadow-sm">
                                      <input class="form-control shadow-sm" id="workerHealth_expiry_date" type="text" name="workerHealth_expiry_date" value="{{ $elements['workerHealth_expiry_date'] }}" readonly>
                                  </div>
                              </div>
                          </div>
                      @endif
                      </div>
                      <div class="row justify-content-center">
                      @if(!empty($elements['foodTestReport']))
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="{{ $elements['foodTestReport'] }}"
                                      href="{{ $url.$elements['foodTestReport'] }}"
                                  >
                                      Food Test Report
                                  </a>
                              <!--</div>-->
                          </div>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                            <div class="custom-file">
                                <div class="input-group p-0 shadow-sm">
                                    <input class="form-control shadow-sm" id="foodTestReport_expiry_date" type="text" name="foodTestReport_expiry_date" value="{{ $elements['foodTestReport_expiry_date'] }}" readonly>
                                </div>
                            </div>
                        </div>
                      @endif
                      </div>
                      <div class="row justify-content-center">
                      @if(!empty($elements['waterTestReport']))
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="{{ $elements['waterTestReport'] }}"
                                      href="{{ $url.$elements['waterTestReport'] }}"
                                  >
                                      Water Test Report
                                  </a>
                              <!--</div>-->
                          </div>
                      <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                            <div class="custom-file">
                                <div class="input-group p-0 shadow-sm">
                                    <input class="form-control shadow-sm" id="waterTestReport_expiry_date" type="text" name="waterTestReport_expiry_date" value="{{ $elements['waterTestReport_expiry_date'] }}" readonly>
                                </div>
                            </div>
                        </div>
                      @endif
                      </div>
                      <div class="row justify-content-center">
                      @if(!empty($elements['pestControlReport']))
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="{{ $elements['pestControlReport'] }}"
                                      href="{{ $url.$elements['pestControlReport'] }}"
                                  >
                                      Pest Control Report
                                  </a>
                              <!--</div>-->
                          </div>
                      <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                            <div class="custom-file">
                                <div class="input-group p-0 shadow-sm">
                                    <input class="form-control shadow-sm" id="pestControlReport_expiry_date" type="text" name="pestControlReport_expiry_date" value="{{ $elements['pestControlReport_expiry_date'] }}" readonly>
                                </div>
                            </div>
                        </div>
                      @endif
                      </div>
                      <div class="row justify-content-center">
                      @if(!empty($elements['kitchenAuditReport']))
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="{{ $elements['kitchenAuditReport'] }}"
                                      href="{{ $url.$elements['kitchenAuditReport'] }}"
                                  >
                                      Kitchen Audit Report
                                  </a>
                              <!--</div>-->
                          </div>
                      <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                            <div class="custom-file">
                                <div class="input-group p-0 shadow-sm">
                                    <input class="form-control shadow-sm" id="kitchenAuditReport_expiry_date" type="text" name="kitchenAuditReport_expiry_date" value="{{ $elements['kitchenAuditReport_expiry_date'] }}" readonly>
                                </div>
                            </div>
                        </div>
                      @endif
                      </div>
                      <div class="row justify-content-center">
                      @if(!empty($elements['policeVerificationReport']))
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="{{ $elements['policeVerificationReport'] }}"
                                      href="{{ $url.$elements['policeVerificationReport'] }}"
                                  >
                                      Police Verification Report
                                  </a>
                              <!--</div>-->
                          </div>
                      <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                            <div class="custom-file">
                                <div class="input-group p-0 shadow-sm">
                                    <input class="form-control shadow-sm" id="policeVerificationReport_expiry_date" type="text" name="policeVerificationReport_expiry_date" value="{{ $elements['policeVerificationReport_expiry_date'] }}" readonly>
                                </div>
                            </div>
                        </div>
                      @endif
                      </div>
                      <div class="row justify-content-center">
                      @if(!empty($elements['cancelledCheque']))
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="{{ $elements['cancelledCheque'] }}"
                                      href="{{ $url.$elements['cancelledCheque'] }}"
                                  >
                                      Cancelled Cheque
                                  </a>
                              <!--</div>-->
                          </div>
                      @endif
                      </div>
                                @else
                                    <div class="badge badge-warning">Documents have not been submitted yet!</div>
                                @endif
                            </div>
                        @endif
                    @endif
                </form>
            </div>
        </div>
    </div>
</div>
@endsection