@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>{{ isset($allVendors) ? 'Vendor List' : 'Vendor Documents' }}</h3>
                </div>
                <div class="card-body">
                    @if(isset($allVendors))
                        <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-hover">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-center" scope="col">S.No.</th>
                                        <th class="text-center" scope="col">Name</th>
                                        <th class="text-center" scope="col">Contact Name</th>
                                        <th class="text-center" scope="col">Phone No.</th>
                                        <th class="text-center" scope="col">Document Status</th>
                                        <th scope="col" class="d-flex justify-content-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($allVendors as $vendor)
                                        <tr>
                                            <th class="text-center" scope="row">{{ $loop->iteration }}</th>
                                            <td class="text-center">{{ $vendor->name }}</td>
                                            <td class="text-center">{{ $vendor->contactName }}</td>
                                            <td class="text-center">{{ $vendor->contactNumber }}</td>
                                            <td class="text-center">
                                                <?php
                                                    $status = !isset($vendor->vendor_doc_status) ? '' : ($vendor->vendor_doc_status == 'pending' ? 'info' : ($vendor->vendor_doc_status == 'approve' ? 'success' : ($vendor->vendor_doc_status == 'submitted' ? 'secondary' : 'danger'))); 
                                                ?>
                                                <span class="badge badge-{{ $status }}">{{ $vendor->vendor_doc_status }}</span>
                                            </td>
                                            <td class="d-flex justify-content-center">
                                                <a href="{{ url('client/view/vendor/detail/'.$vendor->vendorId) }}" data-toggle="tooltip" title="View" class="btn btn-info mx-2">
                                                    <i class="fa fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" align="center">Not Found any</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection