@extends('layouts.masterDashboard')
@section('content')
<?php
    $roleName = isset($result['foodscraftRole']) && !empty($result['foodscraftRole']) ? strtolower($result['foodscraftRole']) : (isset($roleType) && !empty($roleType) ? strtolower($roleType) : '');
    // dd($result, $roleName);
?>
<div class="row">
    <div class="col-md-12">
        <div class="main-card mb-3 card">
            <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                @if(isset($result))
                    @if($roleName !== 'sitemarshal')
                        <h3>{{ 'VIEW '. $roleName .' PROFILE' }}</h3>
                    @else
                        <h3>{{ 'VIEW Team FK PROFILE' }}</h3>
                    @endif
                @else
                    <h3>REGISTER</h3>
                @endif
            </div>
            <div class="card-body">
                <form>
                    @if($roleName == "sitemarshal" && isset($type) && $type == "view")
                        <?php
                            $picture = $result['assignedSite'] !== 'default_foodscraft.png' ? asset('public/storage/avatars/marshals') . '/' . $result['marshalId'] . '/' . $result['assignedSite'] : asset('public/images/default_foodscraft.png');
                        ?>
                        <div class="row px-3">
                            <img class="rounded" width="200" height="100" src="{{ $picture }}" alt="Profile Picture" />
                        </div>
                    @endif
                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="name">{{ $roleName == "client" ? "Client's Name" : ($roleName == "vendor" ? 'Name of the Company' : 'Name') }}</label><span class="required-field">*</span>
                                <input type="text" id="name" class="form-control" autocomplete="off" name="name" value="{{ isset($result['name']) ? $result['name'] : '' }}" required <?php echo!isset($result['name']) && empty($result['name']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                            </div>
                        </div>
                        @if($roleName == "sitemarshal")
                            <div class="col-md-4 col-sm-12 px-md-1">
                                <div class="form-group">
                                    <label for="username">Employee ID</label><span class="required-field">*</span>
                                    <input type="text" id="username" class="form-control" autocomplete="off" name="username" value="{{ isset($result['username']) ? $result['username'] : '' }}" required <?php echo!isset($result['username']) && empty($result['username']) ? '' : ($type == "edit" ? 'readonly' : ($type == "view" ? 'disabled' : '')) ?> />
                                </div>
                            </div>
                        @endif
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="email">Email address</label><span class="required-field">*</span>
                                <input type="email" id="email" class="form-control" name="email" required autocomplete="off" value="{{ isset($result['email']) ? $result['email'] : '' }}" required <?php echo!isset($result['email']) && empty($result['email']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        @if($roleName == "sitemarshal")
                            <div class="col-md-4 col-sm-12 pr-md-1">
                                <div class="form-group">
                                    <label for="designation">Designation</label>
                                    <span class="required-field">*</span>
                                    <select class="form-control" name="designation" id="designation" required <?php echo !isset($result['designation']) && empty($result['designation']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> >
                                        <option value="{{ isset($result['designation']) ? ($type == 'view' ? $result['designation'] : '') : '' }}">{{ isset($result['designation']) && !empty($result['designation']) ? ($type == 'view' ? $result['designation'] : 'Select scope') : 'Select Designation' }}</option>
                                        <option value="sitemarshall">Site Marshall</option>
                                        <option value="sitemanager">Site Manager</option>
                                        <option value="zonemanager">Zone Manager</option>
                                        <option value="areamanager">Area Manager</option>
                                        <option value="countryhead">Country Head</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-12 px-md-1">
                                <div class="form-group">
                                    <label for="keyresponsibilities">Key Responsibilities</label>
                                    <span class="required-field">*</span>
                                    <select class="form-control" name="keyresponsibilities" id="keyresponsibilities" required <?php echo !isset($result['keyresponsibilities']) && empty($result['keyresponsibilities']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> >
                                        <option value="{{ isset($result['keyresponsibilities']) ? ($type == 'view' ? $result['keyresponsibilities'] : '') : '' }}">{{ isset($result['keyresponsibilities']) && !empty($result['keyresponsibilities']) ? ($type == 'view' ? $result['keyresponsibilities'] : 'Select scope') : 'Select key Responsibilities' }}</option>
                                        <option value="marketing">Marketing</option>
                                        <option value="sales">Sales</option>
                                        <option value="bd">BD</option>
                                        <option value="kitchenoperations">Kitchen Operations</option>
                                        <option value="newclientcatererexpansion">New Client + Caterer Expansion</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-12 pl-md-1">
                                <div class="form-group">
                                    <label for="contactNumber">Mobile number</label><span class="required-field">*</span>
                                    <input id="contactNumber" type="tel" pattern="^[0-9]{10}$" data-toggle="tooltip" title="10 Digit Mobile Number Only" class="form-control" name="contactNumber" autocomplete="off" value="{{ isset($result['contactNumber']) && !empty($result['contactNumber']) ? $result['contactNumber'] : '' }}" required <?php echo!isset($result['contactNumber']) && empty($result['contactNumber']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                                </div>
                            </div>
                        @endif
                    </div>

                    <input id="foodscraftRole" type="hidden" name="foodscraftRole" value="{{ isset($result['foodscraftRole']) ? $result['foodscraftRole'] : $roleType }}" />
                    <input type="hidden" name="address" id="address" value="default" />
                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="siteassigned">Designated Area</label>
                                <input id="siteassigned" type="text" class="form-control" pattern="[a-zA-Z ]+" data-toggle="tooltip" title="Text Only" placeholder="Location name" name="siteassigned" value="{{ isset($result['siteAssigned']) ? $result['siteAssigned'] : '' }}" <?php echo !isset($result['siteAssigned']) && empty($result['siteAssigned']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="govId">2 Government ID</label><span class="required-field">*</span>
                                <input id="govId" type="text" class="form-control" name="govId" value="{{ isset($result['govId']) ? $result['govId'] : '' }}" required <?php echo !isset($result['govId']) && empty($result['govId']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="yearExp">Years of experience</label>
                                <input id="yearExp" type="text" class="form-control" pattern="^[1-9]{1|2}$" data-toggle="tooltip" title="Max 2 Digits Only" name="yearExp" value="{{ isset($result['expInYrs']) ? $result['expInYrs'] : '' }}" <?php echo !isset($result['expInYrs']) && empty($result['expInYrs']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                            </div>
                        </div>
                    </div>
                    
                    @if(isset($type) && $type == "view" && isset($listMapfirstdata) && isset($listMapseconddata))
                        <!-- <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <h5 class="text-center d-flex justify-content-center">
                                        <span class="border-bottom-span border-bottom">Mapped Client List</span>
                                    </h5>
                                    <div class="card-body">
                                        <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                                            <table class="table table-hover">
                                                <thead class="text-dark">
                                                    <tr>
                                                        <th class="text-left" scope="col">S.No.</th> 
                                                        <th class="text-left" scope="col">Name</th>
                                                        <th class="text-left" scope="col">Client Code</th>
                                                        <th class="text-left" scope="col">Contact Number</th>
                                                        <th class="text-left" scope="col">Address</th>
                                                        <th class="text-left" scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($listMapseconddata as $key=>$value)
                                                        <tr>
                                                            <th class="text-left" scope="row">{{ ++$key }}</th>
                                                            <td class="text-left">{{ $value[0]['name'] }}</td>
                                                            <td class="text-left">{{ $value[0]['username'] }}</td>
                                                            <td class="text-left">{{ $value[0]['contactNumber'] }}</td>
                                                            <td class="text-left">{{ $value[0]['address'] }}</td>
                                                            <td class="d-flex">
                                                                <div class="peterriver" onclick="viewOrEdit('{{ url('viewOrEditRole') }}', 'view', '{{ $value[0]['clientId'] }}');">View</div> 
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="7" align="center" class="tablemotfounditem">Not Found any</td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> -->
                    
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <h5 class="text-center d-flex justify-content-center">
                                        <span class="border-bottom-span border-bottom">Mapped Vendor List</span>
                                    </h5>
                                    <div class="card-body">
                                        <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                                            <table class="table table-hover">
                                                <thead class="text-dark">
                                                    <tr>
                                                        <th class="text-left" scope="col">S.No.</th> 
                                                        <th class="text-left" scope="col">Name</th>
                                                        <th class="text-left" scope="col">Vendor Code</th>
                                                        <th class="text-left" scope="col">Contact Number</th>
                                                        <th class="text-left" scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($listMapfirstdata as $key=>$value)
                                                        <tr>
                                                            <th class="text-left" scope="row">{{ ++$key }}</th>
                                                            <td class="text-left">{{ $value[0]['name'] }}</td>
                                                            <td class="text-left">{{ $value[0]['username'] }}</td>
                                                            <td class="text-left">{{ $value[0]['contactNumber'] }}</td>
                                                            <td class="d-flex">
                                                                <a href="{{ url('client/view/vendor/detail') . '/' . $value[0]['vendorId'] }}" class="btn btn-info font-weight-bold px-3">View</a>
                                                                <!-- <div class="peterriver" onclick="viewOrEdit('{{ url('viewOrEditRole') }}', 'view', '{{ $value[0]['vendorId'] }}');">View</div>  -->
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="7" align="center" class="tablemotfounditem">Not Found any</td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if(!isset($result))
                        @if($roleName == "sitemarshal")
                            <h3>Education Qualification</h3>
                            <div class="row">
                                <div class="col-md-6 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="resume" lang="es" name="resume" onchange="putName(this);" accept=".doc, .pdf" />
                                            <label class="custom-file-label" for="resume">Resume</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pl-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="pro_pic" lang="es" name="pro_pic" onchange="putName(this);" accept=".jpg, .jpeg, .png" />
                                            <label class="custom-file-label" for="pro_pic">Profile Picture</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                        <div class="row w-50">
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="password">Password</label><span class="required-field">*</span>
                                    <input id="password" type="password" class="form-control" name="password" required autocomplete="new-password">
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="password-confirm">Confirm Password</label><span class="required-field">*</span>
                                    <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="update ml-auto mr-auto">
                                <button type="submit" class="turquoise">{{ __('Register') }}</button>
                            </div>
                        </div>
                    @elseif(isset($result))
                        @if($type == "view")
                            @if($roleName == "sitemarshal")
                                <div class="mb-4 p-1 {{ isset($result['documents']) && !empty($result['documents']) ? '' : 'd-flex justify-content-center' }}">
                                    @if(isset($result['documents']) && !empty($result['documents']))
                                        <?php
                                            $url = asset('public/storage/documents/marshals') . '/' . $result['marshalId'] . '/';
                                            $elements = $result['documents'][0];
                                        ?>
                                        <div class="row mb-4">
                                          <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                              <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['resume'] }}">
                                                  <a class="text-decoration-none text-white" href="{{ $url.$elements['resume'] }}" target="_blank">Resume</a>
                                              </button>
                                          </div>
                                          <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                              <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['first_gov_id'] }}">
                                                  <a class="text-decoration-none text-white" href="{{ $url.$elements['first_gov_id'] }}" target="_blank">First Government ID</a>
                                              </button>
                                          </div>
                                          <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                              <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['second_gov_id'] }}">
                                                  <a class="text-decoration-none text-white" href="{{ $url.$elements['second_gov_id'] }}" target="_blank">Second Government ID</a>
                                              </button>
                                          </div>
                                        </div>
<!--                                        <div class="row mt-4">
                                            <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                                <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['intermediate'] }}">
                                                    <a class="text-decoration-none text-white" href="{{ $url.$elements['intermediate'] }}" target="_blank">Intermediate</a>
                                                </button>
                                            </div>
                                            <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                                <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['highSchool'] }}">
                                                    <a class="text-decoration-none text-white" href="{{ $url.$elements['highSchool'] }}" target="_blank">High School</a>
                                                </button>
                                            </div>
                                            <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                                <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['workExp'] }}">
                                                    <a class="text-decoration-none text-white" href="{{ $url.$elements['workExp'] }}" target="_blank">Work Experience</a>
                                                </button>
                                            </div>
                                        </div>-->
                                    @else
                                        <div class="badge badge-warning">Documents have not been submitted yet!</div>
                                    @endif
                                </div>
                            @endif
                        @endif
                    @endif
                </form>
            </div>
        </div>
    </div>
</div>
@endsection