@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Client List</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                        <table class="table table-hover">
                            <thead class="text-dark">
                                <tr>
                                    <th class="text-center" scope="col">S.No.</th>
                                    <th class="text-center" scope="col">Client (Name- Code)</th>
                                    <th class="text-center" scope="col">Contact Person</th>
                                    <th class="text-center" scope="col">Contact Number</th>
                                    <th scope="col" class="text-center">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($clients as $client)
                                    <tr>
                                        <th class="text-center" scope="row">{{ $loop->iteration }}</th>
                                        <td class="text-center">{{ $client->client_name . ' - ' . $client->client_code }}</td>
                                        <td class="text-center">{{ $client->contact_person }}</td>
                                        <td class="text-center">{{ $client->client_number }}</td>
                                        <td class="d-flex justify-content-center">
                                            <?php
                                                $id = isset($client->client_id) ? $client->client_id : '';
                                            ?>
                                            <!-- <a href="{{ url('').'/'.$id }}" class="btn btn-info font-weight-bold mx-2">Generate</a> -->
                                            <form action="{{ url('generate/qr') }}" method="POST">
                                                @csrf
                                                <input type="hidden" name="client_id" value="{{ $client->client_id }}">
                                                <input type="hidden" name="client_code" value="{{ $client->client_code }}">
                                                <input type="submit" value="Generate" class="btn btn-info font-weight-bold mx-2">
                                            </form>
                                            <!-- <a href="{{ url('').'/'.$id }}" class="btn btn-info font-weight-bold mx-2">View</a> -->
                                            <form action="{{ url('client_emp_view_list') }}" method="POST">
                                                @csrf
                                                <input type="hidden" name="client_id" value="{{ $client->client_id }}">
                                                <input type="hidden" name="client_code" value="{{ $client->client_code }}">
                                                <input type="submit" value="View" class="btn btn-info font-weight-bold mx-2">
                                            </form>
                                            <!-- <a href="{{ url('').'/'.$id }}" class="btn btn-info font-weight-bold mx-2">Assign</a> -->
                                            <form action="{{ url('assign_qr_view') }}" method="POST">
                                                @csrf
                                                <input type="hidden" name="client_id" value="{{ $client->client_id }}">
                                                <input type="hidden" name="client_code" value="{{ $client->client_code }}">
                                                <input type="submit" value="Assign" class="btn btn-info font-weight-bold mx-2">
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" align="center">Not Found any</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection