@extends('layouts.masterDashboard')
@section('content')
<div class="row">
  <style>
    a.custom_a span.custom_span{
      max-width: 0;
      font-weight: bold;
      -webkit-transition: max-width .2s;
      transition: max-width .2s;
      display: inline-block;
      vertical-align: top;
      white-space: nowrap;
      overflow: hidden;
    }
    a.custom_a:hover span.custom_span{
      max-width: 7rem;
    }
    td.sorting_1{
        text-align: center !important;
        font-weight: 100;
        font-size: small;
    }
    td.sorting_1 {
        padding: 0px 4px 0px 4px !important;
    }
    .dataTables_wrapper table tr td:nth-child(7) {
        width: 20%;
    }
    tr.emplistheadings {
        font-size: small;
    }
  </style>
  <div class="col-md">
    <div class="card card-user shadow-sm">
      <div class="card-header d-flex justify-content-center border-0 pt-4">
        <h3>Employee List</h3>
      </div>
      <div class="card-body py-1">
        <div class="row mx-4 justify-content-end">
          <a href="{{ url('client/ICount/I-count/add_emp_view') }}" class="btn btn-primary custom_a">
            <i class="fa fa-plus"></i>
            <span class="custom_span">Register Employees</span>
          </a>
        </div>
      </div>
      <div id="pp_table1_admin_dash" class="card-body py-1">
        <!--<div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">-->
        <div class="table-responsive px-2">
<!--                        <table class="table table-hover">
                <thead class="text-dark">
                    <tr>
                        <th class="text-left" scope="col">S.No.</th>
                        <th class="text-left" scope="col">Client Code</th>
                        <th class="text-left" scope="col">Employee Name</th>
                        <th class="text-left" scope="col">Employee Id</th>
                        <th class="text-left" scope="col">Designation</th>
                        <th class="text-left" scope="col">QR Assign Status</th>
                        <th scope="col" class="text-center">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($employees as $employee)
                        <tr>
                            <th class="text-left" scope="row">{{ $loop->iteration }}</th>
                            <td class="text-left">{{ $employee->client_code }}</td>
                            <td class="text-left">{{ $employee->emp_name }}</td>
                            <td class="text-left">{{ $employee->emp_id }}</td>
                            <td class="text-left">{{ $employee->designation }}</td>
                            <td class="text-left">
                                @if($employee->assign_qr_status == "yes")
                                    <span class="badge badge-primary font-weight-light">Assigned</span>
                                @elseif($employee->assign_qr_status == "no")
                                    <span class="badge badge-warning font-weight-light">Not Assigned</span>
                                @endif
                            </td>
                            <td class="d-flex justify-content-start">
                                <form action="{{ url('client/ICount/I-count/edit_emp') }}" method="POST">
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $employee->id }}">
                                    <input type="hidden" name="emp_id" value="{{ $employee->emp_id }}">
                                    <input type="hidden" name="client_id" value="{{ $employee->client_id }}">
                                    <input type="hidden" name="client_code" value="{{ $employee->client_code }}">
                                    <input type="submit" value="Edit" class="btn btn-warning font-weight-bold mx-2">
                                </form>
                                <form action="{{ url('client/ICount/I-count/delete_emp') }}" method="POST">
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $employee->id }}">
                                    <input type="hidden" name="emp_id" value="{{ $employee->emp_id }}">
                                    <input type="hidden" name="client_id" value="{{ $employee->client_id }}">
                                    <input type="hidden" name="client_code" value="{{ $employee->client_code }}">
                                    <input type="submit" value="Delete" class="btn btn-danger font-weight-bold mx-2">
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" align="center">Not Found any</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>-->

          <table id="clientempalllisting" class="table table-striped table-bordered table-responsive" style="width:100%">
            <thead>
              <tr class="emplistheadings">
                <th>S.No.</th>
                <th>Client Code</th>
                <th>Employee Name</th>
                <th>Employee Id</th>
                <th>Designation</th>
                <th>QR Assign Status</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              @forelse($employees as $employee)
              <tr>
                <td class ="sorting_1">{{ $loop->iteration }}</td>
                <td class ="sorting_1">{{ $employee->client_code }}</td>
                <td class ="sorting_1">{{ $employee->emp_name }}</td>
                <td class ="sorting_1">{{ $employee->emp_id }}</td>
                <td class ="sorting_1">{{ $employee->designation }}</td>
                <td>
                  @if($employee->assign_qr_status == "yes")
                  <span class="badge badge-primary font-weight-light">Assigned</span>
                  @elseif($employee->assign_qr_status == "no")
                  <span class="badge badge-warning font-weight-light">Not Assigned</span>
                  @endif
                </td>
                <td>
                    <div class="row">
                        <div class="col-md-4">
                            <form action="{{ url('client/ICount/I-count/edit_emp') }}" method="POST">
                                @csrf
                                <input type="hidden" name="id" value="{{ $employee->id }}">
                                <input type="hidden" name="emp_id" value="{{ $employee->emp_id }}">
                                <input type="hidden" name="client_id" value="{{ $employee->client_id }}">
                                <input type="hidden" name="client_code" value="{{ $employee->client_code }}">
                                <input type="submit" value="Edit" class="btn btn-warning font-weight-bold mx-2">
                            </form>
                        </div>
                        <div class="col-md-4">
                            <form action="{{ url('client/ICount/I-count/delete_emp') }}" method="POST">
                                @csrf
                                <input type="hidden" name="id" value="{{ $employee->id }}">
                                <input type="hidden" name="emp_id" value="{{ $employee->emp_id }}">
                                <input type="hidden" name="client_id" value="{{ $employee->client_id }}">
                                <input type="hidden" name="client_code" value="{{ $employee->client_code }}">
                                <input type="submit" value="Delete" class="btn btn-danger font-weight-bold mx-2">
                            </form>
                        </div>
                    </div>
                </td>
              </tr>
              @empty
              <tr>
                <td colspan="7" align="center">Not Found any</td>
              </tr>
              @endforelse
            </tbody>
          </table>               

        </div>
      </div>
    </div>
  </div>
</div>

@section('customscript')
<link href="{{ asset('public/dataTable/dataTables.bootstrap.min.css') }}" rel="stylesheet">
<!--<link href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css" rel="stylesheet">-->
<script type="text/javascript" src="{{ asset('public/dataTable/jquery.dataTables.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('public/dataTable/jquery-3.5.1.js') }}"></script>
<script>
$(document).ready(function () {
  $.noConflict();
  $('#clientempalllisting').DataTable();
});
</script>
@endsection

@endsection