@extends('layouts.pdfmasterDashboard')
<style>
  body{
    color: #000!important;
  }
  #indEmpPrintable{
    color: #000!important;
  }
  .fksection-li, .fa{
    color: #fff;
  }
  .btn{
    margin: 0px;
    width: 75px;
    font-size: 16px;
    padding: 10px 10px;
    position: relative;
    transition: color 0.15s, background-color 0.15s, border-color 0.15s, box-shadow 0.15s;
    font-size: 0.8rem;
    background-color: #B81F44;
    margin-left: 0.5rem !important;
    margin-right: 0.5rem !important;
    color: #fff;
    cursor: pointer;
  }
  #pdfbtn{
    padding: 12px;
    width: 142px;
    border: 1px solid #B81F44;
    background-color: #B81F44;
    font-size: 16px;
    font-weight: bold;
    color: #fff;
  }
  #pdfbtn:hover{
    border: 1px solid #000;
    background-color: #fff;
    color: #000;
  }
.invoice-box {
        max-width: 1000px;
        margin: auto;
        padding: 30px;
        border: 1px solid #000;
        box-shadow: 0 0 10px rgba(0, 0, 0, .15);
        font-size: 16px;
        line-height: 24px;
        font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
        color: #000;
        background: #fff;
    }
    
    .invoice-box table {
        width: 100%;
        line-height: inherit;
        text-align: left;
    }
    
    .invoice-box table td {
        padding: 5px;
        vertical-align: top;
    }
    .invoice-box .row table tr td:nth-child(1){
        width: 28%;
    }
    .invoice-box .row table td, .invoice-box .row table th{
        padding: 0%;
    }
    
    .invoice-box table tr td:nth-child(3),.invoice-box table tr td:nth-child(4),.invoice-box table tr td:nth-child(5),.invoice-box table tr td:nth-child(6) {
        /*text-align: right;*/
        width: 14%;
    }
    .invoice-box table tr td:nth-child(1),.invoice-box table tr td:nth-child(8){
      width: 8%;
    }
    .invoice-box table tr td:nth-child(2){
      width: 22%;
    }
    .invoice-box table tr.top table td {
        padding-bottom: 20px;
    }
    
    .invoice-box table tr.top table td.title {
        font-size: 45px;
        line-height: 45px;
        color: #333;
    }
    
    .invoice-box table tr.information table td {
        padding-bottom: 40px;
    }
    
    .invoice-box table tr.heading td {
        background: #eee;
        border-bottom: 1px solid #ddd;
        font-weight: bold;
    }
    
    .invoice-box table tr.details td {
        padding-bottom: 20px;
    }
    
    .invoice-box table tr.item td{
        border-bottom: 1px solid #eee;
    }
    
    .invoice-box table tr.item.last td {
        border-bottom: none;
    }
    
    .invoice-box table tr.total td:nth-child(2) {
        border-top: 2px solid #eee;
        font-weight: bold;
    }
    .foot-note {
        max-width: 800px;
        margin: 0 auto;
        padding: 15px;
    }
    @media only screen and (max-width: 600px) {
        .invoice-box table tr.top table td {
            width: 100%;
            display: block;
            text-align: center;
        }
        
        .invoice-box table tr.information table td {
            width: 100%;
            display: block;
            text-align: center;
        }
    }
    
    /** RTL **/
    .rtl {
        direction: rtl;
        font-family: Tahoma, 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
    }
    
    .rtl table {
        text-align: right;
    }
    
    .rtl table tr td:nth-child(2) {
        text-align: left;
    }
    .btn{
        margin: 0px;
        width: 75px;
        font-size: 16px;
        padding: 10px 10px;
        position: relative;
        transition: color 0.15s, background-color 0.15s, border-color 0.15s, box-shadow 0.15s;
        font-size: 0.8rem;
        background-color: #B81F44;
        margin-left: 0.5rem !important;
        margin-right: 0.5rem !important;
        color: #fff;
        cursor: pointer;
    }
    .pdfliH{
      font-weight: bold;
      display: inline-block;
      min-width: 20%;
      width: 30%;
    }
    .table-bordered th, .table-bordered td{
      border:1px soild #000!important;
    }
    .table-bordered{
      border: none;
    }
    .table-bordered th, .table-bordered td {
    border: 1px solid #000!important;
    }
    tbody.allempcalreport {
        font-weight: 400;
        font-size: 0.8rem;
    }
    #indEmpCalTable{
      border-collapse: collapse!important;
    }
    /* ul {
        margin: 0;
        padding: 0;
        list-style: none;
        } */

    /* li {
        display: block;
        white-space: nowrap;
    } */
    /* ul{
        overflow-x: auto;
    } */
    </style>
    
    @section('content')
    <div class="row" style="margin-bottom: 30px;">
      <div class="col-md">
        <a id="pdfbtn" class="btn pdfbtn" onclick="generatePDF()">Export PDF</a>
      </div>
    </div>

<div class="invoice-box" id="indEmpPrintable">
    <h2 style="text-align: center;background-color: #0089ff; font-weight: bold; padding:10px; line-height: 25px; font-size: 25px; margin-bottom: 35px;">Concise Calorie Intake Report</h2>
    <div class="row">    
        <div class="details-list col-md-8">
            <ul style="text-decoration: none; list-style: none; padding:20px 30px; color:#000;">
                <li><span class="pdfliH">Client Name:</span>{{ isset($clientDataPP['clientname']) ? $clientDataPP['clientname'] : ''}}</li>
                <li><span class="pdfliH">Client ID:</span>{{ isset($clientDataPP['username']) ? $clientDataPP['username'] : ''}}</li>
                <li><span class="pdfliH">Vendor Name:</span>{{ isset($vendorDataPP['name']) ? $vendorDataPP['name'] : ''}}</li>
                <li><span class="pdfliH">Vendor ID:</span>{{ isset($vendorDataPP['username']) ? $vendorDataPP['username'] : ''}}</li>
                <li><span class="pdfliH">Location:</span>{{ isset($vendorDataPP['address']) ? $vendorDataPP['address'] : ''}}</li>
                <li><span class="pdfliH">Report Period:</span>{{ isset($date_from) ? date('d/m/Y', strtotime($date_from)) : '' }}&nbsp;-&nbsp;{{ isset($date_to) ? date('d/m/Y', strtotime($date_to)) : '' }}</li>
                <li><span class="pdfliH">Report Date:</span>{{ date('d/m/Y') }}</li>
            </ul>
        </div>
        <div class="col-md-4">
            <table class="table table-bordered table-responsive" style="width:100%">
                <tr style="text-align-last: center">
                    <th colspan=4>BMI Color Glossary</th>    
                </tr>
                <tr>
                    <td height="3%" >Under Weight (U.W.)</td>
                    <td height="3%" style="text-align-last: center">
                        <div style= "background-color: #1b8bcf; border-radius: 0.2rem; width:100%">
                            &lt; 18.5
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>Normal Weight (N.W.)</td>
                    <td style="text-align-last: center">
                        <div style= "background-color: #46C20C; border-radius: 0.2rem; width:100%">
                            &ge; 18.5 & &le; 24.9
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>Overweight (O.W.)</td>
                    <td style="text-align-last: center">
                        <div style= "background-color: #F57C1E; border-radius: 0.2rem; width:100%">
                            &ge; 25.0 & &le; 29.9
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>Obese(OB.)</td>
                    <td style="text-align-last: center">
                        <div style= "background-color: #D11503; border-radius: 0.2rem; width:100%">
                            &ge; 30.0
                        </div>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <!--  <table cellpadding="0" cellspacing="0">
        <tr class="heading">
        <td>S.No.</td>
        <td>Date</td>
        <td>Breakfast</td>
        <td>Lunch</td>
        <td>Dinner</td>
        <td>Others</td>
        <td>Total Calories</td>
        </tr>

    @php $subtotal_cal = 0 @endphp
    @foreach($report_data as $key => $data)
    @php $total_cal = 0 @endphp
    <tr class="item">
      <td>{{ ++$key }}</td>
      <td>{{ date('m/d/Y', strtotime($data->created_at)) }}</td>
      <td>
        @if($data->meal_type == 'breakfast')
        @php $total_cal = $total_cal + $data->item_approx_calorie @endphp
        {{ $data->item_name }} ({{ $data->item_approx_calorie }} calories)
        @else
        -
        @endif
      </td>
      <td>
        @if($data->meal_type == 'lunch')
        @php $total_cal = $total_cal + $data->item_approx_calorie @endphp
        {{ $data->item_name }} ({{ $data->item_approx_calorie }} calories)
        @else
        -
        @endif
      </td>
      <td>
        @if($data->meal_type == 'dinner')
        @php $total_cal = $total_cal + $data->item_approx_calorie @endphp
        {{ $data->item_name }} ({{ $data->item_approx_calorie }} calories)
        @else
        -
        @endif
      </td>
      <td>
        -
      </td>
      <td>
        @php $subtotal_cal = $subtotal_cal + $total_cal @endphp
        {{ $total_cal}} calories (approx)
      </td>
    </tr>
    @endforeach


    <tr class="total">
      <td>Total</td>
      <td>
        @php
        $datetime1 = new DateTime($date_from);
        $datetime2 = new DateTime($date_to);
        $interval = $datetime1->diff($datetime2);
        $days = $interval->format('%a');
        @endphp
        {{ $days }} day(s)
      </td>
      <td></td>
      <td></td>
      <td></td>
      <td></td>
      <td>{{ $subtotal_cal }} calories</td>
    </tr>
  </table>-->


  <table id="indEmpCalTable" class="table table-striped table-bordered table-responsive" style="width:100%">
    <thead>
      <tr class = "allempcalreport">
        <th>S.No.</th>
        <!-- <th>Date</th> -->
        <th>Employee Name/Employee Id</th>
        <!--<th>Employee Id</th>-->
        <th>Breakfast</th>
        <th>Lunch</th>
        <th>Dinner</th>
        <th>Others</th>
        <th>Total Calories</th>
        <th>BMI</th>
      </tr>
    </thead>
    <tbody class = "allempcalreport">
      @php $subtotal_cal = 0 @endphp
      @foreach($report_data as $key => $data)
      @php $total_cal = 0 @endphp
      @php $ApproxCalbreakfast = 0 @endphp
      @php $ApproxCallunch = 0 @endphp
      @php $ApproxCaldinner = 0 @endphp
      @php $ApproxCalothers = 0 @endphp
      <tr class="item">
        <td>{{ ++$key }}</td>
        <!-- @php<td>{{ date('d/m/Y', strtotime($data->created_at)) }}</td>@endphp -->
        <!-- <td>{{ date('d/m/Y', strtotime($data->date)) }}</td> -->
        <td>{{ $data->employee->emp_name }} / {{ $data->employee->emp_id }}</td>
        <!--<td>{{ $data->employee->emp_id }}</td>-->
        <td>
            @if($data->breakfast!='')
                <!-- {{trim($data->breakfast,", ")}} -->
                {{$data->sum_breakfast }}(calories)
                <!-- @php 
                $ApproxCalbreakfast = $data->item_quantity*$data->item_approx_calorie;
                $total_cal = $total_cal + $ApproxCalbreakfast; 
                @endphp -->
            @else
            -
            @endif
        </td>
        <td>
            @if($data->lunch!='')
                <!-- {{trim($data->lunch,", ")}} -->
                {{$data->sum_lunch }}(calories)
                <!--@php 
                $ApproxCallunch = $data->item_quantity*$data->item_approx_calorie;
                $total_cal = $total_cal + $ApproxCallunch; @endphp -->
            @else
            -
            @endif
        </td>
        <td>
            @if($data->dinner!='')
                <!-- {{trim($data->dinner,", ")}} -->
                {{$data->sum_dinner }}(calories)
                <!-- @php 
                $ApproxCaldinner = $data->item_quantity*$data->item_approx_calorie;
                $total_cal = $total_cal + $ApproxCaldinner; @endphp -->
            @else
            -
            @endif
        </td>
        <td>
            @if($data->others!='')
                <!-- {{trim($data->others,", ")}} -->
                {{$data->sum_others }}(calories)
                <!--@php  
               $ApproxCalothers = $data->item_quantity*$data->item_approx_calorie;
               $total_cal = $total_cal + $ApproxCalothers;@endphp -->
            @else
            -
            @endif
        </td>
        <td style="font-weight: 600;">
            {{$data->sum_breakfast + $data->sum_lunch + $data->sum_dinner + $data->sum_others}} calories (approx)
            @php $subtotal_cal = $subtotal_cal + $data->sum_breakfast + $data->sum_lunch + $data->sum_dinner + $data->sum_others @endphp
          <!-- @php $subtotal_cal = $subtotal_cal + $total_cal
         @endphp -->
        </td>
        <td style="text-align-last: center;">
            @if($data->employee->emp_height!=''|| $data->employee->emp_weight!='')
                @php $bmi =  $data->employee->emp_height== null || $data->employee->emp_weight == null ? '-' : round($data->employee->emp_weight/(($data->employee->emp_height/100) *($data->employee->emp_height/100)),2);
                    $bg_color = $bmi=='-'?'':($bmi<=18.4?"#1b8bcf":($bmi>18.4&&$bmi<=24.9?"#46C20C":($bmi>=25&&$bmi<=29.9?"#F57C1E":"#D11503"))); @endphp
                    <div style= "background-color:<?php echo $bg_color?>; border-radius: 0.2rem; width:100%">
                        {{ $bmi }}
                    </div>
                    <!-- {{trim($data->others,", ")}} -->
                    <!--@php  
                    $ApproxCalothers = $data->item_quantity*$data->item_approx_calorie;
                    $total_cal = $total_cal + $ApproxCalothers;@endphp -->
            @else
                -
            @endif
        </td>
      </tr>
      @endforeach
    </tbody>
    <tfoot>
      <tr>
        <th>Total</th>
        <th>
        @php
        $datetime1 = new DateTime($date_from);
        $datetime2 = new DateTime($date_to);
        $interval = $datetime1->diff($datetime2);
        $days = $interval->format('%a');
        $days = $days + 1;
        @endphp
        {{ $days }} day(s)
        </th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
<!--        <th></th>
        <th></th>-->
        <th>{{ $subtotal_cal }} calories</th>
        <th></th>
      </tr>
    </tfoot>
  </table>

  <div class="foot-note">
    <span>*calories intake is approximate in no.</span><br>
    <span><strong>Note:</strong> average calories intake for a man and woman per day should be approx 2500 calories and 2000 calories respectively.</span>
  </div>
  
</div>


@section('customscript')
<link href="{{ asset('public/dataTable/dataTables.bootstrap.min.css') }}" rel="stylesheet">
<script type="text/javascript" src="{{ asset('public/dataTable/jquery.dataTables.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('public/dataTable/jquery-3.5.1.js') }}"></script>

<script type="text/javascript" src="{{ asset('public/js/html2pdf.bundle.min.js') }}"></script>

<script>
      $(document).ready(function () {
        $.noConflict();
        $('#table1DinningClientList').DataTable();
      });
</script>
    <script type="text/javascript">
        function generatePDF() {
            // Choose the element that our invoice is rendered in.
            //example_filter
            $("#indEmpCalTable_filter").hide();
            const element = document.getElementById("indEmpPrintable");
            // Choose the element and save the PDF for our user.
//            html2pdf()
//              .from(element)
//              .save();
            html2pdf(element, {
              margin:       10.5,
              filename:     'Concise-Calorie-Intake-Report.pdf',
              image:        { type: 'jpeg', quality: 0.98 },
              html2canvas:  { scale: 2, logging: true, dpi: 192, letterRendering: true },
              jsPDF:        { unit: 'mm', format: 'a4', orientation: 'landscape' },
              pagebreak:    { avoid: 'tr'}
            });
        }
        
        $(document).ready(function() {
          $('#indEmpCalTable').DataTable( {
            "paging":   false
//            "ordering": false,
//            "info":     false
          } );
        } );
    </script>
@endsection

@endsection
