@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>Events</h3>
                </div>
                <div class="card-body py-0">
                    @if(isset($events) && !isset($type))
                        <div class="row d-flex justify-content-around">
                            <a class="{{ isset($events) ? 'carrot' : 'peterriver' }} w-auto text-decoration-none text-white" href="{{ url('client/existing/event') }}">Existing Events</a>
                            <a class="{{ !isset($events) ? 'carrot' : 'peterriver' }} w-auto text-decoration-none text-white" href="{{ url('client/book/event') }}">Book Event</a>
                        </div>
                    @endif
                    @if(isset($events))
                        <div class="table-responsive p-2" style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-hover">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-center" scope="col">S.No.</th> 
                                        <th class="text-center" scope="col">Event Name</th> 
                                        <th class="text-center" scope="col">Guest Number</th>
                                        <th scope="col" class="d-flex justify-content-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($events as $key => $event)
                                        <tr>
                                            <td class="text-center" scope="row">{{ ++$key }}</td>
                                            <td class="text-center">{{ $event->type_of_event }}</td>
                                            <td class="text-center">{{ $event->guest_number }}</td>
                                            <td class="d-flex justify-content-center">
                                                <?php
                                                    $url = url('client/event');
                                                ?>
                                                <a href="{{ $url . '/view/' . $event->id }}" class="peterriver text-decoration-none text-white py-0">View</a>
                                                <a href="{{ $url . '/edit/' . $event->id }}" class="sunflower text-decoration-none text-white py-0">Edit</a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" align="center">No Events Booked Yet!</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @elseif(!isset($events))
                        <form method="POST" action="{{ url('client/book/event') }}" class="rounded my-4 mx-2" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label for="reservation_date">Date of Event</label>
                                        <div class="input-group p-0 shadow-sm datepicker date">
                                            <input class="form-control shadow-sm" id="reservation_date" type="text" name="reservation_date" placeholder="Choose a reservation date" autocomplete="off" required />
                                            <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="form-group">
                                        <label for="guest_num">Number of PAX</label>
                                        <input id="guest_num" type="tel" pattern="[0-9]+" data-toggle="tooltip" title="Number of Guests( In Numbers Only )" class="form-control shadow-sm" name="guest_num" autocomplete="off" value="" required />
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="form-group">
                                        <label for="per_plate">Rates Per Plate</label>
                                        <input id="per_plate" type="tel" pattern="[0-9]+" data-toggle="tooltip" title="Rates Per Plate( In Numbers Only )" class="form-control shadow-sm" name="per_plate" autocomplete="off" value="{{ (isset($type) && $type == 'edit') ? $eventDetail['ratePerPlate'] : '' }}" required />
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="plate_rate">Type of Event</label>
                                        <select class="form-control" name="event_type" id="event_type" required>
                                            <option value="">Select Event Type</option>
                                            <option value="indoorThemeEvent">Indoor Theme Event</option>
                                            <option value="outdoorThemeEvent">Outdoor Theme Event</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="description">Description</label>
                                        <textarea name="description" id="description" class="form-control"></textarea>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <p>Suggestive Menu</p>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="menu_suggest" name="menu_suggest" accept=".doc, .pdf">
                                            <label class="custom-file-label" for="menu_suggest">Any Menu Suggestion</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <h5 class="text-center d-flex justify-content-center">
                                            <span class="border-bottom">Decoration needed</span>
                                        </h5>
                                        <div class="d-flex justify-content-around flex-wrap">
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="event_decoration" value="yes" />
                                                <span>Yes</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="event_decoration" value="no"/>
                                                <span>No</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <h5 class="d-flex justify-content-center">
                                            <span class="border-bottom">Cutlery & Crockery needed</span>
                                        </h5>
                                        <div class="d-flex justify-content-around flex-wrap">
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="cultry_crockery" value="yes" />
                                                <span>Yes</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="cultry_crockery" value="no"/>
                                                <span>No</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="update ml-auto mr-auto">
                                    <button type="submit" class="turquoise w-auto" style="padding: .4rem 1rem;font-size: 1rem;">Book Now</button>
                                </div>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection