@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>Edit Event</h3>
                </div>
                <div class="card-body py-0">
                    @if((isset($event) && !empty($event)) && (isset($type) && $type == 'edit'))
                        <form method="POST" action="{{ url('client/editevent') }}" class="rounded my-4 mx-2">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="ticket" value="{{ $event->event_ticket }}" />
                            <?php
                                // dd($event);
                            ?>
                            <div class="row">
                                <div class="col-md-4 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <label for="reservationDate">Date of Event</label>
                                        <div class="input-group p-0 shadow-sm datepicker date">
                                            <input class="form-control shadow-sm" id="reservationDate" type="text" name="reservation_date" value="{{ date('d/m/Y', $event->event_date) }}" placeholder="Choose a reservation date" autocomplete="off" required />
                                            <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="guest_num">Number of PAX</label>
                                        <input type="text" name="guest_num" id="guest_num" class="form-control" value="{{ $event->guest_number }}" />
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="per_plate">Rates Per Plate</label>
                                        <input class="form-control shadow-sm" name="per_plate" id="per_plate" value="{{ $event->rate_per_plate }}" />
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="plate_rate">Type of Event</label>
                                        <select class="form-control" name="event_type" id="event_type" required>
                                            <option value="{{ $event->type_of_event }}">{{ $event->type_of_event }}</option>
                                            <option value="indoorThemeEvent">Indoor Theme Event</option>
                                            <option value="outdoorThemeEvent">Outdoor Theme Event</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="description">Description</label>
                                        <textarea name="description" id="description" class="form-control" value="{{ $event->description }}">{{ $event->description }}</textarea>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <p>Suggestive Menu</p>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="menu_suggest" name="menu_suggest" accept=".doc, .pdf">
                                            <label class="custom-file-label" for="menu_suggest">Any Menu Suggestion</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <h5 class="text-center d-flex justify-content-center"><span class="border-bottom">Decoration needed</span></h5>
                                        <div class="d-flex justify-content-around flex-wrap">
                                            <?php
                                                $decoration = isset($event->decoration_needed) && !empty($event->decoration_needed);
                                            ?>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="event_decoration" value="yes" <?php echo (!isset($event->decoration_needed) && empty($event->decoration_needed)) ? "" : ($event->decoration_needed == "yes" ? "checked" : '') ?> />
                                                <span>Yes</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="event_decoration" value="no" <?php echo (!isset($event->decoration_needed) && empty($event->decoration_needed)) ? "" : ($event->decoration_needed == "no" ? "checked" : '') ?> />
                                                <span>No</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <h5 class="d-flex justify-content-center">
                                            <span class="border-bottom">Cutlery & Crockery needed</span>
                                        </h5>
                                        <div class="d-flex justify-content-around flex-wrap">
                                            <?php
                                                $cultery = isset($event->cultry_crockery) && !empty($event->cultry_crockery);
                                            ?>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="cultry_crockery" value="yes" <?php echo (!isset($event->cultry_crockery) && empty($event->cultry_crockery)) ? "" : ($event->cultry_crockery == "yes" ? ($type == "view" ? "checked disabled" : "checked") : ($type == "edit" ? "" : "disabled")) ?> />
                                                <span>Yes</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="cultry_crockery" value="no" <?php echo (!isset($event->cultry_crockery) && empty($event->cultry_crockery)) ? "" : ($event->cultry_crockery == "no" ? ($type == "view" ? "checked disabled" : "checked") : ($type == "edit" ? "" : "disabled")) ?> />
                                                <span>No</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @if(isset($type) && $type == 'edit')
                                <div class="row d-flex justify-content-center">
                                    <div class="update">
                                        <button type="submit" class="sunflower w-100 font-weight-bold" style="font-size: medium;padding: 0.4rem 1.4rem;">Update</button>
                                    </div>
                                </div>
                            @endif
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection