@extends('layouts.masterDashboard')
@section('content')
<div class="row">
    <style>
        .peterriver{
            width: 120px;
        }  
        a.custom_a span.custom_span {
            max-width: 0;
            font-weight: bold;
            -webkit-transition: max-width .2s;
            transition: max-width .2s;
            display: inline-block;
            vertical-align: top;
            white-space: nowrap;
            overflow: hidden;
        }

        a.custom_a:hover span.custom_span {
            max-width: 7rem;
        }
    </style>
    <div class="col-md">
        <div class="card card-user shadow-sm">
            <div class="card-header d-flex justify-content-center border-0 pt-4">
                <h3>vendor Camera Feeds List</h3>
            </div>
            <div id="pp_table1_admin_dash" class="card-body py-1">
                <div class="table-responsive px-2">

                    <table id="example" class="table table-striped table-bordered" style="width:100%">
                        <thead>
                            <tr>
                                <th id="sort">Id</th>
                                <th>Vendor Id</th>
                                <th>Camera Id</th>
                                <th>AI Feed Type</th>
                                <th>Camera Location</th>
                                <th>Image</th>
                                <th>Video</th>
                            </tr>
                        </thead>
                        <tbody>
                           
                            @foreach ( $feeds as $feed )
                                <tr>
                                    <td>{{ $feed->id }}</td>
                                    <td>{{ $feed->vendorId }}</td>
                                    <td>{{ $feed->cameraId }}</td>
                                    <td>{{ $feed->ai_Feed_Type}}</td>
                                    <td>{{ $feed->cameraLocation }}</td>
                                    <td>
                                        <a href="{{ asset($feed->imageLink) }}" target="_blank">
                                            <img src="{{ asset($feed->imageLink)}}" alt="image" height="50" width="100">
                                        </a>
                                    </td>
                                    <td>
                                        <a href="{{ asset($feed->videoLink) }}" target="_blank">
                                            <video width="100" height="50" controls>   
                                                <source src="{{ asset($feed->videoLink) }}" type="video/mp4">  
                                                Your browser does not support the video tag. 
                                            </video> 
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                           
                            <!-- -->

                    </table>

                </div>
            </div>
        </div>
    </div>
</div>

@section('customscript')
<link href="{{ asset('public/dataTable/dataTables.bootstrap.min.css') }}" rel="stylesheet">
<!--<link href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css" rel="stylesheet">-->
<script type="text/javascript" src="{{ asset('public/dataTable/jquery.dataTables.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('public/dataTable/jquery-3.5.1.js') }}"></script>
<script>
    $(document).ready(function() {
        $.noConflict();
        $('#example').DataTable();
        $('#sort').trigger("click");
    });
</script>
@endsection

@endsection