<?php

Route::group(['module' => 'Admin', 'middleware' => ['web', 'auth', 'role:admin'], 'namespace' => 'App\Modules\Admin\Controllers'], function() {

    Route::resource('admin', 'AdminController');

    Route::get('listAll/{role}/{search?}', 'AdminController@list_roles');
    Route::get('create/{role}', 'AdminController@create');
    Route::post('create', 'AdminController@register');
    Route::delete('deleteRole/{id}', 'AdminController@deleteSpecificRole');
    Route::get('viewOrEditRole/{type}/{id}', 'AdminController@viewOrEditSpecificRole');
    Route::any('editRole', 'AdminController@updateSpecificRole');

    Route::get('mapTableForm/{roleType?}/{search?}', 'AdminController@giveMapDetails');
    Route::post('mapTableForm', 'AdminController@takeMapDetails');
    Route::get('existingMap/{roleType?}/{roleId?}', 'AdminController@existingMappingDetails');
    Route::get('mapped_roles/{roleType}/{search?}', 'AdminController@map_details');

    Route::any('client/event/assign', 'AdminController@updateEventByAssign');
    Route::get('events/{type}/{eventId?}/{vendorId?}', 'AdminController@eventList');

    Route::get('all/concern', 'AdminController@allConcerns');
    Route::get('view/concern/{id}', 'AdminController@concernDetail');
    Route::get('change/concern/{id}', 'AdminController@changeStatus');
    Route::post('message/concern', 'AdminController@concernMessageInput');

    Route::get('all/notifications', 'AdminController@notifications');
    Route::get('notification/event/{id}', 'AdminController@eventNotification');

    Route::get('download/{format}/{role?}', 'AdminController@download_as_report');

    Route::get('reports', 'AdminController@reports');
    Route::get('reports/concern/{id}', 'AdminController@report_concern');
    
    //Client Agreement End Date Notification Cron Function
    Route::any('clientAgreementEndNotify', 'AdminController@clientAgreementEndNotify');
    
    //Vendor Document End Date Notification Cron Function
    Route::any('vendorDocEndNotify', 'AdminController@vendorDocEndNotify');
    
    //AI Feeds
    Route::any('allClientsAIFeeds/{role}/{search?}', 'AdminController@adminAIFeedsAllClient');
    Route::get('viewAIFeedVendor/{type}/{id}', 'AdminController@viewAIFeedVendor');
    Route::get('viewAIVendorCamera/view/{id}', 'AdminController@viewAIVendorCameras');
    Route::get('viewaifeeds/{id}', 'AdminController@viewAIFeedsCameras');

});


Route::group(['module' => 'Admin', 'prefix' => 'ICount/I-count', 'middleware' => ['web', 'auth', 'role:admin'], 'namespace' => 'App\Modules\Admin\Controllers'], function() {

    // Route::get('new_qr/client_list', 'AdminController@new_qr_client_list');
    Route::get('new_qr/client_list/{search?}', 'AdminController@new_qr_client_list');
    Route::get('old_qr/client_list/{search?}', 'AdminController@old_qr_client_list');

    Route::post('generate/qr', 'AdminController@generate_qr');
    Route::post('generate_qr_code', 'AdminController@qr_code_generator');
    Route::post('assign_qr_view', 'AdminController@assign_qr_view');
    Route::get('give_qr_type_detail/{qr_type?}/{client_code?}', 'AdminController@give_qr_type_detail');
    Route::post('assign_qr', 'AdminController@assign_qr');

    Route::match(['get', 'post'], 'client_emp_view_list/{search?}', 'AdminController@client_emp_view_list');
    
    //QR Code type 4 Employee
    Route::match(['get', 'post'], 'client_emp_type4_view_list/{search?}', 'AdminController@client_emp_type4_view_list');
    
    Route::post('client_emp_edit_list', 'AdminController@client_emp_edit_list');
    Route::post('client_emp_cal_report', 'AdminController@client_emp_cal_report');
    Route::post('emp_cal_report', 'AdminController@getEmpCalReport');
    Route::post('client_all_emp_cal_report', 'AdminController@client_all_emp_cal_report');
    Route::post('client_employees_cal', 'AdminController@getClientEmployeesCal');
    Route::post('client_emp_update_list', 'AdminController@client_emp_update_list');
    Route::any('client_emp_delete_pre', 'AdminController@client_emp_delete_pre');
    Route::post('client_emp_delete', 'AdminController@client_emp_delete');
    Route::get('success_qr_generate/{client_code}', 'AdminController@success_qr_generate');
    Route::post('client_all_qr_code', 'AdminController@client_all_qr_code');

    Route::get('invoice/{search?}', 'AdminController@invoice');
    Route::match(['get', 'post'], 'generate_invoice', 'AdminController@generate_invoice');
    Route::post('create_invoice', 'AdminController@create_invoice');
    Route::get('view_invoice', 'AdminController@view_invoice');
    Route::post('export_invoice', 'AdminController@export_invoice');
    
    //Generate Reports
    Route::get('allreport/{search?}', 'AdminController@allreport');
    Route::match(['get', 'post'], 'generate_report', 'AdminController@generate_report');
    Route::post('create_report', 'AdminController@create_report');
    Route::get('view_report', 'AdminController@view_report');
    Route::post('export_report', 'AdminController@export_report');
    
    //Generate Dinning Reports
    Route::get('alldiningreport/{search?}', 'AdminController@alldiningreport');
    Route::match(['get', 'post'], 'generate_dinning_report', 'AdminController@dining_generate_report');
    Route::post('create_report', 'AdminController@dining_create_report');
    Route::get('view_report', 'AdminController@dining_view_report');
    Route::post('export_report', 'AdminController@dining_export_report');
    
    //Generate Dining Sale Reports
    Route::get('alldiningsalereport/{search?}', 'AdminController@alldiningsalereport');
    Route::match(['get', 'post'], 'generate_diningsale_report', 'AdminController@generate_diningsale_report');
    Route::post('create_diningsale_report', 'AdminController@create_diningsale_report');
    Route::get('view_diningsale_report', 'AdminController@view_diningsale_report');
    Route::post('export_diningsale_report', 'AdminController@export_diningsale_report');
    
    //See all QR code
    Route::get('allqrclient/{search?}', 'AdminController@allqrclient');
    
    //Dine In Calorie Report
    Route::get('dinein/client_list/{search?}', 'AdminController@allDineInReport');
    
    //Employee Wise Dine In Sale Report
    Route::get('dinein/salereport/client_list/{search?}', 'AdminController@saleDineInReportEmpWise');
    Route::match(['get', 'post'], 'empClientSaleReport/{search?}', 'AdminController@empClientSaleReport');
    Route::post('client_emp_sale_report', 'AdminController@client_emp_sale_report');
    Route::match(['get', 'post'], 'generate_emp_diningsale_report', 'AdminController@generate_emp_diningsale_report');
    
});
