<input id="foodscraftRole" type="hidden" name="foodscraftRole" value="{{ isset($result['foodscraftRole']) ? $result['foodscraftRole'] : $roleType }}" />
<input type="hidden" name="address" id="address" value="default" />
<div class="row">
    <div class="col-md-4 col-sm-12 pr-md-1">
        <div class="form-group">
            <label for="siteassigned">Designated Area</label>
            <input id="siteassigned" type="text" class="form-control" pattern="[a-zA-Z ]+" data-toggle="tooltip" title="Text Only" placeholder="Location name" name="siteassigned" value="{{ isset($result['siteAssigned']) ? $result['siteAssigned'] : old('siteassigned') }}" <?php echo !isset($result['siteAssigned']) && empty($result['siteAssigned']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
        </div>
    </div>
    <div class="col-md-4 col-sm-12 px-md-1">
        <div class="form-group">
            <label for="govId">2 Government ID</label>
            <span class="required-field">*</span>
            <input id="govId" type="text" class="form-control" name="govId" value="{{ isset($result['govId']) ? $result['govId'] : old('govId') }}" required <?php echo !isset($result['govId']) && empty($result['govId']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
        </div>
    </div>
    <div class="col-md-4 col-sm-12 pl-md-1">
        <div class="form-group">
            <label for="yearExp">Years of experience</label>
            <input id="yearExp" type="text" class="form-control" pattern="^[1-9]{1|2}$" data-toggle="tooltip" title="Max 2 Digits Only" name="yearExp" value="{{ isset($result['expInYrs']) ? $result['expInYrs'] : old('yearExp') }}" <?php echo !isset($result['expInYrs']) && empty($result['expInYrs']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
        </div>
    </div>
</div>

@if(isset($type) && $type == "view" && isset($listMapfirstdata) && isset($listMapseconddata))
    <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <h5 class="text-center d-flex justify-content-center">
                    <span class="border-bottom-span border-bottom">Mapped Client List</span>
                </h5>
                <div class="card-body">
                    <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                        <table class="table table-hover">
                            <thead class="text-dark">
                                <tr>
                                    <th class="text-left" scope="col">S.No.</th> 
                                    <th class="text-left" scope="col">Name</th>
                                    <th class="text-left" scope="col">Client Code</th>
                                    <th class="text-left" scope="col">Contact Number</th>
                                    <th class="text-left" scope="col">Address</th>
                                    <th class="text-left" scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($listMapseconddata as $key=>$value)
                                    <tr>
                                        <th class="text-left" scope="row">{{ ++$key }}</th>
                                        <td class="text-left">{{ $value[0]['name'] }}</td>
                                        <td class="text-left">{{ $value[0]['username'] }}</td>
                                        <td class="text-left">{{ $value[0]['contactNumber'] }}</td>
                                        <td class="text-left">{{ $value[0]['address'] }}</td>
                                        <td class="d-flex">
                                            <div class="peterriver" onclick="viewOrEdit('{{ url('viewOrEditRole') }}', 'view', '{{ $value[0]['clientId'] }}');">View</div> 
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" align="center" class="tablemotfounditem">Not Found any</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <h5 class="text-center d-flex justify-content-center">
                    <span class="border-bottom-span border-bottom">Mapped Vendor List</span>
                </h5>
                <div class="card-body">
                    <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                        <table class="table table-hover">
                            <thead class="text-dark">
                                <tr>
                                    <th class="text-left" scope="col">S.No.</th> 
                                    <th class="text-left" scope="col">Name</th>
                                    <th class="text-left" scope="col">Vendor Code</th>
                                    <th class="text-left" scope="col">Contact Number</th>
                                    <th class="text-left" scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($listMapfirstdata as $key=>$value)
                                    <tr>
                                        <th class="text-left" scope="row">{{ ++$key }}</th>
                                        <td class="text-left">{{ $value[0]['name'] }}</td>
                                        <td class="text-left">{{ $value[0]['username'] }}</td>
                                        <td class="text-left">{{ $value[0]['contactNumber'] }}</td>
                                        <td class="d-flex">
                                            <div class="peterriver" onclick="viewOrEdit('{{ url('viewOrEditRole') }}', 'view', '{{ $value[0]['vendorId'] }}');">View</div> 
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" align="center" class="tablemotfounditem">Not Found any</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif