@extends('layouts.masterDashboard')
@section('content')
<?php
    $roleName = isset($result['foodscraftRole']) && !empty($result['foodscraftRole']) ? strtolower($result['foodscraftRole']) : (isset($roleType) && !empty($roleType) ? strtolower($roleType) : '');
    // dd($result, $roleName);
?>
<div class="row">
    <div class="col-md-12">
        <div class="main-card mb-3 card">
            <div class="card-header p-2">
                <h3 class="w-100 text-center">REGISTER</h3>
            </div>
            <div class="card-body">
                <form class="fkformlabel">
                    <input type="hidden" name="id" value="{{ isset($result['marshalId']) ? $result['marshalId'] : null }}" />
                    <input id="foodscraftRole" type="hidden" name="foodscraftRole" value="SiteMarshal" />
                    <input type="hidden" name="address" id="address" value="default" />
                    
                    @if($roleName == "sitemarshal" && isset($type) && $type == "view")
                    @if(isset($result['documents']) && !empty($result['documents']))
                    <?php
                      $url = asset('public/storage/documents/marshals') . '/' . $result['marshalId'] . '/';
                      $elements = $result['documents'][0];
                    ?>
                      <?php
                          $picture = $result['assignedSite'] !== 'default_foodscraft.png' ? asset('public/storage/avatars/marshals') . '/' . $result['marshalId'] . '/' . $result['assignedSite'] : asset('public/images/default_foodscraft.png');
                      ?>
                    
                      <div class="row px-3">
                          <img class="rounded" width="200" height="100" src="{{ $url.$elements['pro_pic'] }}" alt="Profile Picture" />
                      </div>
                    @endif
                    @endif
                    <br/>
                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="name">Name</label>
                                <span class="required-field">*</span>
                                <input
                                    type="text"
                                    id="name"
                                    class="form-control"
                                    autocomplete="off"
                                    name="name"
                                    value="{{ isset($result['name']) ? $result['name'] : null }}"
                                    readonly
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="username">Employee ID</label>
                                <span class="required-field">*</span>
                                <input
                                    type="text"
                                    id="username"
                                    class="form-control"
                                    autocomplete="off"
                                    name="username"
                                    value="{{ isset($result['username']) ? $result['username'] : null }}"
                                    readonly
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="email">Email address</label>
                                <span class="required-field">*</span>
                                <input
                                    type="email"
                                    id="email"
                                    class="form-control"
                                    name="email"
                                    autocomplete="off"
                                    value="{{ isset($result['email']) ? $result['email'] : null }}"
                                    readonly
                                />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="designation">Designation</label>
                                <span class="required-field">*</span>
                                <select class="form-control" name="designation" id="designation" disabled>
                                    <option value="{{ isset($result['designation']) && !empty($result['designation']) ? $result['designation'] : 'Select' }}">{{ isset($result['designation']) && !empty($result['designation']) ? $result['designation'] : 'Select' }}</option>
                                    <option value="sitemarshall">Site Marshall</option>
                                    <option value="sitemanager">Site Manager</option>
                                    <option value="zonemanager">Zone Manager</option>
                                    <option value="areamanager">Area Manager</option>
                                    <option value="countryhead">Country Head</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="keyresponsibilities">Key Responsibilities</label>
                                <span class="required-field">*</span>
                                <select class="form-control" name="keyresponsibilities" id="keyresponsibilities" disabled>
                                    <option value="{{ isset($result['keyresponsibilities']) && !empty($result['keyresponsibilities']) ? $result['keyresponsibilities'] : 'Select' }}">{{ isset($result['keyresponsibilities']) && !empty($result['keyresponsibilities']) ? $result['keyresponsibilities'] : 'Select' }}</option>
                                    <option value="marketing">Marketing</option>
                                    <option value="sales">Sales</option>
                                    <option value="bd">BD</option>
                                    <option value="kitchenoperations">Kitchen Operations</option>
                                    <option value="newclientcatererexpansion">New Client + Caterer Expansion</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="contactNumber">Mobile number</label>
                                <span class="required-field">*</span>
                                <input
                                    id="contactNumber"
                                    type="tel"
                                    pattern="^[0-9]{10}$"
                                    data-toggle="tooltip"
                                    title="10 Digit Mobile Number Only"
                                    class="form-control"
                                    name="contactNumber"
                                    autocomplete="off"
                                    value="{{ isset($result['contactNumber']) ? $result['contactNumber'] : null }}"
                                    readonly
                                />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="siteassigned">Designated Area</label>
                                <input
                                    id="siteassigned"
                                    type="text"
                                    class="form-control"
                                    pattern="[a-zA-Z ]+"
                                    data-toggle="tooltip"
                                    title="Text Only"
                                    placeholder="Location name"
                                    name="siteassigned"
                                    value="{{ isset($result['siteAssigned']) ? $result['siteAssigned'] : null }}"
                                    readonly
                                />
                            </div>
                        </div>
<!--                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="govId">2 Government ID</label>
                                <span class="required-field">*</span>
                                <input
                                    id="govId"
                                    type="text"
                                    class="form-control"
                                    name="govId"
                                    value="{{ isset($result['govId']) ? $result['govId'] : null }}"
                                    readonly
                                />
                            </div>
                        </div>-->
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="yearExp">Years of experience</label>
                                <input
                                    id="yearExp"
                                    type="text"
                                    class="form-control"
                                    pattern="^[1-9]{1|2}$"
                                    data-toggle="tooltip"
                                    title="Max 2 Digits Only"
                                    name="yearExp"
                                    value="{{ isset($result['expInYrs']) ? $result['expInYrs'] : null }}"
                                    readonly
                                />
                            </div>
                        </div>
                    </div>
                    
                    @if(isset($result) && $type == "view")
                    
                      <div class="mb-4 p-1 {{ isset($result['documents']) && !empty($result['documents']) ? '' : 'd-flex justify-content-center' }}">
                        @if(isset($result['documents']) && !empty($result['documents']))
                            <?php
                                $url = asset('public/storage/documents/marshals') . '/' . $result['marshalId'] . '/';
                                $elements = $result['documents'][0];
                            ?>
                            <div class="row mb-4">
                                <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['resume'] }}">
                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['resume'] }}" target="_blank">Resume</a>
                                    </button>
                                </div>
                                <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['first_gov_id'] }}">
                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['first_gov_id'] }}" target="_blank">First Government ID</a>
                                    </button>
                                </div>
                                <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['second_gov_id'] }}">
                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['second_gov_id'] }}" target="_blank">Second Government ID</a>
                                    </button>
                                </div>
                            </div>
<!--                            <div class="row mt-4">
                                <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['intermediate'] }}">
                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['intermediate'] }}" target="_blank">Intermediate</a>
                                    </button>
                                </div>
                                <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['highSchool'] }}">
                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['highSchool'] }}" target="_blank">High School</a>
                                    </button>
                                </div>
                                <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['workExp'] }}">
                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['workExp'] }}" target="_blank">Work Experience</a>
                                    </button>
                                </div>
                            </div>-->
                        @else
                            <div class="badge badge-warning">Documents have not been submitted yet!</div>
                        @endif
                    </div>
                    
                    @endif

                    @if(isset($type) && $type == "view" && isset($listMapfirstdata) && isset($listMapseconddata))
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <h5 class="text-center d-flex justify-content-center">
                                        <span class="border-bottom-span border-bottom">Mapped Client List</span>
                                    </h5>
                                    <div class="card-body">
                                        <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                                            <table class="table table-hover">
                                                <thead class="text-dark">
                                                    <tr>
                                                        <th class="text-left" scope="col">S.No.</th> 
                                                        <th class="text-left" scope="col">Name</th>
                                                        <th class="text-left" scope="col">Client Code</th>
                                                        <th class="text-left" scope="col">Contact Number</th>
                                                        <th class="text-left" scope="col">Address</th>
                                                        <th class="text-left" scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($listMapseconddata as $key=>$value)
                                                        <tr>
                                                            <th class="text-left" scope="row">{{ ++$key }}</th>
                                                            <td class="text-left">{{ $value[0]['name'] }}</td>
                                                            <td class="text-left">{{ $value[0]['username'] }}</td>
                                                            <td class="text-left">{{ $value[0]['contactNumber'] }}</td>
                                                            <td class="text-left">{{ $value[0]['address'] }}</td>
                                                            <td class="d-flex">
                                                                <div class="peterriver" onclick="viewOrEdit('{{ url('viewOrEditRole') }}', 'view', '{{ $value[0]['clientId'] }}');">View</div> 
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="7" align="center" class="tablemotfounditem">Not Found any</td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <h5 class="text-center d-flex justify-content-center">
                                        <span class="border-bottom-span border-bottom">Mapped Vendor List</span>
                                    </h5>
                                    <div class="card-body">
                                        <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                                            <table class="table table-hover">
                                                <thead class="text-dark">
                                                    <tr>
                                                        <th class="text-left" scope="col">S.No.</th> 
                                                        <th class="text-left" scope="col">Name</th>
                                                        <th class="text-left" scope="col">Vendor Code</th>
                                                        <th class="text-left" scope="col">Contact Number</th>
                                                        <th class="text-left" scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($listMapfirstdata as $key=>$value)
                                                        <tr>
                                                            <th class="text-left" scope="row">{{ ++$key }}</th>
                                                            <td class="text-left">{{ $value[0]['name'] }}</td>
                                                            <td class="text-left">{{ $value[0]['username'] }}</td>
                                                            <td class="text-left">{{ $value[0]['contactNumber'] }}</td>
                                                            <td class="d-flex">
                                                                <div class="peterriver" onclick="viewOrEdit('{{ url('viewOrEditRole') }}', 'view', '{{ $value[0]['vendorId'] }}');">View</div> 
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="7" align="center" class="tablemotfounditem">Not Found any</td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif

                    <div class="row">
                        <div class="update ml-auto mr-auto">
                            <div
                                class="wetasphalt"
                                onclick="redirection('{{ url()->previous() }}');"
                            >
                                Back
                            </div>
                            <div
                                class="sunflower"
                                onclick="viewOrEdit('{{ url('viewOrEditRole') }}', 'edit', '{{ $result['marshalId'] }}');"
                            >
                                Edit
                            </div>
                            <div
                                class="alizarin"
                                id="confirmRoleDelete"
                                onclick="deleteModal('{{ url('deleteRole') }}', '{{ $result['marshalId'] }}');"
                            >
                                Delete
                            </div>
                        </div>
                    </div> 
                </form>
            </div>
        </div>
    </div>
</div>
@endsection