@extends('layouts.masterDashboard')
@section('content')
<?php
    $roleName = isset($result['foodscraftRole']) && !empty($result['foodscraftRole']) ? strtolower($result['foodscraftRole']) : (isset($roleType) && !empty($roleType) ? strtolower($roleType) : '');
    // dd($result, $roleName);
?>
<div class="row">
    <div class="col-md-12">
        <div class="main-card mb-3 card">
            <div class="card-header p-2">
                <h3 class="w-100 text-center">REGISTER</h3>
            </div>
            <div class="card-body">
                <form method="POST" class="fkformlabel" action="{{ url('editRole') }}" enctype='multipart/form-data'>
                    @csrf
                    <input type="hidden" name="id" value="{{ isset($result['marshalId']) ? $result['marshalId'] : null }}" />
                    <input id="foodscraftRole" type="hidden" name="foodscraftRole" value="SiteMarshal" />
                    <input type="hidden" name="address" id="address" value="default" />
                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="name">Name</label>
                                <span class="required-field">*</span>
                                <input
                                    type="text"
                                    id="name"
                                    class="form-control"
                                    autocomplete="off"
                                    name="name"
                                    value="{{ isset($result['name']) ? $result['name'] : null }}"
                                    required
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="username">Employee ID</label>
                                <span class="required-field">*</span>
                                <input
                                    type="text"
                                    id="username"
                                    class="form-control"
                                    autocomplete="off"
                                    name="username"
                                    value="{{ isset($result['username']) ? $result['username'] : null }}"
                                    readonly
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="email">Email address</label>
                                <span class="required-field">*</span>
                                <input
                                    type="email"
                                    id="email"
                                    class="form-control"
                                    name="email"
                                    autocomplete="off"
                                    value="{{ isset($result['email']) ? $result['email'] : null }}"
                                    readonly
                                />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="designation">Designation</label>
                                <span class="required-field">*</span>
                                <select class="form-control" name="designation" id="designation" required>
                                    <!--<option value="">Select</option>-->
                                    <option value="{{ isset($result['designation']) && !empty($result['designation']) ? $result['designation'] : '' }}" checked>{{ isset($result['designation']) && !empty($result['designation']) ? $result['designation'] : '' }}</option>
                                    <option value="sitemarshall">Site Marshall</option>
                                    <option value="sitemanager">Site Manager</option>
                                    <option value="zonemanager">Zone Manager</option>
                                    <option value="areamanager">Area Manager</option>
                                    <option value="countryhead">Country Head</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="keyresponsibilities">Key Responsibilities</label>
                                <span class="required-field">*</span>
                                <select class="form-control" name="keyresponsibilities" id="keyresponsibilities" required>
                                    <option value="{{ isset($result['keyresponsibilities']) && !empty($result['keyresponsibilities']) ? $result['keyresponsibilities'] : 'Select' }}">{{ isset($result['keyresponsibilities']) && !empty($result['keyresponsibilities']) ? $result['keyresponsibilities'] : 'Select' }}</option>
                                    <option value="marketing">Marketing</option>
                                    <option value="sales">Sales</option>
                                    <option value="bd">BD</option>
                                    <option value="kitchenoperations">Kitchen Operations</option>
                                    <option value="newclientcatererexpansion">New Client + Caterer Expansion</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="contactNumber">Mobile number</label>
                                <span class="required-field">*</span>
                                <input
                                    id="contactNumber"
                                    type="tel"
                                    pattern="^[0-9]{10}$"
                                    data-toggle="tooltip"
                                    title="10 Digit Mobile Number Only"
                                    class="form-control"
                                    name="contactNumber"
                                    autocomplete="off"
                                    value="{{ isset($result['contactNumber']) ? $result['contactNumber'] : null }}"
                                    required
                                />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="siteassigned">Designated Area</label>
                                <input
                                    id="siteassigned"
                                    type="text"
                                    class="form-control"
                                    pattern="[a-zA-Z ]+"
                                    data-toggle="tooltip"
                                    title="Text Only"
                                    placeholder="Location name"
                                    name="siteassigned"
                                    value="{{ isset($result['siteAssigned']) ? $result['siteAssigned'] : null }}"
                                />
                            </div>
                        </div>
<!--                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="govId">2 Government ID</label>
                                <span class="required-field">*</span>
                                <input
                                    id="govId"
                                    type="text"
                                    class="form-control"
                                    name="govId"
                                    value="{{ isset($result['govId']) ? $result['govId'] : null }}"
                                    required
                                />
                            </div>
                        </div>-->
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="yearExp">Years of experience</label>
                                <input
                                    id="yearExp"
                                    type="text"
                                    class="form-control"
                                    pattern="^[1-9]{1|2}$"
                                    data-toggle="tooltip"
                                    title="Max 2 Digits Only"
                                    name="yearExp"
                                    value="{{ isset($result['expInYrs']) ? $result['expInYrs'] : null }}"
                                />
                            </div>
                        </div>
                    </div>

                    <div class="row d-flex justify-content-center">
                        <div class="update">
                            <div
                                class="wetasphalt"
                                style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;"
                                onclick="redirection('{{ url()->previous() }}');"
                            >
                                Back
                            </div>
                        </div>
                        <div class="update">
                            <button
                                type="submit"
                                class="sunflower w-100"
                                style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;"
                            >
                                Update
                            </button>
                        </div>
                    </div> 
                </form>
            </div>
        </div>
    </div>
</div>
@endsection