@extends('layouts.masterDashboard')
@section('content')
<?php
    $roleName = "client";
    // dd($result, $roleName);
    $explode_names = isset($result['contactName']) && !empty($result['contactName']) ? explode(", ", $result['contactName']) : '';
    $explode_number = isset($result['contactNumber']) && !empty($result['contactNumber']) ? explode(", ", $result['contactNumber']) : '';
?>
<div class="row">
    <div class="col-md-12">
        <div class="main-card mb-3 card">
            <div class="card-header p-2">
                <h3 class="w-100 text-center">Edit Client Profile</h3>
            </div>
            <div class="card-body">
                <form method="POST" class="fkformlabel" action="{{ url('editRole') }}" enctype='multipart/form-data'>
                    @csrf
                    <input type="hidden" name="id" value="{{ isset($result['clientId']) ? $result['clientId'] : null }}" />
                    <input id="foodscraftRole" type="hidden" name="foodscraftRole" value="Client" readonly />
                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="name">Client's Name</label>
                                <span class="required-field">*</span>
                                <input
                                    type="text"
                                    id="name"
                                    class="form-control"
                                    autocomplete="off"
                                    name="name"
                                    value="{{ isset($result['name']) ? $result['name'] : null }}"
                                    required
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="username">Client Code</label>
                                <span class="required-field">*</span>
                                <input
                                    type="text"
                                    id="username"
                                    class="form-control"
                                    autocomplete="off"
                                    name="username"
                                    value="{{ isset($result['username']) ? $result['username'] : null }}"
                                    readonly
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="email">Email address</label>
                                <span class="required-field">*</span>
                                <input
                                    type="email"
                                    id="email"
                                    class="form-control"
                                    autocomplete="off"
                                    name="email"
                                    value="{{ isset($result['email']) ? $result['email'] : null }}"
                                    
                                />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="contactName">Contact person name</label>
                                <span class="required-field">*</span>
                                <input
                                    id="contactName"
                                    type="text"
                                    class="form-control"
                                    name="contactName[]"
                                    autocomplete="off"
                                    value="{{ is_array($explode_names) && isset($explode_names[0]) ? $explode_names[0] : null }}"
                                    required
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="contactName">Contact person name (1)</label>
                                <input
                                    id="contactName"
                                    type="text"
                                    class="form-control"
                                    name="contactName[]"
                                    autocomplete="off"
                                    value="{{ is_array($explode_names) && isset($explode_names[1]) ?  $explode_names[1] : null }}"
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="contactName">Contact person name (2)</label>
                                <input
                                    id="contactName"
                                    type="text"
                                    class="form-control"
                                    name="contactName[]"
                                    autocomplete="off"
                                    value="{{ is_array($explode_names) && isset($explode_names[2]) ? $explode_names[2] : null }}"
                                />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="contactNumber">Contact person number</label>
                                <span class="required-field">*</span>
                                <input
                                    id="contactNumber"
                                    type="tel"
                                    pattern="^[0-9]{10}$"
                                    data-toggle="tooltip"
                                    title="10 Digit Mobile Number Only"
                                    class="form-control"
                                    name="contactNumber[]"
                                    autocomplete="off"
                                    value="{{ is_array($explode_number) && isset($explode_number[0]) ? $explode_number[0] : null }}"
                                    required 
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="contactNumber">Contact person number (1)</label>
                                <input
                                    id="contactNumber"
                                    type="tel"
                                    pattern="^[0-9]{10}$"
                                    data-toggle="tooltip"
                                    title="10 Digit Mobile Number Only"
                                    class="form-control"
                                    name="contactNumber[]"
                                    autocomplete="off"
                                    value="{{ is_array($explode_number) && isset($explode_number[1]) ? $explode_number[1] : null }}"
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="contactNumber">Contact person number (2)</label>
                                <input
                                    id="contactNumber"
                                    type="tel"
                                    pattern="^[0-9]{10}$"
                                    data-toggle="tooltip"
                                    title="10 Digit Mobile Number Only"
                                    class="form-control"
                                    name="contactNumber[]"
                                    autocomplete="off"
                                    value="{{ is_array($explode_number) && isset($explode_number[2]) ? $explode_number[2] : null }}"
                                />
                            </div>
                        </div>
                    </div>

                    <div class="row mb-2">
                        <div class="col-md-3 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="address">Client Address</label>
                                <span class="required-field">*</span>
                                <input
                                    id="address"
                                    type="text"
                                    class="form-control"
                                    name="address"
                                    autocomplete="off"
                                    value="{{ isset($result['address']) && !empty($result['address']) ? $result['address'] : null }}"
                                    required
                                />
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="headOffice">Head Office Address</label>
                                <span class="required-field">*</span>
                                <input
                                    id="headOffice"
                                    type="text"
                                    class="form-control"
                                    name="headOffice"
                                    value="{{ isset($result['headOffice']) ? $result['headOffice'] : null }}"
                                    required
                                />
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="employeeNumber">No. of employees</label>
                                <span class="required-field">*</span>
                                <input
                                    id="employeeNumber"
                                    type="text"
                                    class="form-control" 
                                    name="employeeNumber"
                                    value="{{ isset($result['employeeNumber']) ? $result['employeeNumber'] : null }}"
                                    required
                                />
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-12 pl-md-1 mb-sm-2">
                            <div class="form-group">
                                <label for="clientCategory">Client Category</label>
                                <span class="required-field">*</span>
                                <select class="form-control" name="clientCategory" id="clientCategory" required>
                                    <option value="{{ isset($result['clientCategory']) && !empty($result['clientCategory']) ? $result['clientCategory'] : '' }}" checked>{{ isset($result['clientCategory']) && !empty($result['clientCategory']) ? $result['clientCategory'] : 'Select type' }}</option>
                                    <option value="corporate">corporate</option>
                                    <option value="industrial">industrial</option>
                                    <option value="hospital">hospital</option>
                                    <option value="institute">institute</option>
                                    <option value="psuOthers">Psu & Others</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-2">
                        <div class="col-sm-12 col-md-6 border-right">
                            <div class="form-group">

                                <h6 class="text-center d-flex justify-content-center">
                                    <span class="border-bottom-span border-bottom">Type of services</span>
                                    <span class="required-field">*</span>
                                </h6>

                                <input
                                    class="inp-cbx"
                                    id="mainMeal"
                                    type="checkbox"
                                    name="typeOfServices[]"
                                    value="mainMeal"
                                    <?php echo!isset($result['typeOfServices']) && empty($result['typeOfServices']) ? '' : (in_array("mainMeal", explode(", ", $result["typeOfServices"])) ? 'checked' : '') ?>
                                />
                                <label class="cbx" for="mainMeal">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Main Meal</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="tuckShop"
                                    type="checkbox"
                                    name="typeOfServices[]"
                                    value="tuckShop"
                                    <?php echo!isset($result['typeOfServices']) && empty($result['typeOfServices']) ? '' : (in_array("tuckShop", explode(", ", $result["typeOfServices"])) ? 'checked' : '') ?>
                                />
                                <label class="cbx" for="tuckShop">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Tuck Shop</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="liveCounter"
                                    type="checkbox"
                                    name="typeOfServices[]"
                                    value="liveCounter"
                                    <?php echo!isset($result['typeOfServices']) && empty($result['typeOfServices']) ? '' : (in_array("liveCounter", explode(", ", $result["typeOfServices"])) ? 'checked' : '') ?>
                                />
                                <label class="cbx" for="liveCounter">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Live Counter</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="healthyOptions"
                                    type="checkbox"
                                    name="typeOfServices[]"
                                    value="healthyOptions"
                                    <?php echo!isset($result['typeOfServices']) && empty($result['typeOfServices']) ? '' : (in_array("healthyOptions", explode(", ", $result["typeOfServices"])) ? 'checked' : '') ?>
                                />
                                <label class="cbx" for="healthyOptions">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Healthy Options</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="mrp"
                                    type="checkbox"
                                    name="typeOfServices[]"
                                    value="mrp"
                                    <?php echo!isset($result['typeOfServices']) && empty($result['typeOfServices']) ? '' : (in_array("mrp", explode(", ", $result["typeOfServices"])) ? 'checked' : '') ?>
                                />
                                <label class="cbx" for="mrp">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Mrp</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="juiceOrBeverages"
                                    type="checkbox"
                                    name="typeOfServices[]"
                                    value="juiceOrBeverages"
                                    <?php echo!isset($result['typeOfServices']) && empty($result['typeOfServices']) ? '' : (in_array("juiceOrBeverages", explode(", ", $result["typeOfServices"])) ? 'checked' : '') ?>
                                />
                                <label class="cbx" for="juiceOrBeverages">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Juice Or Beverages</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="tosothers"
                                    type="checkbox"
                                    name="typeOfServices[]"
                                    onclick="tosothersFunction()"
                                    value="others"
                                    <?php echo!isset($result['typeOfServices']) && empty($result['typeOfServices']) ? '' : (in_array("tosothers", explode(", ", $result["typeOfServices"])) ? 'checked' : '') ?>
                                />
                                <label class="cbx" for="tosothers">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Others</span>
                                </label>

                            </div>
                            <div class="col-md-12 pr-md-1 divtosother" id="divtosother" style="display:none">
                                <div class="form-group">
                                    <label for="tosother">Type of services other</label>
                                    <textarea
                                        id="tosother"
                                        class="md-textarea form-control"
                                        rows="3"
                                        autocomplete="off"
                                        name="tosother"
                                    >
                                        <?php echo isset($result['tosother']) ? $result['tosother'] : '' ?>
                                    </textarea>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="typeServiceSuggestion">Details of Services</label>
                                <textarea
                                    id="typeServiceSuggestion"
                                    type="text"
                                    class="form-control"
                                    name="typeServiceSuggestion"
                                >
                                    {{ isset($result['typeServiceSuggestion']) ? $result['typeServiceSuggestion'] : '' }}
                                </textarea>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-6 border-left">
                            <div class="form-group">

                                <h6 class="text-center d-flex justify-content-center">
                                    <span class="border-bottom-span border-bottom">Client scope for cafe</span>
                                    <span class="required-field">*</span>
                                </h6>

                                <input
                                    class="inp-cbx"
                                    id="bainMaire"
                                    type="checkbox"
                                    name="clientScopeCafe[]"
                                    value="bainMaire"
                                    <?php echo!isset($result['clientScopeCafe']) && empty($result['clientScopeCafe']) ? '' : (in_array("bainMaire", explode(", ", $result["clientScopeCafe"])) ? 'checked' : '') ?>
                                />
                                <label class="cbx" for="bainMaire">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Provides bain maire</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="cutleryCrockery"
                                    type="checkbox"
                                    name="clientScopeCafe[]"
                                    value="cutleryCrockery"
                                    <?php echo!isset($result['clientScopeCafe']) && empty($result['clientScopeCafe']) ? '' : (in_array("cutleryCrockery", explode(", ", $result["clientScopeCafe"])) ? 'checked' : '') ?>
                                />
                                <label class="cbx" for="cutleryCrockery">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Cutlery & Crockery</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="DishWashingArea"
                                    type="checkbox"
                                    name="clientScopeCafe[]"
                                    value="DishWashingArea"
                                    <?php echo!isset($result['clientScopeCafe']) && empty($result['clientScopeCafe']) ? '' : (in_array("DishWashingArea", explode(", ", $result["clientScopeCafe"])) ? 'checked' : '') ?>
                                />
                                <label class="cbx" for="DishWashingArea">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Dish washing area</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="DishWashingMachine"
                                    type="checkbox"
                                    name="clientScopeCafe[]"
                                    value="DishWashingMachine"
                                    <?php echo!isset($result['clientScopeCafe']) && empty($result['clientScopeCafe']) ? '' : (in_array("DishWashingMachine", explode(", ", $result["clientScopeCafe"])) ? 'checked' : '') ?>
                                />
                                <label class="cbx" for="DishWashingMachine">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Dish Washing Machine</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="SpaceForLiveCooking"
                                    type="checkbox"
                                    name="clientScopeCafe[]"
                                    value="SpaceForLiveCooking"
                                    <?php echo!isset($result['clientScopeCafe']) && empty($result['clientScopeCafe']) ? '' : (in_array("SpaceForLiveCooking", explode(", ", $result["clientScopeCafe"])) ? 'checked' : '') ?>
                                />
                                <label class="cbx" for="SpaceForLiveCooking">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Space for live cooking</span>
                                </label>

                                <input
                                    class="inp-cbx csfcother"
                                    id="csfcothers"
                                    type="checkbox"
                                    onclick="csfcothersFunction()"
                                    name="clientScopeCafe[]"
                                    value="others"
                                    <?php echo!isset($result['clientScopeCafe']) && empty($result['clientScopeCafe']) ? '' : (in_array("others", explode(", ", $result["clientScopeCafe"])) ? 'checked' : '') ?>
                                />
                                <label class="cbx" for="csfcothers">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Others</span>
                                </label>

                            </div>
                            <div class="col-md-12 pr-md-1 divcsfcother" id="divcsfcother" style="display:none">
                                <div class="form-group">
                                    <label for="csfcother">Client scope for cafe other</label>
                                    <textarea
                                        id="csfcother"
                                        class="md-textarea form-control"
                                        rows="3"
                                        autocomplete="off"
                                        name="csfcother"
                                    >
                                        <?php echo isset($result['csfcother']) ? $result['csfcother'] : '' ?>
                                    </textarea>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="clientScopeSuggestion">Details of client scope.</label>
                                <textarea
                                    id="clientScopeSuggestion"
                                    type="text"
                                    class="form-control"
                                    name="clientScopeSuggestion"
                                >
                                    {{ isset($result['clientScopeSuggestion']) ? $result['clientScopeSuggestion'] : '' }}
                                </textarea>
                            </div>
                        </div>  
                    </div>

                    <div class="row">
                        <div class="col border-right">
                            <div class="form-group">
                                <h5 class="text-center d-flex justify-content-center" style="font-weight: 600 !important;color: #fff;">
                                    <span class="border-bottom">Payment terms</span>
                                    <span class="required-field">*</span>
                                </h5>
                                <div class="d-md-flex justify-content-around">
                                    <label class="radio">
                                        <input
                                            type="radio"
                                            name="paymentTerms"
                                            value="minimumGuarantee"
                                            <?php echo !isset($result['paymentTerms']) && empty($result['paymentTerms']) ? '' : ($result['paymentTerms'] == "minimumGuarantee" ? 'checked' : '') ?>
                                        />
                                        <span>Minimum guarantee</span>
                                    </label>
                                    <label class="radio">
                                        <input
                                            type="radio"
                                            name="paymentTerms"
                                            value="subsidized"
                                            <?php echo !isset($result['paymentTerms']) && empty($result['paymentTerms']) ? '' : ($result['paymentTerms'] == "subsidized" ? 'checked' : '') ?>
                                        />
                                        <span>Subsidized</span>
                                    </label>
                                    <label class="radio">
                                        <input
                                            type="radio"
                                            name="paymentTerms"
                                            value="cash"
                                            <?php echo !isset($result['paymentTerms']) && empty($result['paymentTerms']) ? '' : ($result['paymentTerms'] == "cash" ? 'checked' : '') ?>
                                        />
                                        <span>Cash</span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col border-left">
                            <div class="form-group">
                                <h5 class="text-center d-flex-justify-content-center" style="font-weight: 600 !important;color: #fff;">
                                    <span class="border-bottom">Agreement/Contract</span>
                                </h5>
                                @if(isset($result['temp1']))
                                    <div class="d-flex flex-wrap justify-content-center">
                                        <span class="badge badge-warning mt-2">Documents once submitted cannot be updated anymore..</span>
                                    </div>
                                @else
                                    <div class="custom-file">
                                        <input
                                            type="file"
                                            class="custom-file-input"
                                            id="clientDocuments"
                                            lang="es"
                                            name="clientDocuments[]"
                                            onchange="putName(this);"
                                            accept=".doc, .pdf"
                                            multiple
                                        />
                                        <label class="custom-file-label" for="clientDocuments">Maximum limit for uploading is 5..</label>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 pr-md-1 border-right">
                            <div class="form-group">
                                <label for="paymentdetails">Payment Details</label>
                                <span class="required-field">*</span>
                                <input
                                    type="text"
                                    id="paymentdetails"
                                    class="form-control"
                                    autocomplete="off"
                                    name="paymentdetails"
                                    value="{{ isset($result['paymentdetails']) ? $result['paymentdetails'] : null }}"
                                    required
                                />
                            </div>
                        </div>
                        <div class="col-md-6 pl-md-1 border-left">
                          <div class="col-md-12 col-sm-12">
                            <div class="form-group">
                              <label for="name">Agreement/Contract End Date</label>
                              <div class="custom-file">
                                @if(isset($result['temp1']))
                                  <div class="input-group p-0 shadow-sm datepicker date">
                                    <input class="form-control shadow-sm" id="client_agreement_end_date" type="text" name="client_agreement_end_date" placeholder="Agreement/Contract end date" value="{{ isset($result['client_agreement_end_date']) ? $result['client_agreement_end_date'] : null }}" autocomplete="off" disabled>
                                    <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                  </div>
                                @else
                                  <div class="input-group p-0 shadow-sm datepicker date">
                                    <input class="form-control shadow-sm" id="client_agreement_end_date" type="text" name="client_agreement_end_date" placeholder="Agreement/Contract end date" value="{{ isset($result['client_agreement_end_date']) ? $result['client_agreement_end_date'] : null }}" autocomplete="off">
                                    <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                  </div>
                                @endif                                
                              </div>
                            </div>
                          </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col">
                            <h3 class="text-center">Finalized Meal Rate List</h3>
                        </div>
                    </div>

                    <div class="row mealtypeFormBorder">
                        <div class="row w-100">
                            <h4 class="text-center w-100">Meal Type 1</h4>
                        </div>
                        <div class="row w-100">
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type1[breakfast]">Breakfast</label>
                                    <input
                                        type="number"
                                        id="type1[breakfast]"
                                        name="type1[breakfast]"
                                        class="form-control"
                                        placeholder="Rates for breakfast"
                                        value="{{ $result['breakfast1'] }}"
                                    >
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type1[lunch]">Lunch</label>
                                    <input
                                        type="number"
                                        id="type1[lunch]"
                                        name="type1[lunch]"
                                        class="form-control"
                                        placeholder="Rates for lunch"
                                        pattern="^[0-9]$"
                                        value="{{ $result['lunch1'] }}"
                                    >
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type1[dinner]">Dinner</label>
                                    <input
                                        type="number"
                                        id="type1[dinner]"
                                        name="type1[dinner]"
                                        class="form-control"
                                        placeholder="Rates for dinner"
                                        pattern="^[0-9]$"
                                        value="{{ $result['dinner1'] }}"
                                    >
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type1[snacks]">Evening Tea/Snacks</label>
                                    <input
                                        type="number"
                                        id="type1[snacks]"
                                        name="type1[snacks]"
                                        class="form-control"
                                        placeholder="Rates for evening snacks"
                                        pattern="^[0-9]$"
                                        value="{{ $result['snacks1'] }}"
                                    >
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type1[others]">Others</label>
                                    <input
                                        type="number"
                                        id="type1[others]"
                                        name="type1[others]"
                                        class="form-control"
                                        placeholder="Rates for others"
                                        pattern="^[0-9]$"
                                        value="{{ $result['others1'] }}"
                                    >
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mealtypeFormBorder">
                        <div class="row w-100">
                            <h4 class="text-center w-100">Meal Type 2</h4>
                        </div>
                        <div class="row w-100">
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type2[breakfast]">Breakfast</label>
                                    <input
                                        type="number"
                                        id="type2[breakfast]"
                                        name="type2[breakfast]"
                                        class="form-control"
                                        placeholder="Rates for breakfast"
                                        value="{{ $result['breakfast2'] }}"
                                    >
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type2[lunch]">Lunch</label>
                                    <input
                                        type="number"
                                        id="type2[lunch]"
                                        name="type2[lunch]"
                                        class="form-control"
                                        placeholder="Rates for lunch"
                                        pattern="^[0-9]$"
                                        value="{{ $result['lunch2'] }}"
                                    >
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type2[dinner]">Dinner</label>
                                    <input
                                        type="number"
                                        id="type2[dinner]"
                                        name="type2[dinner]"
                                        class="form-control"
                                        placeholder="Rates for dinner"
                                        pattern="^[0-9]$"
                                        value="{{ $result['dinner2'] }}"
                                    >
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type2[snacks]">Evening Tea/Snacks</label>
                                    <input
                                        type="number"
                                        id="type2[snacks]"
                                        name="type2[snacks]"
                                        class="form-control"
                                        placeholder="Rates for evening snacks"
                                        pattern="^[0-9]$"
                                        value="{{ $result['snacks2'] }}"
                                    >
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type2[others]">Others</label>
                                    <input
                                        type="number"
                                        id="type2[others]"
                                        name="type2[others]"
                                        class="form-control"
                                        placeholder="Rates for others"
                                        pattern="^[0-9]$"
                                        value="{{ $result['others2'] }}"
                                    >
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mealtypeFormBorder">
                        <div class="row w-100">
                            <h4 class="text-center w-100">Meal Type 3</h4>
                        </div>
                        <div class="row w-100">
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type3[breakfast]">Breakfast</label>
                                    <input
                                        type="number"
                                        id="type3[breakfast]"
                                        name="type3[breakfast]"
                                        class="form-control"
                                        placeholder="Rates for breakfast"
                                        value="{{ $result['breakfast3'] }}"
                                    >
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type3[lunch]">Lunch</label>
                                    <input
                                        type="number"
                                        id="type3[lunch]"
                                        name="type3[lunch]"
                                        class="form-control"
                                        placeholder="Rates for lunch"
                                        pattern="^[0-9]$"
                                        value="{{ $result['lunch3'] }}"
                                    >
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type3[dinner]">Dinner</label>
                                    <input
                                        type="number"
                                        id="type3[dinner]"
                                        name="type3[dinner]"
                                        class="form-control"
                                        placeholder="Rates for dinner"
                                        pattern="^[0-9]$"
                                        value="{{ $result['dinner3'] }}"
                                    >
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type3[snacks]">Evening Tea/Snacks</label>
                                    <input
                                        type="number"
                                        id="type3[snacks]"
                                        name="type3[snacks]"
                                        class="form-control"
                                        placeholder="Rates for evening snacks"
                                        pattern="^[0-9]$"
                                        value="{{ $result['snacks3'] }}"
                                    >
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type3[others]">Others</label>
                                    <input
                                        type="number"
                                        id="type3[others]"
                                        name="type3[others]"
                                        class="form-control"
                                        placeholder="Rates for others"
                                        pattern="^[0-9]$"
                                        value="{{ $result['others3'] }}"
                                    >
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col">
                            <h3 class="text-center">Finalized Meal Timing ( From - To )</h3>
                        </div>
                    </div>

                    <div class="row mb-4 mealtypeFormBorder">
                        <div class="col-md-3 col-sm-12">
                          <div class="form-group">
                            <label for="breakfast_time">Breakfast Time</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <input type="time" name="breakfast_from" class="input-group-text" value="{{ $result['breakfast_from'] }}">
                                </div>
                                <div class="input-group-append">
                                    <input type="time" name="breakfast_to" class="input-group-text" value="{{ $result['breakfast_to'] }}">
                                </div>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-3 col-sm-12">
                          <div class="form-group">
                            <label for="breakfast_time">Lunch Time</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <input type="time" name="lunch_from" class="input-group-text" value="{{ $result['lunch_from'] }}">
                                </div>
                                <div class="input-group-append">
                                    <input type="time" name="lunch_to" class="input-group-text" value="{{ $result['lunch_to'] }}">
                                </div>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-3 col-sm-12">
                          <div class="form-group">
                            <label for="breakfast_time">Dinner Time</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <input type="time" name="dinner_from" class="input-group-text" value="{{ $result['dinner_from'] }}">
                                </div>
                                <div class="input-group-append">
                                    <input type="time" name="dinner_to" class="input-group-text" value="{{ $result['dinner_to'] }}">
                                </div>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-3 col-sm-12">
                          <div class="form-group">
                            <label for="breakfast_time">Evening Snacks Time</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <input type="time" name="snacks_from" class="input-group-text" value="{{ $result['snacks_from'] }}">
                                </div>
                                <div class="input-group-append">
                                    <input type="time" name="snacks_to" class="input-group-text" value="{{ $result['snacks_to'] }}">
                                </div>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-3 col-sm-12">
                          <div class="form-group">
                            <label for="breakfast_time">Others</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <input type="time" name="others_from" class="input-group-text" value="{{ $result['others_from'] }}">
                                </div>
                                <div class="input-group-append">
                                    <input type="time" name="others_to" class="input-group-text" value="{{ $result['others_to'] }}">
                                </div>
                            </div>
                          </div>
                        </div>
                    </div>

                    <div class="row d-flex justify-content-center">
                        <div class="update">
                            <div
                                class="wetasphalt"
                                style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;"
                                onclick="redirection('{{ url()->previous() }}');"
                            >
                                Back
                            </div>
                        </div>
                        <div class="update">
                            <button
                                type="submit"
                                class="sunflower w-100"
                                style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;"
                            >
                                Update
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection