@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Client List</h3>
                </div>
                <div class="card-body p-1">
                    <div class="container">
                        <div class="row px-4 d-flex justify-content-end">
                            <div class="">
                                <input type="text" onkeyup="search(event);" placeholder="Search by name.." class="form-control p-2 h-75" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                        <table class="table table-hover">
                            <thead class="text-dark">
                                <tr>
                                    <th class="text-left" scope="col">S.No.</th>
                                    <th class="text-left" scope="col">Client (Name- Code)</th>
                                    <th class="text-left" scope="col">Contact Person</th>
                                    <th class="text-left" scope="col">Contact Number</th>
                                    <th scope="col" class="d-flex justify-content-start">Action</th>
                                </tr>
                            </thead>
                            <tbody id="role_list">
                                <td colspan="7" align="center" id="load_data" style="display: none;">
                                    <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                       width="24px" height="30px" viewBox="0 0 24 30" style="enable-background:new 0 0 50 50;" xml:space="preserve">
                                      <rect x="0" y="0" width="4" height="10" fill="#333">
                                        <animateTransform attributeType="xml"
                                          attributeName="transform" type="translate"
                                          values="0 0; 0 20; 0 0"
                                          begin="0" dur="0.6s" repeatCount="indefinite" />
                                      </rect>
                                      <rect x="10" y="0" width="4" height="10" fill="#333">
                                        <animateTransform attributeType="xml"
                                          attributeName="transform" type="translate"
                                          values="0 0; 0 20; 0 0"
                                          begin="0.2s" dur="0.6s" repeatCount="indefinite" />
                                      </rect>
                                      <rect x="20" y="0" width="4" height="10" fill="#333">
                                        <animateTransform attributeType="xml"
                                          attributeName="transform" type="translate"
                                          values="0 0; 0 20; 0 0"
                                          begin="0.4s" dur="0.6s" repeatCount="indefinite" />
                                      </rect>
                                    </svg>
                                </td>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer p-0 my-2 border-bottom-0 border-top-0 text-center d-flex justify-content-center" style="align-self: center;color: #d45353;">
                    <h6>{{ isset($roles) ? $roles->links() : '' }}</h6>
                    <div class="d-flex justify-content-around">
                        <button class="btn btn-light mx-2 py-1 px-2 w-auto" onclick="previous_request(this);" id="previous">
                            <i class="fa fa-angle-left"></i>
                        </button>
                        <button class="btn btn-light mx-2 py-1 px-2 w-auto" onclick="next_request(this);" id="next">
                            <i class="fa fa-angle-right"></i>
                        </button>
                        <button class="btn btn-light mx-2 p-1 px-2 font-weight-bold" onclick="last_request(this);" id="last">Last</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @section('customscript')
        <script>
            var next = "";
            var previous = "";
            var last = "";
            $(function () {
                var link = "{{ url('ICount/I-count/dinein/salereport/client_list') }}";
                request_role_data(link);
            });
            function search(e){
                console.log(e.target.value);
                var search = e.target.value.trim();
                if(search !== null || search !== ""){
                    var link = "{{ url('ICount/I-count/dinein/salereport/client_list') }}" + "/" + search;
                    request_role_data(link);
                }
            }
            function request_role_data(link){
                $roles = $.ajax({
                    type        : 'GET',
                    url         : link,
                    beforeSend: function(){
                        $("td#load_data").css({'display': 'table-cell'});
                    },
                    success     : function(res){
                        console.log(res);
                        sort_list(res);
                        if(res.current_page == 1){
                            $('button#previous').prop('disabled', true);
                        }else{
                            $('button#previous').prop('disabled', false);
                        }
                        if(res.current_page == res.last_page){
                            $('button#next').prop('disabled', true);
                            $('button#last').prop('disabled', true);
                        }else{
                            $('button#next').prop('disabled', false);
                            $('button#last').prop('disabled', false);
                        }
                        next = res.next_page_url;
                        previous = res.prev_page_url;
                        last = res.last_page_url;
                    },
                    complete:function(data){
                        $("td#load_data").css({'display': 'none'});
                    },
                    error       : function(xhr, textStatus, errorThrown){
                        console.log(errorThrown, textStatus);
                    }
                });
            }
            function sort_list(res){
                $("tbody#role_list").empty();
                res.data.forEach((key, index) => {
                    var tr = document.createElement("tr");
                    index = ++index;
                    var client_number = "";
                    if(typeof key.client_number == "array"){
                        client_number = key.client_number.split(", ").pop();
                    }else{
                        client_number = key.client_number;
                    }
                    $(tr).html("\
                        <td class='text-left'>" + index + "</td>\
                        <td class='text-left'>" + key.client_name + ' - ' + key.client_code + "</td>\
                        <td class='text-left'>" + key.contact_person.split(", ").pop() + "</td>\
                        <td class='text-left'>" + client_number + "</td>\
                        <td class='d-flex justify-content-around'>\
                            <form method='POST' action='{{ url('ICount/I-count/empClientSaleReport') }}'>\
                                <input type='hidden' name='_token' value='{{ csrf_token() }}' >\
                                <input type='hidden' name='client_id' value='" + key.client_id + "' >\
                                <input type='hidden' name='client_code' value='" + key.client_code + "' >\
                                <input type='hidden' name='qr_type' value='type4' >\
                                <input type='submit' class='btn btn-sm btn-info font-weight-bold mx-1' value='Dine-in Sale Report' >\
                            </form>\
                        </td>\
                    ");
                    document.getElementById('role_list').appendChild(tr);
                });
            }
            function next_request(){
                request_role_data(next);
            }
            function previous_request(){
                request_role_data(previous);
            }
            function last_request(){
                request_role_data(last);
            }
        </script>
    @endsection
@endsection