@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header d-flex justify-content-center border-0">
                    <h3>Reports</h3>
                </div>
                <div class="card-body py-0">
                    <form action="{{ url('reports') }}" method="GET">
                        <div class="container row">
                            <div class="form-group mb-0 mx-3">
                                <select name="sort_by" id="sort_by" class="custom-select custom-select-sm">
                                    <option value="newConcern" selected>Raise Concern!</option>
                                    <option value="aiCamera">AI Camera!</option>
                                </select>
                            </div>
                            <div class="form-group mb-0 mx-3">
                                <input type="submit" class="btn btn-primary">
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-body py-1">
                    @if(isset($reports))
                        <div class="table-responsive p-2">
                            <table class="table table-hover">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-center" scope="col">S.No.</th>
                                        <th class="text-center" scope="col">From</th>
                                        <th class="text-center" scope="col">To</th>
                                        <th class="text-center" scope="col">Subject</th>
                                        <th class="text-center" scope="col">Date</th>
                                        <th scope="col" class="d-flex justify-content-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($reports as $report)
                                        <tr>
                                            <td class="text-center" scope="row">{{ $loop->iteration }}</td>
                                            <td class="text-center">{{ $report->from }}</td>
                                            <td class="text-center">{{ $report->to }}</td>
                                            <td class="text-center">{{ $report->subject }}</td>
                                            <td class="text-center">{{ $report->created_at->format('d M y H:i', 'Asia/Kolkata') }}</td>
                                            <td class="text-center" style="padding: 0px">
                                                @php
                                                    $url = "";
                                                    if($report->type == 'newConcern'){
                                                        $url = url('reports/concern') . '/' . $report->content;
                                                    }
                                                @endphp
                                                <a class="btn btn-info mx-1 font-weight-bold" style="color: cornsilk;" title="View" href="{{ $url }}">
                                                    <span>Generate Report</span>
                                                </a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" align="center">No Reports Yet!</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
                <div class="card-footer p-0" style="align-self: center;color: #d45353;">
                    <h6>{{ $reports->links() }}</h6>
                </div>
            </div>
        </div>
    </div>
@endsection