@extends('layouts.pdfmasterDashboard')
<style>
  body{
    color: #000!important;
  }
  #indEmpPrintable{
    color: #000!important;
  }
  .fksection-li, .fa{
    color: #fff;
  }
  .btn{
    margin: 0px;
    width: 75px;
    font-size: 16px;
    padding: 10px 10px;
    position: relative;
    transition: color 0.15s, background-color 0.15s, border-color 0.15s, box-shadow 0.15s;
    font-size: 0.8rem;
    background-color: #B81F44;
    margin-left: 0.5rem !important;
    margin-right: 0.5rem !important;
    color: #fff;
    cursor: pointer;
  }
  #pdfbtn{
    padding: 12px;
    width: 142px;
    border: 1px solid #B81F44;
    background-color: #B81F44;
    font-size: 16px;
    font-weight: bold;
    color: #fff;
  }
  #pdfbtn:hover{
    border: 1px solid #000;
    background-color: #fff;
    color: #000;
  }
.invoice-box {
        max-width: 1000px;
        margin: auto;
        padding: 30px;
        border: 1px solid #000;
        box-shadow: 0 0 10px rgba(0, 0, 0, .15);
        font-size: 16px;
        line-height: 24px;
        font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
        color: #000;
        background: #fff;
    }
    
    .invoice-box table {
        width: 100%;
        line-height: inherit;
        text-align: left;
    }
    
    .invoice-box table td {
        padding: 5px;
        vertical-align: top;
    }
    
    /* .invoice-box table tr td:nth-child(2),.invoice-box table tr td:nth-child(3),.invoice-box table tr td:nth-child(4),.invoice-box table tr td:nth-child(5),.invoice-box table tr td:nth-child(7) {
        text-align: right;
        width: 14%;
    } */
    .invoice-box table tr td:nth-child(1),.invoice-box table tr td:nth-child(6){
        /* text-align: right; */
        width: 12%;
    }
    .invoice-box table tr td:nth-child(2),.invoice-box table tr td:nth-child(3),.invoice-box table tr td:nth-child(4){
        /* text-align: right; */
        width: 16%;
    }

    .invoice-box table tr.top table td {
        padding-bottom: 20px;
    }
    
    .invoice-box table tr.top table td.title {
        font-size: 45px;
        line-height: 45px;
        color: #333;
    }
    
    .invoice-box table tr.information table td {
        padding-bottom: 40px;
    }
    
    .invoice-box table tr.heading td {
        background: #eee;
        border-bottom: 1px solid #ddd;
        font-weight: bold;
    }
    
    .invoice-box table tr.details td {
        padding-bottom: 20px;
    }
    
    .invoice-box table tr.item td{
        border-bottom: 1px solid #eee;
    }
    
    .invoice-box table tr.item.last td {
        border-bottom: none;
    }
    
    .invoice-box table tr.total td:nth-child(2) {
        border-top: 2px solid #eee;
        font-weight: bold;
    }
    .foot-note {
        max-width: 800px;
        margin: 0 auto;
        padding: 15px;
    }
    @media only screen and (max-width: 600px) {
        .invoice-box table tr.top table td {
            width: 100%;
            display: block;
            text-align: center;
        }
        
        .invoice-box table tr.information table td {
            width: 100%;
            display: block;
            text-align: center;
        }
    }
    
    /** RTL **/
    .rtl {
        direction: rtl;
        font-family: Tahoma, 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
    }
    
    .rtl table {
        text-align: right;
    }
    
    .rtl table tr td:nth-child(2) {
        text-align: left;
    }
    .btn{
        margin: 0px;
        width: 75px;
        font-size: 16px;
        padding: 10px 10px;
        position: relative;
        transition: color 0.15s, background-color 0.15s, border-color 0.15s, box-shadow 0.15s;
        font-size: 0.8rem;
        background-color: #B81F44;
        margin-left: 0.5rem !important;
        margin-right: 0.5rem !important;
        color: #fff;
        cursor: pointer;
    }
    .pdfliH{
      font-weight: bold;
      display: inline-block;
      min-width: 20%;
      width: 20%;
    }
    .table-bordered th, .table-bordered td{
      border:1px soild #000!important;
    }
    .table-bordered{
      border: none;
    }
    .table-bordered th, .table-bordered td {
    border: 1px solid #000!important;
    }
    tbody.dinesalereport {
        font-weight: 400;
        font-size: 0.69rem;
    }
    #indEmpCalTable{
      border-collapse: collapse!important;
    }
    </style>
    
    @section('content')
    <div class="row" style="margin-bottom: 30px;">
      <div class="col-md">
        <a id="pdfbtn" class="btn pdfbtn" onclick="generatePDF()">Export PDF</a>
      </div>
    </div>
    
    <div class="row" style="display: none;">
      <input type="text" id="clientcode" name="clientcode" value="{{ isset($clientDataPP->username) ? $clientDataPP->username : ''}}"/>
      <input type="text" id="datefrom" name="datefrom" value="{{ isset($date_from) ? date('d-m-Y', strtotime($date_from)) : '' }}"/>
      <input type="text" id="dateto" name="dateto" value="{{ isset($date_to) ? date('d-m-Y', strtotime($date_to)) : '' }}"/>
    </div>

<div class="invoice-box" id="indEmpPrintable">
  <h2 style="text-align: center;background-color: #0089ff; font-weight: bold; padding:10px; line-height: 25px; font-size: 25px; margin-bottom: 35px;">REPORTING – CONCISED SALE REPORT</h2>

  <ul style="text-decoration: none; list-style: none; padding:20px 30px; color:#000;">
    <li><span class="pdfliH">Client Name:</span>{{ isset($clientDataPP['clientname']) ? $clientDataPP['clientname'] : ''}}</li>
    <li><span class="pdfliH">Client ID:</span>{{ isset($clientDataPP['username']) ? $clientDataPP['username'] : ''}}</li>
    <li><span class="pdfliH">Vendor Name:</span>{{ isset($vendorDataPP['name']) ? $vendorDataPP['name'] : ''}}</li>
    <li><span class="pdfliH">Vendor ID:</span>{{ isset($vendorDataPP['username']) ? $vendorDataPP['username'] : ''}}</li>
    <li><span class="pdfliH">Location:</span>{{ isset($vendorDataPP['address']) ? $vendorDataPP['address'] : ''}}</li>
    <li><span class="pdfliH">Report Period:</span>{{ isset($date_from) ? date('d/m/Y', strtotime($date_from)) : '' }}&nbsp;-&nbsp;{{ isset($date_to) ? date('d/m/Y', strtotime($date_to)) : '' }}</li>
    <li><span class="pdfliH">Report Date:</span>{{ date('d/m/Y') }}</li>
  </ul>

  <table id="indEmpCalTable" class="table table-responsive table-striped table-bordered" style="width:100%">
    <thead>
      <tr>
        <!--<th>S.No.</th>-->
        <th>
          <!-- Date<br/>  -->
          Ordered By
        </th>
<!--        <th>Ordered By</th>-->
        <!--<th>Employee Id</th>-->
        <th>Breakfast<br/>(Quantity)<br/>Unit Price(Rs)</th>
        <th>Lunch<br/>(Quantity)<br/>Unit Price(Rs)</th>
        <th>Dinner<br/>(Quantity)<br/>Unit Price(Rs)</th>
        <th>Others<br/>(Quantity)<br/>Unit Price(Rs)</th>
        <th>Amount<br/>(Rs)</th>
        <!--<th>Ordered <br/>By</th>-->
      </tr>
    </thead>
    <tbody class="dinesalereport">
      @php $subtotal_cal = 0 @endphp
      @foreach($report_data as $key => $data)
      @php $total_cal = 0 @endphp
      <tr class="item">
        <td>
          <!-- {{ date('d/m/Y', strtotime($data->date)) }}<br/> -->
          {{ $data->employee->emp_name }}
        </td>
        <td>
            @if($data->breakfast!='')
                {{ $data->sum_price_breakfast }}
          <!-- @php $total_cal = $data->item_quantity*$data->item_price @endphp
          {{ $data->item_name }} <br/>({{ $data->item_quantity }} Quantity<br/>({{ $data->item_price }} Rs) -->
          @else
          -
          @endif
        </td>
        <td>
            @if($data->lunch!='')
                {{ $data->sum_price_lunch }}
                <!-- @php $total_cal = $data->item_quantity*$data->item_price @endphp
                {{ $data->item_name }} <br/>({{ $data->item_quantity }} Quantity)<br/>({{ $data->item_price }} Rs) -->
            @else
            -
            @endif
        </td>
        <td>
            @if($data->dinner!='')
                {{ $data->sum_price_dinner }}
                <!-- @php $total_cal = $data->item_quantity*$data->item_price @endphp
                {{ $data->item_name }} <br/>({{ $data->item_quantity }} Quantity)<br/>({{ $data->item_price }} Rs) -->
            @else
            -
            @endif
        </td>
        <td>
            @if($data->others!='')
                {{ $data->sum_price_others }}
                <!-- @php $total_cal = $data->item_quantity*$data->item_price @endphp
                {{ $data->item_name }} <br/>({{ $data->item_quantity }} Quantity)<br/>({{ $data->item_price }} Rs) -->
            @else
            -
            @endif
        </td>
        <td style="font-weight: 600;">
            {{$data->sum_price_breakfast + $data->sum_price_lunch + $data->sum_price_dinner + $data->sum_price_others}} Rs
            @php $subtotal_cal = $subtotal_cal + $data->sum_price_breakfast + $data->sum_price_lunch + $data->sum_price_dinner + $data->sum_price_others @endphp
          <!-- @php $subtotal_cal = $subtotal_cal + $total_cal @endphp
          {{ $total_cal}} Rs -->
        </td>
        <!--<td>{{ $data->employee->emp_name }}</td>-->
      </tr>
      @endforeach
    </tbody>
    <tfoot>
      <tr>
        <th>Total</th>
        <th>
        @php
        $datetime1 = new DateTime($date_from);
        $datetime2 = new DateTime($date_to);
        $interval = $datetime1->diff($datetime2);
        $days = $interval->format('%a');
        $days = $days + 1;
        @endphp
        {{ $days }} day(s)
        </th>
        <th></th>
        <th></th>
        <th></th>
        <!--<th></th>-->
<!--        <th></th>
        <th></th>-->
        <th>{{ $subtotal_cal }} Rs</th>
      </tr>
    </tfoot>
  </table>

<!--  <div class="foot-note">
    <span>*calories intake is approximate in no.</span><br>
    <span><strong>Note:</strong> average calories intake for a man and woman per day should be approx 2500 calories and 2000 calories respectively.</span>
  </div>-->
  
</div>


@section('customscript')
<link href="{{ asset('public/dataTable/dataTables.bootstrap.min.css') }}" rel="stylesheet">
<script type="text/javascript" src="{{ asset('public/dataTable/jquery.dataTables.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('public/dataTable/jquery-3.5.1.js') }}"></script>

<script type="text/javascript" src="{{ asset('public/js/html2pdf.bundle.min.js') }}"></script>

<script>
      $(document).ready(function () {
        $.noConflict();
        $('#table1DinningClientList').DataTable();
      });
</script>
    <script type="text/javascript">
        function generatePDF() {
            // Choose the element that our invoice is rendered in.
            //example_filter
            $("#indEmpCalTable_filter").hide();
            
            var clientcode = document.getElementById('clientcode').value;
            var datefrom = document.getElementById('datefrom').value;
            var dateto = document.getElementById('dateto').value;
            var pdffilename = clientcode + "-" + datefrom + "-to-" + dateto;
            
            const element = document.getElementById("indEmpPrintable");
            // Choose the element and save the PDF for our user.
//            html2pdf()
//              .from(element)
//              .save();
            html2pdf(element, {
              margin:       10.5,
              filename:     "Sale-Report-" + pdffilename,
              image:        { type: 'jpeg', quality: 0.98 },
              html2canvas:  { scale: 2, logging: true, dpi: 192, letterRendering: true },
              jsPDF:        { unit: 'mm', format: 'a4', orientation: 'portrait' },
              pagebreak:    { avoid: 'tr'}
            });
        }
        
        $(document).ready(function() {
          $('#indEmpCalTable').DataTable( {
            "paging":   false
//            "ordering": false,
//            "info":     false
          } );
        } );
    </script>
@endsection

@endsection
