@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Generate Dining Sale Report</h3>
                </div>
                <div class="card-body">
                    @if(isset($client))
                        <form action="{{ url('ICount/I-count/generate_diningsale_report') }}" method="POST">
                            @csrf
                            <input type="hidden" name="client_id" value="{{ $client->client_id }}">
                            <div class="container">
                                <div class="row">
                                    <div class="col">
                                        <div class="form-group">
                                            <label for="client_name">Client Name</label>
                                            <input type="text" name="client_name" value="{{ $client->client_name }}" class="form-control" readonly>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="form-group">
                                            <label for="client_code">Client Code</label>
                                            <input type="text" name="client_code" value="{{ $client->client_code }}" class="form-control" readonly>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="form-group">
                                            <label for="client_contact_name">Contact Person</label>
                                            <input type="text" name="client_contact_name" value="{{ $client->client_contact_name }}" class="form-control" readonly>
                                        </div>
                                    </div>
                                </div>
                                <div class="row d-flex justify-content-center">
<!--                                    <div class="col-4">
                                        <div class="form-group">
                                            <label for="qr_type">QR Type</label>
                                            <select name="qr_type" class="form-control" required>
                                                <option value="">Select QR Code Type</option>
                                                <option value="type1">Type 1</option>
                                                <option value="type2">Type 2</option>
                                                <option value="type3">Type 3</option>
                                                <option value="all">All</option>
                                            </select>
                                        </div>
                                    </div>-->
                                    <div class="col-4">
                                        <div class="form-group">
                                            <label for="date_from">Date from</label>
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="date_from" type="text" name="date_from" placeholder="Date from" autocomplete="off" required/>
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                            <!-- <input type="text" name="date_from" class="form-control"> -->
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group">
                                            <label for="date_to">Date To</label>
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="date_to" type="text" name="date_to" placeholder="Date to" autocomplete="off" required/>
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                            <!-- <input type="text" name="date_to" class="form-control"> -->
                                        </div>
                                    </div>                                    
                                </div>
                                <div class="row d-flex justify-content-center">
                                    <div class="col-3 d-flex justify-content-center">
                                        <div class="form-group">
                                            <input type="submit" class="btn btn-primary" value="Check Dining Sale Report" >
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    @elseif(isset($dates))
                        <?php
                            $date = "";
                        ?>
                        <div id="reportprintable">
                        <div class="container">
                            <div class="row d-flex justify-content-center" id="printable">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="client_name">Client Name</label>
                                        <input type="text" name="client_name" value="{{ $client_detail->client_name }}" class="form-control" readonly>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="client_code">Client Code</label>
                                        <input type="text" name="client_code" value="{{ $client_detail->client_code }}" class="form-control" readonly>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="client_contact_name">Contact Person</label>
                                        <input type="text" name="client_contact_name" value="{{ $client_detail->client_contact_name }}" class="form-control" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <table class="table table-hover">
                            <thead class="text-dark">
                                <tr>
                                    <th class="text-left" scope="col">S.No.</th> 
                                    <th class="text-left" scope="col">Date</th>
                                    <th class="text-left" scope="col">Meal Type</th>
                                    <th class="text-left" scope="col">QR Type</th>
                                    <th class="text-left" scope="col">Total Meal Count</th>
                                    <th class="text-left" scope="col">Per Meal Rate</th>
                                    <th class="text-left" scope="col">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $all_total = 0;
                                    $meal_count_total = 0;
                                    $meal_rate_total = 0;
                                ?>
                                @forelse($dates as $date)
                                    <tr>
                                        <th class="text-left" scope="col">{{ $loop->iteration }}</th> 
                                        <th class="text-left" scope="col">{{ $date->date }}</th>
                                        <th class="text-left" scope="col">{{ $date->meal_type }}</th>
                                        <th class="text-left" scope="col">{{ $date->qr_type }}</th>
                                        <th class="text-left" scope="col">{{ $date->meal_count }}</th>
                                        <th class="text-left" scope="col">{{ isset($date->meal_rate) ? $date->meal_rate : 'N/D' }}</th>
                                        <th class="text-left" scope="col">{{ $date->total }}</th>
                                    </tr>
                                    <?php
                                        $all_total = $all_total + $date->total;
                                        $meal_count_total = $meal_count_total + (isset($date->meal_count) ? $date->meal_count : 0);
                                        $meal_rate_total = $meal_rate_total + (isset($date->meal_rate) ? $date->meal_rate : 0);
                                    ?>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="6">Nothing Found Yet!!</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        <div class="container">
                            <div class="row justify-content-end">
                                <p class="badge badge-info mx-4">Total Amount: {{ $all_total }}</p>
                            </div>
                            <div class="row justify-content-center">
                                {{-- <form action="{{ url('ICount/I-count/create_report') }}" method="post"> --}}
                                    {{-- @csrf --}}
              {{--                       <input type="hidden" name="client_id" value="{{ $client_detail->client_id }}">
                                    <input type="hidden" name="client_name" value="{{ $client_detail->client_name }}">
                                    <input type="hidden" name="client_code" value="{{ $client_detail->client_code }}">
                                    <input type="hidden" name="date_from" value="{{ $client_detail->date_from }}">
                                    <input type="hidden" name="date_to" value="{{ $client_detail->date_to }}">
                                    <input type="hidden" name="meal_count_total" value="{{ $meal_count_total }}">
                                    <input type="hidden" name="meal_rate_total" value="{{ $meal_rate_total }}">
                                    <input type="hidden" name="total" value="{{ $all_total }}"> --}}
                                    <input type="submit" onclick="generatePDF()" value="Generate & Download Report" class="peterriver w-auto px-2">
                                {{-- </form> --}}
                            </div>
                        </div>
                        </div><!-- #reportprintable -->
                    @endif
                </div>
            </div>
        </div>
    </div>
    @section('customscript')
        <script type="text/javascript" src="{{ asset('public/js/html2pdf.bundle.min.js') }}"></script>
        <script>
            $(function () {
                // INITIALIZE DATEPICKER PLUGIN
                $('.datepicker').datepicker({
                    clearBtn: true,
                    endDate: new Date(),
                    format: "yyyy-mm-dd",
                    autoclose: true
                });
            });
        </script>
        <script type="text/javascript">
            function generatePDF() {
                // Choose the element that our invoice is rendered in.
                const element = document.getElementById("reportprintable");
                // Choose the element and save the PDF for our user.
                html2pdf()
                  .from(element)
                  .save();
            }
        </script>

    @endsection
@endsection