@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user" id="reloadCard">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>Client List</h3>
                </div>
                <div class="card-body p-1">
                    <div class="container">
                        <div class="row px-4 d-flex justify-content-end">
                            <div class="">
                                <input type="text" onkeyup="search(event);" placeholder="Search by name.." class="form-control p-2 h-75" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body py-1">
                    <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                        <table class="table table-hover">
                            <thead class="text-dark">
                                <tr>
                                    <th class="text-left" scope="col">S.No.</th> 
                                    <th class="text-left" scope="col">Name</th>
                                    <th class="text-left" scope="col">Contact Person Name</th>
                                    <th class="text-left" scope="col">Contact Person Number</th>
                                    <th class="text-left" scope="col">Location</th>
                                    <th class="text-center" scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody id="role_list">
                                <td colspan="7" align="center" id="load_data" style="display: none;">
                                    <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                       width="24px" height="30px" viewBox="0 0 24 30" style="enable-background:new 0 0 50 50;" xml:space="preserve">
                                      <rect x="0" y="0" width="4" height="10" fill="#333">
                                        <animateTransform attributeType="xml"
                                          attributeName="transform" type="translate"
                                          values="0 0; 0 20; 0 0"
                                          begin="0" dur="0.6s" repeatCount="indefinite" />
                                      </rect>
                                      <rect x="10" y="0" width="4" height="10" fill="#333">
                                        <animateTransform attributeType="xml"
                                          attributeName="transform" type="translate"
                                          values="0 0; 0 20; 0 0"
                                          begin="0.2s" dur="0.6s" repeatCount="indefinite" />
                                      </rect>
                                      <rect x="20" y="0" width="4" height="10" fill="#333">
                                        <animateTransform attributeType="xml"
                                          attributeName="transform" type="translate"
                                          values="0 0; 0 20; 0 0"
                                          begin="0.4s" dur="0.6s" repeatCount="indefinite" />
                                      </rect>
                                    </svg>
                                </td>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer p-0 my-2 border-bottom-0 border-top-0 text-center d-flex justify-content-center" style="align-self: center;color: #d45353;">
                    <h6>{{ isset($roles) ? $roles->links() : '' }}</h6>
                    <div class="d-flex justify-content-around">
                        <button class="btn btn-light mx-2 py-1 px-2 w-auto" onclick="previous_request(this);" id="previous">
                            <i class="fa fa-angle-left"></i>
                        </button>
                        <button class="btn btn-light mx-2 py-1 px-2 w-auto" onclick="next_request(this);" id="next">
                            <i class="fa fa-angle-right"></i>
                        </button>
                        <button class="btn btn-light mx-2 p-1 px-2 font-weight-bold" onclick="last_request(this);" id="last">Last</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @section('customscript')
        <script>
            var next = "";
            var previous = "";
            var last = "";
            $(function () {
                var link = "{{ url('ICount/I-count/invoice') }}";
                request_role_data(link);
            });
            function search(e){
                console.log(e.target.value);
                var search = e.target.value.trim();
                if(search !== null || search !== ""){
                    var link = "{{ url('ICount/I-count/invoice') }}" + "/" + search;
                    request_role_data(link);
                }
            }
            function request_role_data(link){
                $roles = $.ajax({
                    type        : 'GET',
                    url         : link,
                    beforeSend: function(){
                        $("td#load_data").css({'display': 'table-cell'});
                    },
                    success     : function(res){
                        console.log(res);
                        sort_list(res);
                        if(res.current_page == 1){
                            $('button#previous').prop('disabled', true);
                        }else{
                            $('button#previous').prop('disabled', false);
                        }
                        if(res.current_page == res.last_page){
                            $('button#next').prop('disabled', true);
                            $('button#last').prop('disabled', true);
                        }else{
                            $('button#next').prop('disabled', false);
                            $('button#last').prop('disabled', false);
                        }
                        next = res.next_page_url;
                        previous = res.prev_page_url;
                        last = res.last_page_url;
                    },
                    complete:function(data){
                        $("td#load_data").css({'display': 'none'});
                    },
                    error       : function(xhr, textStatus, errorThrown){
                        console.log(errorThrown, textStatus);
                    }
                });
            }
            function sort_list(res){
                $("tbody#role_list").empty();
                res.data.forEach((key, index) => {
                    var tr = document.createElement("tr");
                    index = ++index;
                    $(tr).html("\
                        <td class='text-left'>" + index + "</td>\
                        <td class='text-left'>" + key.name + "</td>\
                        <td class='text-left'>" + key.contactName.toString().split(", ").pop() + "</td>\
                        <td class='text-left'>" + key.contactNumber.toString().split(", ").pop() + "</td>\
                        <td class='text-left'>" + key.address + "</td>\
                        <td class='text-left'>\
                                <form method='POST' action='{{ url('ICount/I-count/client_all_qr_code') }}'>\
                                    <input type='hidden' name='_token' value='{{ csrf_token() }}' >\
                                    <input type='hidden' name='client_id' value='" + key.clientId + "' >\
                                    <input type='hidden' name='client_name' value='" + key.name + "' >\
                                    <input type='hidden' name='client_code' value='" + key.username + "' >\
                                    <input type='hidden' name='client_contact_name' value='" + key.contactName + "' >\
                                    <input type='submit' class='btn btn-info p-1 mx-1' value='See QR Code' >\
                                </form>\
                        </td>\
                    ");
                    document.getElementById('role_list').appendChild(tr);
                });
            }
            function next_request(){
                request_role_data(next);
            }
            function previous_request(){
                request_role_data(previous);
            }
            function last_request(){
                request_role_data(last);
            }
        </script>
    @endsection
@endsection
