@extends('layouts.masterDashboard')
@section('content')
<!--    <style>
        .table thead th{
            border-bottom:0 !important;
        }
    </style>-->
    <?php
        // dd($client);
    ?>
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Dining Employee List</h3>
                </div>
                <div class="card-body p-1">
                    <div class="container">
                        <div class="row px-4 d-flex justify-content-end">
<!--                            <form class="tdformmargin10">
                                <input type='submit' class='btn btn-success font-weight-bold mx-2' value='Assign QR Code' >
                            </form>-->
                            <form method='POST' action='{{ url('ICount/I-count/client_all_emp_cal_report') }}' class='tdformmargin10' style="margin: 0px;">
                                <input type='hidden' name='_token' value='{{ csrf_token() }}' >
                                <input type='hidden' name='client_id' value='{{ $client['client_id'] }}' >
                                <input type='submit' class='btn btn-success font-weight-bold mx-2' style="    height: 75%;line-height: 2px;"value='All Employee Calorie Report' >
                            </form>


                            <div class="">
                                <input type="text" onkeyup="search(event);" placeholder="Search by name.." class="form-control p-2 h-75" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                        <table class="table table-hover">
                            <thead class="text-dark">
                                <tr>
                                    <th class="text-left" scope="col">S.No.</th>
                                    <th class="text-left" scope="col">Client Code</th>
                                    <th class="text-left" scope="col">Employee Name</th>
                                    <th class="text-left" scope="col">Employee Id</th>
                                    <th class="text-left" scope="col">Designation</th>
                                    <th class="text-left" scope="col">QR Assign Status</th>
                                    <th class="text-left" scope="col">Assigned QR Code Number</th>
                                    <th scope="col" class="text-left">Action</th>
                                    <th scope="col" class="text-left">BMI</th>
                                </tr>
                            </thead>
                            <tbody id="role_list">
                                <td colspan="7" align="center" id="load_data" style="display: none;">
                                    <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                       width="24px" height="30px" viewBox="0 0 24 30" style="enable-background:new 0 0 50 50;" xml:space="preserve">
                                      <rect x="0" y="0" width="4" height="10" fill="#333">
                                        <animateTransform attributeType="xml"
                                          attributeName="transform" type="translate"
                                          values="0 0; 0 20; 0 0"
                                          begin="0" dur="0.6s" repeatCount="indefinite" />
                                      </rect>
                                      <rect x="10" y="0" width="4" height="10" fill="#333">
                                        <animateTransform attributeType="xml"
                                          attributeName="transform" type="translate"
                                          values="0 0; 0 20; 0 0"
                                          begin="0.2s" dur="0.6s" repeatCount="indefinite" />
                                      </rect>
                                      <rect x="20" y="0" width="4" height="10" fill="#333">
                                        <animateTransform attributeType="xml"
                                          attributeName="transform" type="translate"
                                          values="0 0; 0 20; 0 0"
                                          begin="0.4s" dur="0.6s" repeatCount="indefinite" />
                                      </rect>
                                    </svg>
                                </td>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer p-0 my-2 border-bottom-0 border-top-0 text-center d-flex justify-content-center" style="align-self: center;color: #d45353;">
                    <h6>{{ isset($roles) ? $roles->links() : '' }}</h6>
                    <div class="d-flex justify-content-around">
                        <button class="btn btn-light mx-2 py-1 px-2 w-auto" onclick="previous_request(this);" id="previous">
                            <i class="fa fa-angle-left"></i>
                        </button>
                        <button class="btn btn-light mx-2 py-1 px-2 w-auto" onclick="next_request(this);" id="next">
                            <i class="fa fa-angle-right"></i>
                        </button>
                        <button class="btn btn-light mx-2 p-1 px-2 font-weight-bold" onclick="last_request(this);" id="last">Last</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @section('customscript')
        <script>
            var next = "";
            var previous = "";
            var last = "";
            var client_id = "{{ $client['client_id'] }}";
            var client_code = "{{ $client['client_code'] }}";
            $(function () {
                var link = "{{ url('ICount/I-count/client_emp_type4_view_list') }}";
                request_role_data(link);
            });
            function search(e){
                console.log(e.target.value);
                var search = e.target.value.trim();
                if(search !== null || search !== ""){
                    var link = "{{ url('ICount/I-count/client_emp_type4_view_list') }}" + "/" + search;
                    request_role_data(link);
                }
            }
            function request_role_data(link){
                $roles = $.ajax({
                    type        : 'GET',
                    url         : link,
                    data: {
                        "_token"      : "{{ csrf_token() }}",
                        "client_id"   : client_id,
                        "client_code" : client_code,
                        'qr_type'     : "{{ $qr_type }}"
                    },
                    beforeSend: function(){
                        $("td#load_data").css({'display': 'table-cell'});
                    },
                    success     : function(res){
                        console.log(res);
                        sort_list(res);
                        if(res.current_page == 1){
                            $('button#previous').prop('disabled', true);
                        }else{
                            $('button#previous').prop('disabled', false);
                        }
                        if(res.current_page == res.last_page){
                            $('button#next').prop('disabled', true);
                            $('button#last').prop('disabled', true);
                        }else{
                            $('button#next').prop('disabled', false);
                            $('button#last').prop('disabled', false);
                        }
                        next = res.next_page_url;
                        previous = res.prev_page_url;
                        last = res.last_page_url;
                    },
                    complete:function(data){
                        $("td#load_data").css({'display': 'none'});
                    },
                    error       : function(xhr, textStatus, errorThrown){
                        console.log(errorThrown, textStatus);
                    }
                });
            }
            function sort_list(res){
                $("tbody#role_list").empty();
                res.data.forEach((key, index) => {
                    var tr = document.createElement("tr");
                    index = ++index;
                    bmi = key.emp_height== null || key.emp_weight == null ? '-': Math.round((key.emp_weight/((key.emp_height/100) *(key.emp_height/100)))*100 + Number.EPSILON)/100;
                    bg_color = bmi=='-'?'':(bmi<18.5?"#1b8bcf":(bmi>18.4&&bmi<25?"#46C20C":(bmi>=25&&bmi<30?'#F57C1E':"#D11503")));
                    $(tr).html("\
                        <td class='text-left'>" + index + "</td>\
                        <td class='text-left'>" + client_code + "</td>\
                        <td class='text-left'>" + key.emp_name + "</td>\
                        <td class='text-left'>" + key.emp_id + "</td>\
                        <td class='text-left'>" + key.designation + "</td>\
                        <td class='text-left'>" + (key.assign_qr_status == "yes" ? "<span class='badge badge-primary font-weight-light'>Assigned</span>" : (key.assign_qr_status == "no" ? "<span class='badge badge-warning font-weight-light'>Not Assigned</span>" : null)) + "</td>\
                        <td class='text-left'>" + key.qr_path.replace(/^.*\/|\.[^.]*$/g, '') + "</td>\
                        <td class='text-left'>\
                            <form method='POST' action='{{ url('ICount/I-count/client_emp_cal_report') }}' class='tdformmargin10'>\
                                <input type='hidden' name='_token' value='{{ csrf_token() }}' >\
                                <input type='hidden' name='id' value='" + key.assigned_emp_id + "' >\
                                <input type='hidden' name='emp_id' value='" + key.emp_id + "' >\
                                <input type='hidden' name='client_code' value='" + client_code + "' >\
                                <input type='hidden' name='client_id' value='" + client_id + "' >\
                                <input type='submit' class='btn btn-success font-weight-bold mx-2' value='Calorie Report' >\
                            </form>\
                        </td>\
                        <td class='text-left' style ='text-align: center !important;'>\
                            <div style = 'background-color:"+bg_color+"; border-radius: 0.2rem;'>"
                             + bmi + 
                        "</div></td>\
                    ");
                    document.getElementById('role_list').appendChild(tr);
                });
            }
            function next_request(){
                request_role_data(next);
            }
            function previous_request(){
                request_role_data(previous);
            }
            function last_request(){
                request_role_data(last);
            }
        </script>
    @endsection
@endsection