@extends('layouts.masterDashboard')
@section('content')
    <style>
        .filter-option{
            background: white;
        }
    </style>
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>Choose Event By Status</h3>
                </div>
                <div class="card-body">
                    @if(isset($noList))
                        <div class="d-flex justify-content-around">
                            <a href="{{ url('events/newList') }}" class="peterriver text-decoration-none text-white w-auto px-4">New Events</a>
                            <a href="{{ url('events/pendingList') }}" class="peterriver text-decoration-none text-white w-auto px-4">Pending Events</a>
                            <a href="{{ url('events/approvedList') }}" class="peterriver text-decoration-none text-white w-auto px-4">Approved Events</a>
                            <a href="{{ url('events/declineList') }}" class="peterriver text-decoration-none text-white w-auto px-4">Declined Events</a>
                        </div>
                    @elseif(isset($event))
                        <?php
                            // dd($type);
                        ?>
                        <form method="POST" action="{{ url('client/event/assign') }}">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="ticket" value="{{ $event->event_ticket }}" />
                            <div class="row">
                                <div class="col-md-4 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <label for="reservation_date">Date of Event</label>
                                        <div class="input-group p-0 shadow-sm">
                                            <input type="text" name="reservation_date" class="form-control" value="{{ date('d/m/Y', $event->event_date) }}" readonly />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="guests_num">Guests Number</label>
                                        <input type="text" name="guests_num" class="form-control" value="{{ $event->guest_number }}" readonly />
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="plateRate">Rates Per Plate</label>
                                        <input class="form-control shadow-sm" name="plateRate" value="{{ $event->rate_per_plate }}" readonly />
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="plate_rate">Type of Event</label>
                                        <input class="form-control shadow-sm" name="plate_rate" value="{{ $event->type_of_event }}" readonly />
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <h5 class="text-center d-flex justify-content-center"><span class="border-bottom">Decoration needed</span></h5>
                                        <div class="d-flex justify-content-around flex-wrap">
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventDecoration" value="yes" <?php echo empty($event->decoration_needed) ? "" : ($event->decoration_needed == "yes" ? "checked disabled" : "disabled") ?> />
                                                <span>Yes</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventDecoration" value="no" <?php echo empty($event->decoration_needed) ? "" : ($event->decoration_needed == "no" ? "checked disabled" : "disabled") ?> />
                                                <span>No</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <!-- <h5 class="text-center d-flex justify-content-center"><span class="border-bottom">Assign Vendor</span></h5>
                                        <div class="d-flex justify-content-between flex-wrap">
                                            <label class="radio mx-4 my-2" onclick="enable();">
                                                <input type="radio" name="vendorType" value="existingVendor" checked />
                                                <span>Choose Existing Vendor</span>
                                            </label>
                                            <label class="radio mx-4 my-2" onclick="disable();">
                                                <input type="radio" name="vendorType" value="otherVendor" />
                                                <span>Other Vendor</span>
                                            </label>
                                        </div> -->
                                        @if($type == 'assign')
                                            <label for="settled">Settled Plate Rate</label>
                                            <input type="tel" name="settled" id="settled" class="form-control" pattern="[0-9]+" />
                                        @elseif($type == 'view')
                                            <label for="settled">Settled Plate Rate</label>
                                            <input type="tel" name="settled" id="settled" class="form-control" value="{{ $event->settled_rate }}" readonly />
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group d-flex flex-column">
                                        <label for="existingVendor">Choose Existing Vendor</label>
                                        @if($type == 'assign')
                                            <select class="selectpicker w-auto bg-white" name="existingVendor[]" id="existingVendor" required <?php echo !isset($type) ? "" : ($type == "view" ? "disabled" : "") ?> multiple>
                                                <option value="" checked>Select Vendors</option>
                                                @if(isset($vendorList))
                                                    @forelse($vendorList as $value)
                                                        <option value="{{ $value->vendorId }}">{{ $value->name }}</option>
                                                    @empty
                                                        <option value="corporate">Seems No Vendor Yet!</option>
                                                    @endforelse
                                                @endif
                                            </select>
                                        @elseif($type == 'view')
                                            <input type="text" name="vendor" class="form-control" value="{{ $vendorList->name }}" readonly />
                                        @endif
                                    </div>
                                </div>
                            </div>
                            @if($type == 'assign')
                                <div class="row d-flex justify-content-center">
                                    <div class="assign">
                                        <button type="submit" class="turquoise" style="padding: .4rem 1rem;width: auto;font-size: 1rem;">Assign</button>
                                    </div>
                                </div>
                            @endif
                        </form>
                        @section('customscript')
                            <script>
                                $('select').selectpicker();
                            </script>
                        @endsection
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection